/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputReferences {
    private final Set<String> relativePaths = Sets.newLinkedHashSet();
    private final Set<String> absolutePaths = Sets.newLinkedHashSet();
    private final List<Integer> absolutePathLineNumbers = Lists.newArrayList();

    public List<String> getAbsolutePaths() {
        return Lists.newArrayList(this.absolutePaths);
    }

    public List<Integer> getAbsolutePathLineNumbers() {
        return this.absolutePathLineNumbers;
    }

    public void absolutePath(String path, int lineNumber) {
        if (this.absolutePaths.add(path)) {
            this.absolutePathLineNumbers.add(lineNumber);
        }
    }

    public boolean isEmpty() {
        return this.relativePaths.isEmpty() && this.absolutePaths.isEmpty();
    }

    public void absolutePaths(String[] paths, int[] lineNumbers) {
        this.absolutePaths.addAll(Arrays.asList(paths));
        for (int lineNumber : lineNumbers) {
            this.absolutePathLineNumbers.add(lineNumber);
        }
    }
}

