/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.update.AutoSvnUpdater;

public class SvnCheckinHandlerFactory
extends VcsCheckinHandlerFactory {
    public SvnCheckinHandlerFactory() {
        super(SvnVcs.getKey());
    }

    @NotNull
    protected CheckinHandler createVcsHandler(final CheckinProjectPanel panel) {
        final Project project = panel.getProject();
        final Collection commitRoots = panel.getRoots();
        CheckinHandler checkinHandler = new CheckinHandler(){
            private Collection<Change> myChanges;
            {
                this.myChanges = panel.getSelectedChanges();
            }

            public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
                return null;
            }

            public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
                if (executor instanceof LocalCommitExecutor) {
                    return CheckinHandler.ReturnResult.COMMIT;
                }
                SvnVcs vcs = SvnVcs.getInstance(project);
                MultiMap copiesInfo = SvnCheckinHandlerFactory.splitIntoCopies(vcs, this.myChanges);
                ArrayList repoUrls = new ArrayList();
                for (Map.Entry entry : copiesInfo.entrySet()) {
                    if (((Collection)entry.getValue()).size() <= 1) continue;
                    repoUrls.add(entry.getKey());
                }
                if (!repoUrls.isEmpty()) {
                    String join = StringUtil.join(repoUrls, (String)",\n");
                    int isOk = Messages.showOkCancelDialog((Project)project, (String)SvnBundle.message("checkin.different.formats.involved", repoUrls.size() > 1 ? 1 : 0, join), (String)"Subversion: Commit Will Split", (Icon)Messages.getWarningIcon());
                    return 0 == isOk ? CheckinHandler.ReturnResult.COMMIT : CheckinHandler.ReturnResult.CANCEL;
                }
                return CheckinHandler.ReturnResult.COMMIT;
            }

            public void includedChangesChanged() {
                this.myChanges = panel.getSelectedChanges();
            }

            public void checkinSuccessful() {
                if (SvnConfiguration.getInstance(project).isAutoUpdateAfterCommit()) {
                    VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)SvnVcs.getInstance(project));
                    final ArrayList<FilePath> paths = new ArrayList<FilePath>();
                    for (VirtualFile root : roots) {
                        boolean take = false;
                        for (VirtualFile commitRoot : commitRoots) {
                            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)commitRoot, (boolean)false)) continue;
                            take = true;
                            break;
                        }
                        if (!take) continue;
                        paths.add(VcsUtil.getFilePath((VirtualFile)root));
                    }
                    if (paths.isEmpty()) {
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoSvnUpdater.run(new AutoSvnUpdater(project, paths.toArray(new FilePath[paths.size()])), ActionInfo.UPDATE.getActionName());
                        }
                    }, ModalityState.NON_MODAL);
                }
            }
        };
        if (checkinHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkin/SvnCheckinHandlerFactory", "createVcsHandler"));
        }
        return checkinHandler;
    }

    @NotNull
    private static MultiMap<String, WorkingCopyFormat> splitIntoCopies(@NotNull SvnVcs vcs, @NotNull Collection<Change> changes) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/checkin/SvnCheckinHandlerFactory", "splitIntoCopies"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/checkin/SvnCheckinHandlerFactory", "splitIntoCopies"));
        }
        MultiMap result = MultiMap.createSet();
        SvnFileUrlMapping mapping = vcs.getSvnFileUrlMapping();
        for (Change change : changes) {
            RootUrlInfo path = mapping.getWcRootForFilePath(ChangesUtil.getFilePath((Change)change).getIOFile());
            if (path == null) continue;
            result.putValue((Object)path.getRepositoryUrl(), (Object)path.getFormat());
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkin/SvnCheckinHandlerFactory", "splitIntoCopies"));
        }
        return multiMap;
    }
}

