/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PrefixBasedPropertyReference;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlTagBase;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class PropertiesReferenceProvider
extends PsiReferenceProvider {
    private final boolean myDefaultSoft;

    public PropertiesReferenceProvider() {
        this(false);
    }

    public PropertiesReferenceProvider(boolean defaultSoft) {
        this.myDefaultSoft = defaultSoft;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/properties/PropertiesReferenceProvider", "acceptsTarget"));
        }
        return target instanceof IProperty;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/PropertiesReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/properties/PropertiesReferenceProvider", "getReferencesByElement"));
        }
        Object value = null;
        String bundleName = null;
        boolean propertyRefWithPrefix = false;
        boolean soft = this.myDefaultSoft;
        if (element instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            value = literalExpression.getValue();
            HashMap<String, Object> annotationParams = new HashMap<String, Object>();
            annotationParams.put("resourceBundle", null);
            if (JavaI18nUtil.mustBePropertyKey((PsiExpression)literalExpression, annotationParams)) {
                soft = false;
                Object resourceBundleName = annotationParams.get("resourceBundle");
                if (resourceBundleName instanceof PsiExpression) {
                    PsiExpression expr = (PsiExpression)resourceBundleName;
                    Object bundleValue = JavaPsiFacade.getInstance((Project)expr.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr);
                    bundleName = bundleValue == null ? null : bundleValue.toString();
                }
            }
        } else if (element instanceof XmlAttributeValue && PropertiesReferenceProvider.isNonDynamicAttribute(element)) {
            XmlTag parent;
            if (element.getTextLength() < 2) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            value = ((XmlAttributeValue)element).getValue();
            XmlAttribute attribute = (XmlAttribute)element.getParent();
            if ("key".equals(attribute.getName()) && "message".equals((parent = attribute.getParent()).getLocalName()) && Arrays.binarySearch(XmlUtil.JSTL_FORMAT_URIS, parent.getNamespace()) >= 0) {
                propertyRefWithPrefix = true;
            }
        }
        if (value instanceof String) {
            String text = (String)value;
            PrefixBasedPropertyReference reference = propertyRefWithPrefix ? new PrefixBasedPropertyReference(text, element, null, soft) : new PropertyReference(text, element, bundleName, soft);
            PsiReference[] psiReferenceArray = new PsiReference[]{reference};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    static boolean isNonDynamicAttribute(PsiElement element) {
        return PsiTreeUtil.getChildOfAnyType((PsiElement)element, (Class[])new Class[]{OuterLanguageElement.class, JspXmlTagBase.class}) == null;
    }
}

