/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.util.BekUtil;
import git4idea.log.GitLogProvider;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBekParentFixer {
    @NotNull
    private static final String MAGIC_TEXT = "Merge remote";
    @NotNull
    private static final VcsLogFilterCollection MAGIC_FILTER = GitBekParentFixer.createVcsLogFilterCollection();
    @NotNull
    private final Set<Hash> myWrongCommits;

    private GitBekParentFixer(@NotNull Set<Hash> wrongCommits) {
        if (wrongCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrongCommits", "git4idea/log/GitBekParentFixer", "<init>"));
        }
        this.myWrongCommits = wrongCommits;
    }

    @NotNull
    static GitBekParentFixer prepare(@NotNull VirtualFile root, @NotNull GitLogProvider provider) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitBekParentFixer", "prepare"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "git4idea/log/GitBekParentFixer", "prepare"));
        }
        if (!BekUtil.isBekEnabled()) {
            GitBekParentFixer gitBekParentFixer = new GitBekParentFixer(Collections.emptySet());
            if (gitBekParentFixer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitBekParentFixer", "prepare"));
            }
            return gitBekParentFixer;
        }
        GitBekParentFixer gitBekParentFixer = new GitBekParentFixer(GitBekParentFixer.getWrongCommits(provider, root));
        if (gitBekParentFixer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitBekParentFixer", "prepare"));
        }
        return gitBekParentFixer;
    }

    @NotNull
    TimedVcsCommit fixCommit(@NotNull TimedVcsCommit commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/log/GitBekParentFixer", "fixCommit"));
        }
        if (!this.myWrongCommits.contains(commit.getId())) {
            TimedVcsCommit timedVcsCommit = commit;
            if (timedVcsCommit == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitBekParentFixer", "fixCommit"));
            }
            return timedVcsCommit;
        }
        TimedVcsCommit timedVcsCommit = GitBekParentFixer.reverseParents(commit);
        if (timedVcsCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitBekParentFixer", "fixCommit"));
        }
        return timedVcsCommit;
    }

    @NotNull
    private static Set<Hash> getWrongCommits(@NotNull GitLogProvider provider, @NotNull VirtualFile root) throws VcsException {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "git4idea/log/GitBekParentFixer", "getWrongCommits"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitBekParentFixer", "getWrongCommits"));
        }
        List<TimedVcsCommit> commitsMatchingFilter = provider.getCommitsMatchingFilter(root, MAGIC_FILTER, -1);
        Set set = ContainerUtil.map2Set(commitsMatchingFilter, (Function)new Function<TimedVcsCommit, Hash>(){

            public Hash fun(TimedVcsCommit timedVcsCommit) {
                return (Hash)timedVcsCommit.getId();
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitBekParentFixer", "getWrongCommits"));
        }
        return set;
    }

    @NotNull
    private static TimedVcsCommit reverseParents(final @NotNull TimedVcsCommit commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/log/GitBekParentFixer", "reverseParents"));
        }
        TimedVcsCommit timedVcsCommit = new TimedVcsCommit(){

            public long getTimestamp() {
                return commit.getTimestamp();
            }

            @NotNull
            public Hash getId() {
                Hash hash = (Hash)commit.getId();
                if (hash == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitBekParentFixer$2", "getId"));
                }
                return hash;
            }

            @NotNull
            public List<Hash> getParents() {
                List list = ContainerUtil.reverse((List)commit.getParents());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitBekParentFixer$2", "getParents"));
                }
                return list;
            }
        };
        if (timedVcsCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitBekParentFixer", "reverseParents"));
        }
        return timedVcsCommit;
    }

    private static VcsLogFilterCollection createVcsLogFilterCollection() {
        final VcsLogTextFilter textFilter = new VcsLogTextFilter(){

            public boolean matchesCase() {
                return false;
            }

            public boolean isRegex() {
                return false;
            }

            @NotNull
            public String getText() {
                if (GitBekParentFixer.MAGIC_TEXT == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitBekParentFixer$3", "getText"));
                }
                return GitBekParentFixer.MAGIC_TEXT;
            }

            public boolean matches(@NotNull VcsCommitMetadata details) {
                if (details == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "git4idea/log/GitBekParentFixer$3", "matches"));
                }
                return details.getFullMessage().contains(GitBekParentFixer.MAGIC_TEXT);
            }
        };
        return new VcsLogFilterCollection(){

            @Nullable
            public VcsLogBranchFilter getBranchFilter() {
                return null;
            }

            @Nullable
            public VcsLogUserFilter getUserFilter() {
                return null;
            }

            @Nullable
            public VcsLogDateFilter getDateFilter() {
                return null;
            }

            @Nullable
            public VcsLogTextFilter getTextFilter() {
                return textFilter;
            }

            @Nullable
            public VcsLogHashFilter getHashFilter() {
                return null;
            }

            @Nullable
            public VcsLogStructureFilter getStructureFilter() {
                return null;
            }

            @Nullable
            public VcsLogRootFilter getRootFilter() {
                return null;
            }

            public boolean isEmpty() {
                return false;
            }

            @NotNull
            public List<VcsLogDetailsFilter> getDetailsFilters() {
                List<VcsLogTextFilter> list = Collections.singletonList(textFilter);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitBekParentFixer$4", "getDetailsFilters"));
                }
                return list;
            }
        };
    }
}

