/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.LintRequest;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.Scope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.android.inspections.klint.IntellijLintClient;
import org.jetbrains.android.inspections.klint.IntellijLintProject;

public class IntellijLintRequest
extends LintRequest {
    @NonNull
    private final com.intellij.openapi.project.Project myProject;
    @NonNull
    private final List<Module> myModules;
    @NonNull
    private final IntellijLintClient mLintClient;
    @Nullable
    private final List<VirtualFile> myFileList;
    @Nullable
    private Project myMainProject;
    private final boolean myIncremental;

    public IntellijLintRequest(@NonNull IntellijLintClient client, @NonNull com.intellij.openapi.project.Project project, @Nullable List<VirtualFile> fileList, @NonNull List<Module> modules, boolean incremental) {
        super(client, Collections.emptyList());
        this.mLintClient = client;
        this.myProject = project;
        this.myModules = modules;
        this.myFileList = fileList;
        this.myIncremental = incremental;
    }

    @NonNull
    com.intellij.openapi.project.Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    public EnumSet<Scope> getScope() {
        Collection<Project> projects;
        if (this.mScope == null && (projects = this.getProjects()) != null) {
            this.mScope = Scope.infer(projects);
            if (this.mScope.contains((Object)Scope.CLASS_FILE) || this.mScope.contains((Object)Scope.ALL_CLASS_FILES) || this.mScope.contains((Object)Scope.JAVA_LIBRARIES)) {
                this.mScope = EnumSet.copyOf(this.mScope);
                this.mScope.remove((Object)Scope.CLASS_FILE);
                this.mScope.remove((Object)Scope.ALL_CLASS_FILES);
                this.mScope.remove((Object)Scope.JAVA_LIBRARIES);
            }
        }
        return this.mScope;
    }

    @Override
    @Nullable
    public Collection<Project> getProjects() {
        if (this.mProjects == null) {
            if (this.myIncremental && this.myFileList != null && this.myFileList.size() == 1 && this.myModules.size() == 1) {
                Pair<Project, Project> pair = IntellijLintProject.createForSingleFile(this.mLintClient, this.myFileList.get(0), this.myModules.get(0));
                this.mProjects = pair.first != null ? Collections.singletonList(pair.first) : Collections.emptyList();
                this.myMainProject = (Project)pair.second;
            } else {
                this.mProjects = !this.myModules.isEmpty() ? IntellijLintProject.create(this.mLintClient, this.myFileList, this.myModules.toArray(new Module[this.myModules.size()])) : super.getProjects();
            }
        }
        return this.mProjects;
    }

    @Override
    @NonNull
    public Project getMainProject(@NonNull Project project) {
        if (this.myMainProject != null) {
            return this.myMainProject;
        }
        return super.getMainProject(project);
    }
}

