/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CharIterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsQualifierChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "validateQualifier", "", "qualifier", "", "kotlin-compiler"})
public final class JsQualifierChecker
implements AdditionalAnnotationChecker {
    public static final JsQualifierChecker INSTANCE;

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(entries, "entries");
        Intrinsics.checkParameterIsNotNull(actualTargets, "actualTargets");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        BindingContext bindingContext = trace.getBindingContext();
        for (KtAnnotationEntry ktAnnotationEntry : entries) {
            String argument;
            AnnotationDescriptor annotation2;
            if ((AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, ktAnnotationEntry) == null) {
                continue;
            }
            ClassifierDescriptor classifierDescriptor = annotation2.getType().getConstructor().getDeclarationDescriptor();
            if (Intrinsics.areEqual(classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null, AnnotationsUtils.JS_QUALIFIER_ANNOTATION) ^ true) continue;
            ConstantValue constantValue = (ConstantValue)CollectionsKt.singleOrNull((Iterable)annotation2.getAllValueArguments().values());
            Object object = constantValue != null ? constantValue.getValue() : null;
            if (!(object instanceof String)) {
                object = null;
            }
            if ((String)object == null) {
                continue;
            }
            if (this.validateQualifier(argument)) continue;
            KtValueArgumentList ktValueArgumentList = ktAnnotationEntry.getValueArgumentList();
            if (ktValueArgumentList == null) {
                Intrinsics.throwNpe();
            }
            KtValueArgument argumentPsi = ktValueArgumentList.getArguments().get(0);
            trace.report(ErrorsJs.WRONG_JS_QUALIFIER.on((KtValueArgument)((PsiElement)argumentPsi)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateQualifier(String qualifier) {
        boolean bl;
        List parts = StringsKt.split$default((CharSequence)qualifier, new char[]{'.'}, false, 0, 6, null);
        if (parts.isEmpty()) {
            return false;
        }
        Iterable $receiver$iv = parts;
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            String part = (String)element$iv;
            CharSequence charSequence = part;
            if (charSequence.length() <= 0) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            char c = part.charAt(0);
            if (!Character.isJavaIdentifierStart(c)) return false;
            CharSequence $receiver$iv2 = StringsKt.drop(part, 1);
            CharIterator charIterator = StringsKt.iterator($receiver$iv2);
            while (charIterator.hasNext()) {
                char element$iv2 = charIterator.nextChar();
                char p1 = element$iv2;
                char c2 = p1;
                if (Character.isJavaIdentifierPart(c2)) continue;
                return false;
            }
            boolean bl3 = true;
            if (!bl3) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private JsQualifierChecker() {
        INSTANCE = this;
    }

    static {
        new JsQualifierChecker();
    }
}

