/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class DebugInfoUtil {
    private static final TokenSet MAY_BE_UNRESOLVED = TokenSet.create((IElementType[])new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.NOT_IN});
    private static final TokenSet EXCLUDED = TokenSet.create((IElementType[])new IElementType[]{KtTokens.COLON, KtTokens.AS_KEYWORD, KtTokens.AS_SAFE, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.OROR, KtTokens.ANDAND, KtTokens.EQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.ELVIS, KtTokens.EXCLEXCL});

    public static void markDebugAnnotations(@NotNull PsiElement root, final @NotNull BindingContext bindingContext2, final @NotNull DebugInfoReporter debugInfoReporter) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        if (debugInfoReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugInfoReporter", "org/jetbrains/kotlin/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        final HashMap markedWithErrorElements = Maps.newHashMap();
        for (Diagnostic diagnostic : bindingContext2.getDiagnostics()) {
            DiagnosticFactory<?> factory2 = diagnostic.getFactory();
            if (Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains(diagnostic.getFactory())) {
                markedWithErrorElements.put((KtReferenceExpression)diagnostic.getPsiElement(), factory2);
                continue;
            }
            if (factory2 == Errors.SUPER_IS_NOT_AN_EXPRESSION || factory2 == Errors.SUPER_NOT_AVAILABLE) {
                KtSuperExpression superExpression = (KtSuperExpression)diagnostic.getPsiElement();
                markedWithErrorElements.put(superExpression.getInstanceReference(), factory2);
                continue;
            }
            if (factory2 == Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                markedWithErrorElements.put((KtSimpleNameExpression)diagnostic.getPsiElement(), factory2);
                continue;
            }
            if (factory2 != Errors.UNSUPPORTED) continue;
            for (KtReferenceExpression reference2 : PsiTreeUtil.findChildrenOfType((PsiElement)diagnostic.getPsiElement(), KtReferenceExpression.class)) {
                markedWithErrorElements.put(reference2, factory2);
            }
        }
        root.acceptChildren((PsiElementVisitor)new KtTreeVisitorVoid(){

            @Override
            public void visitForExpression(@NotNull KtForExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitForExpression"));
                }
                KtExpression range = expression2.getLoopRange();
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL);
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL);
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL);
                super.visitForExpression(expression2);
            }

            @Override
            public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                if (destructuringDeclaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destructuringDeclaration", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitDestructuringDeclaration"));
                }
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    this.reportIfDynamicCall(entry, entry, BindingContext.COMPONENT_RESOLVED_CALL);
                }
                super.visitDestructuringDeclaration(destructuringDeclaration);
            }

            @Override
            public void visitProperty(@NotNull KtProperty property2) {
                if (property2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitProperty"));
                }
                VariableDescriptor descriptor2 = bindingContext2.get(BindingContext.VARIABLE, property2);
                if (descriptor2 instanceof PropertyDescriptor && property2.getDelegate() != null) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
                    this.reportIfDynamicCall(property2.getDelegate(), propertyDescriptor, BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL);
                    this.reportIfDynamicCall(property2.getDelegate(), propertyDescriptor.getGetter(), BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL);
                    this.reportIfDynamicCall(property2.getDelegate(), propertyDescriptor.getSetter(), BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL);
                }
                super.visitProperty(property2);
            }

            @Override
            public void visitThisExpression(@NotNull KtThisExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitThisExpression"));
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, bindingContext2);
                if (resolvedCall2 != null) {
                    DebugInfoUtil.reportIfDynamic(expression2, resolvedCall2.getResultingDescriptor(), debugInfoReporter);
                }
                super.visitThisExpression(expression2);
            }

            @Override
            public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                Collection<? extends PsiElement> labelTargets;
                Collection<? extends DeclarationDescriptor> declarationDescriptors;
                PsiElement labelTarget;
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitReferenceExpression"));
                }
                super.visitReferenceExpression(expression2);
                if (!BindingContextUtils.isExpressionWithValidReference(expression2, bindingContext2)) {
                    return;
                }
                IElementType referencedNameElementType = null;
                if (expression2 instanceof KtSimpleNameExpression) {
                    KtSimpleNameExpression nameExpression2 = (KtSimpleNameExpression)expression2;
                    IElementType elementType = expression2.getNode().getElementType();
                    if (elementType == KtNodeTypes.OPERATION_REFERENCE) {
                        referencedNameElementType = nameExpression2.getReferencedNameElementType();
                        if (EXCLUDED.contains(referencedNameElementType)) {
                            return;
                        }
                    }
                    if (elementType == KtNodeTypes.LABEL || nameExpression2.getReferencedNameElementType() == KtTokens.THIS_KEYWORD) {
                        return;
                    }
                }
                debugInfoReporter.preProcessReference(expression2);
                String target = null;
                DeclarationDescriptor declarationDescriptor = bindingContext2.get(BindingContext.REFERENCE_TARGET, expression2);
                if (declarationDescriptor != null) {
                    target = declarationDescriptor.toString();
                    DebugInfoUtil.reportIfDynamic(expression2, declarationDescriptor, debugInfoReporter);
                }
                if (target == null && (labelTarget = bindingContext2.get(BindingContext.LABEL_TARGET, expression2)) != null) {
                    target = labelTarget.getText();
                }
                if (target == null && (declarationDescriptors = bindingContext2.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, expression2)) != null) {
                    target = "[" + declarationDescriptors.size() + " descriptors]";
                }
                if (target == null && (labelTargets = bindingContext2.get(BindingContext.AMBIGUOUS_LABEL_TARGET, expression2)) != null) {
                    target = "[" + labelTargets.size() + " elements]";
                }
                if (MAY_BE_UNRESOLVED.contains(referencedNameElementType)) {
                    return;
                }
                boolean resolved = target != null;
                boolean markedWithError = markedWithErrorElements.containsKey(expression2);
                if (expression2 instanceof KtArrayAccessExpression && markedWithErrorElements.containsKey(((KtArrayAccessExpression)expression2).getArrayExpression())) {
                    markedWithError = true;
                }
                KotlinType expressionType = bindingContext2.getType(expression2);
                DiagnosticFactory factory2 = (DiagnosticFactory)markedWithErrorElements.get(expression2);
                if (declarationDescriptor != null && (ErrorUtils.isError(declarationDescriptor) || ErrorUtils.containsErrorType(expressionType)) && factory2 != Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                    debugInfoReporter.reportElementWithErrorType(expression2);
                }
                if (resolved && markedWithError) {
                    if (Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains((Object)factory2)) {
                        debugInfoReporter.reportUnresolvedWithTarget(expression2, target);
                    }
                } else if (!resolved && !markedWithError) {
                    debugInfoReporter.reportMissingUnresolved(expression2);
                }
            }

            private <E extends KtElement, K, D extends CallableDescriptor> boolean reportIfDynamicCall(E element2, K key, WritableSlice<K, ResolvedCall<D>> slice) {
                ResolvedCall<D> resolvedCall2 = bindingContext2.get(slice, key);
                if (resolvedCall2 != null) {
                    return DebugInfoUtil.reportIfDynamic(element2, resolvedCall2.getResultingDescriptor(), debugInfoReporter);
                }
                return false;
            }
        });
    }

    private static boolean reportIfDynamic(KtElement element2, DeclarationDescriptor declarationDescriptor, DebugInfoReporter debugInfoReporter) {
        if (declarationDescriptor != null && DynamicCallsKt.isDynamic(declarationDescriptor)) {
            debugInfoReporter.reportDynamicCall(element2, declarationDescriptor);
            return true;
        }
        return false;
    }

    public static abstract class DebugInfoReporter {
        public void preProcessReference(@NotNull KtReferenceExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$DebugInfoReporter", "preProcessReference"));
            }
        }

        public abstract void reportElementWithErrorType(@NotNull KtReferenceExpression var1);

        public abstract void reportMissingUnresolved(@NotNull KtReferenceExpression var1);

        public abstract void reportUnresolvedWithTarget(@NotNull KtReferenceExpression var1, @NotNull String var2);

        public void reportDynamicCall(@NotNull KtElement element2, DeclarationDescriptor declarationDescriptor) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/DebugInfoUtil$DebugInfoReporter", "reportDynamicCall"));
            }
        }
    }
}

