/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsKt;
import org.jetbrains.kotlin.config.TargetPlatformKind;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\b*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\r"}, d2={"deserializeFacetSettings", "Lorg/jetbrains/kotlin/config/KotlinFacetSettings;", "element", "Lorg/jdom/Element;", "readV1Config", "readV2Config", "getOption", "name", "", "getOptionBody", "getOptionValue", "serializeFacetSettings", "", "idea-jps-common"})
public final class FacetSerializationKt {
    @Nullable
    public static final Element getOption(@NotNull Element $receiver, @NotNull String name2) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Iterable $receiver$iv = $receiver.getChildren("option");
            for (Object element$iv : $receiver$iv) {
                Element it = (Element)element$iv;
                if (!Intrinsics.areEqual((Object)it.getAttribute("name").getValue(), (Object)name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final String getOptionValue(@NotNull Element $receiver, String name2) {
        Element element2 = FacetSerializationKt.getOption($receiver, name2);
        return element2 != null && (element2 = element2.getAttribute("value")) != null ? element2.getValue() : null;
    }

    private static final Element getOptionBody(@NotNull Element $receiver, String name2) {
        Object object = FacetSerializationKt.getOption($receiver, name2);
        return object != null && (object = object.getChildren()) != null ? (Element)CollectionsKt.firstOrNull((List)object) : null;
    }

    private static final KotlinFacetSettings readV1Config(Element element2) {
        Element element3;
        Object object;
        TargetPlatformKind targetPlatformKind;
        Object v5;
        Object element$iv2;
        String apiLevel;
        String languageLevel;
        Boolean useProjectSettings;
        KotlinFacetSettings $receiver;
        KotlinFacetSettings kotlinFacetSettings;
        block16: {
            Element versionInfoElement;
            Boolean bl;
            $receiver = kotlinFacetSettings = new KotlinFacetSettings();
            String string = FacetSerializationKt.getOptionValue(element2, "useProjectSettings");
            if (string != null) {
                String string2 = string;
                bl = Boolean.parseBoolean(string2);
            } else {
                bl = null;
            }
            useProjectSettings = bl;
            Element element4 = versionInfoElement = FacetSerializationKt.getOptionBody(element2, "versionInfo");
            String targetPlatformName = element4 != null ? FacetSerializationKt.getOptionValue(element4, "targetPlatformName") : null;
            Element element5 = versionInfoElement;
            languageLevel = element5 != null ? FacetSerializationKt.getOptionValue(element5, "languageLevel") : null;
            Element element6 = versionInfoElement;
            apiLevel = element6 != null ? FacetSerializationKt.getOptionValue(element6, "apiLevel") : null;
            Iterable $receiver$iv = TargetPlatformKind.Companion.getALL_PLATFORMS();
            for (Object element$iv2 : $receiver$iv) {
                TargetPlatformKind it = (TargetPlatformKind)element$iv2;
                if (!Intrinsics.areEqual((Object)it.getDescription(), (Object)targetPlatformName)) continue;
                v5 = element$iv2;
                break block16;
            }
            v5 = null;
        }
        if ((targetPlatformKind = (TargetPlatformKind)v5) == null) {
            targetPlatformKind = TargetPlatformKind.Jvm.Companion.get(JvmTarget.DEFAULT);
        }
        TargetPlatformKind targetPlatform = targetPlatformKind;
        Element compilerInfoElement = FacetSerializationKt.getOptionBody(element2, "compilerInfo");
        Object $receiver2 = element$iv2 = new CompilerSettings();
        Element element7 = compilerInfoElement;
        if (element7 != null && (element7 = FacetSerializationKt.getOptionBody(element7, "compilerSettings")) != null) {
            Element $i$a$1$firstOrNull;
            Element compilerSettingsElement = $i$a$1$firstOrNull = element7;
            XmlSerializer.deserializeInto($receiver2, (Element)compilerSettingsElement);
        }
        Object compilerSettings = element$iv2;
        Element element8 = compilerInfoElement;
        Element commonArgumentsElement = element8 != null ? FacetSerializationKt.getOptionBody(element8, "_commonCompilerArguments") : null;
        Element element9 = compilerInfoElement;
        Element jvmArgumentsElement = element9 != null ? FacetSerializationKt.getOptionBody(element9, "k2jvmCompilerArguments") : null;
        Element element10 = compilerInfoElement;
        Element jsArgumentsElement = element10 != null ? FacetSerializationKt.getOptionBody(element10, "k2jsCompilerArguments") : null;
        CommonCompilerArguments compilerArguments = KotlinFacetSettingsKt.createCompilerArguments(targetPlatform);
        Element element11 = commonArgumentsElement;
        if (element11 != null) {
            Element it = object = element11;
            XmlSerializer.deserializeInto((Object)compilerArguments, (Element)it);
        }
        object = compilerArguments;
        if (object instanceof K2JVMCompilerArguments) {
            Element element12 = jvmArgumentsElement;
            if (element12 != null) {
                Element it = element3 = element12;
                XmlSerializer.deserializeInto((Object)compilerArguments, (Element)it);
            }
        } else if (object instanceof K2JSCompilerArguments) {
            Element element13 = jsArgumentsElement;
            if (element13 != null) {
                Element it = element3 = element13;
                XmlSerializer.deserializeInto((Object)compilerArguments, (Element)it);
            }
        }
        if (languageLevel != null) {
            compilerArguments.languageVersion = languageLevel;
        }
        if (apiLevel != null) {
            compilerArguments.apiVersion = apiLevel;
        }
        if (useProjectSettings != null) {
            $receiver.setUseProjectSettings(useProjectSettings);
        } else if (jvmArgumentsElement == null) {
            $receiver.setUseProjectSettings(false);
        }
        $receiver.setCompilerSettings((CompilerSettings)compilerSettings);
        $receiver.setCompilerArguments(compilerArguments);
        return kotlinFacetSettings;
    }

    private static final KotlinFacetSettings readV2Config(Element element2) {
        KotlinFacetSettings kotlinFacetSettings;
        block7: {
            String it;
            TargetPlatformKind<?> targetPlatformKind;
            Object v1;
            String string;
            KotlinFacetSettings $receiver;
            block6: {
                $receiver = kotlinFacetSettings = new KotlinFacetSettings();
                String string2 = element2.getAttributeValue("useProjectSettings");
                if (string2 != null) {
                    String string3;
                    String it2;
                    string = it2 = (string3 = string2);
                    KotlinFacetSettings kotlinFacetSettings2 = $receiver;
                    boolean bl = Boolean.parseBoolean(string);
                    kotlinFacetSettings2.setUseProjectSettings(bl);
                }
                String platformName = element2.getAttributeValue("platform");
                Iterable $receiver$iv = TargetPlatformKind.Companion.getALL_PLATFORMS();
                for (Object element$iv : $receiver$iv) {
                    TargetPlatformKind it3 = (TargetPlatformKind)element$iv;
                    if (!Intrinsics.areEqual((Object)it3.getDescription(), (Object)platformName)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            if ((targetPlatformKind = (TargetPlatformKind<?>)v1) == null) {
                targetPlatformKind = TargetPlatformKind.Companion.getDEFAULT_PLATFORM();
            }
            TargetPlatformKind<?> platformKind = targetPlatformKind;
            Element element3 = element2.getChild("compilerSettings");
            if (element3 != null) {
                it = string = element3;
                $receiver.setCompilerSettings(new CompilerSettings());
                CompilerSettings compilerSettings = $receiver.getCompilerSettings();
                if (compilerSettings == null) {
                    Intrinsics.throwNpe();
                }
                XmlSerializer.deserializeInto((Object)compilerSettings, (Element)it);
            }
            Element element4 = element2.getChild("compilerArguments");
            if (element4 == null) break block7;
            it = string = element4;
            $receiver.setCompilerArguments(KotlinFacetSettingsKt.createCompilerArguments(platformKind));
            CommonCompilerArguments commonCompilerArguments = $receiver.getCompilerArguments();
            if (commonCompilerArguments == null) {
                Intrinsics.throwNpe();
            }
            XmlSerializer.deserializeInto((Object)commonCompilerArguments, (Element)it);
        }
        return kotlinFacetSettings;
    }

    @NotNull
    public static final KotlinFacetSettings deserializeFacetSettings(@NotNull Element element2) {
        KotlinFacetSettings kotlinFacetSettings;
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        try {
            Attribute attribute = element2.getAttribute("version");
            n = attribute != null ? Integer.valueOf(attribute.getIntValue()) : null;
        }
        catch (DataConversionException e) {
            n = null;
        }
        Integer n2 = n;
        int version = n2 != null ? n2.intValue() : KotlinFacetSettings.Companion.getDEFAULT_VERSION();
        switch (version) {
            case 1: {
                kotlinFacetSettings = FacetSerializationKt.readV1Config(element2);
                break;
            }
            case 2: {
                kotlinFacetSettings = FacetSerializationKt.readV2Config(element2);
                break;
            }
            default: {
                kotlinFacetSettings = new KotlinFacetSettings();
            }
        }
        return kotlinFacetSettings;
    }

    public static final void serializeFacetSettings(@NotNull KotlinFacetSettings $receiver, @NotNull Element element2) {
        block3: {
            Element $receiver2;
            Element element3;
            Object it;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            SkipDefaultsSerializationFilter filter2 = new SkipDefaultsSerializationFilter();
            element2.setAttribute("version", String.valueOf(KotlinFacetSettings.Companion.getCURRENT_VERSION()));
            TargetPlatformKind<?> targetPlatformKind = $receiver.getTargetPlatformKind();
            if (targetPlatformKind != null) {
                it = object = targetPlatformKind;
                element2.setAttribute("platform", ((TargetPlatformKind)it).getDescription());
            }
            if (!$receiver.getUseProjectSettings()) {
                element2.setAttribute("useProjectSettings", String.valueOf($receiver.getUseProjectSettings()));
            }
            CompilerSettings compilerSettings = $receiver.getCompilerSettings();
            if (compilerSettings != null) {
                it = object = compilerSettings;
                $receiver2 = element3 = new Element("compilerSettings");
                XmlSerializer.serializeInto((Object)it, (Element)$receiver2, (SerializationFilter)((SerializationFilter)filter2));
                element2.addContent($receiver2);
            }
            CommonCompilerArguments commonCompilerArguments = $receiver.getCompilerArguments();
            if (commonCompilerArguments == null) break block3;
            it = object = commonCompilerArguments;
            $receiver2 = element3 = new Element("compilerArguments");
            XmlSerializer.serializeInto((Object)it, (Element)$receiver2, (SerializationFilter)((SerializationFilter)filter2));
            element2.addContent($receiver2);
        }
    }
}

