/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.openapi.util.TextRange;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\u001e\u001a\u00020\u0006*\u00020\u0012H\u0002J\f\u0010\u001f\u001a\u00020\t*\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/debugger/VariablesCollector;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "myLineRange", "Lcom/intellij/openapi/util/TextRange;", "myExpressions", "", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "(Lcom/intellij/openapi/util/TextRange;Ljava/util/Set;)V", "isRefToProperty", "", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitReferenceExpression", "createText", "isInRange", "idea"})
final class VariablesCollector
extends KtTreeVisitorVoid {
    private final TextRange myLineRange;
    private final Set<TextWithImports> myExpressions;

    @Override
    public void visitKtElement(@NotNull KtElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (this.isInRange(element2)) {
            super.visitKtElement(element2);
        }
    }

    @Override
    public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression2) {
        KtExpression selector;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (this.isInRange(expression2) && (selector = expression2.getSelectorExpression()) instanceof KtReferenceExpression && this.isRefToProperty((KtReferenceExpression)selector)) {
            this.myExpressions.add(this.createText(expression2));
            return;
        }
        super.visitQualifiedExpression(expression2);
    }

    private final boolean isRefToProperty(KtReferenceExpression expression2) {
        BindingContext context = ResolutionUtils.analyzeFully(expression2);
        DeclarationDescriptor descriptor2 = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, expression2);
        if (descriptor2 instanceof PropertyDescriptor) {
            PropertyGetterDescriptor getter = ((PropertyDescriptor)descriptor2).getGetter();
            return (getter == null || context.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getter) == null) && ((PropertyDescriptor)descriptor2).getCompileTimeInitializer() == null;
        }
        return false;
    }

    @Override
    public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (this.isInRange(expression2) && this.isRefToProperty(expression2)) {
            this.myExpressions.add(this.createText(expression2));
        }
        super.visitReferenceExpression(expression2);
    }

    private final boolean isInRange(@NotNull KtElement $receiver) {
        return this.myLineRange.intersects($receiver.getTextRange());
    }

    private final TextWithImports createText(@NotNull KtElement $receiver) {
        return (TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, $receiver.getText());
    }

    @Override
    public void visitClass(@NotNull KtClass klass2) {
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
    }

    @Override
    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
        Intrinsics.checkParameterIsNotNull((Object)lambdaExpression2, (String)"lambdaExpression");
    }

    public VariablesCollector(@NotNull TextRange myLineRange, @NotNull Set<TextWithImports> myExpressions) {
        Intrinsics.checkParameterIsNotNull((Object)myLineRange, (String)"myLineRange");
        Intrinsics.checkParameterIsNotNull(myExpressions, (String)"myExpressions");
        this.myLineRange = myLineRange;
        this.myExpressions = myExpressions;
    }
}

