/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrPropertyImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationGenerator;
import org.jetbrains.kotlin.psi2ir.generators.DelegatedPropertyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0016H\u0002J\f\u0010(\u001a\u00020)*\u00020\u001aH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/PropertyGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/Generator;", "declarationGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/DeclarationGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/DeclarationGenerator;)V", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "getDeclarationGenerator", "()Lorg/jetbrains/kotlin/psi2ir/generators/DeclarationGenerator;", "generateDefaultGetterBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "ktProperty", "Lorg/jetbrains/kotlin/psi/KtElement;", "getter", "Lorg/jetbrains/kotlin/descriptors/PropertyGetterDescriptor;", "generateDefaultSetterBody", "setter", "Lorg/jetbrains/kotlin/descriptors/PropertySetterDescriptor;", "generateDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "ktDelegate", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateGetterIfRequired", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "property", "generatePropertyDeclaration", "generatePropertyForPrimaryConstructorParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ktParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "generateReceiverExpressionForDefaultPropertyAccessor", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "generateSetterIfRequired", "generateSimpleProperty", "getPropertyDescriptor", "hasBackingField", "", "ir.psi2ir"})
public final class PropertyGenerator
implements Generator {
    @NotNull
    private final DeclarationGenerator declarationGenerator;

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.declarationGenerator.getContext();
    }

    @NotNull
    public final IrProperty generatePropertyDeclaration(@NotNull KtProperty ktProperty) {
        Intrinsics.checkParameterIsNotNull((Object)ktProperty, (String)"ktProperty");
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(ktProperty);
        KtPropertyDelegate ktDelegate = ktProperty.getDelegate();
        return ktDelegate != null ? this.generateDelegatedProperty(ktProperty, ktDelegate, propertyDescriptor) : this.generateSimpleProperty(ktProperty, propertyDescriptor);
    }

    @NotNull
    public final IrDeclaration generatePropertyForPrimaryConstructorParameter(@NotNull KtParameter ktParameter) {
        Intrinsics.checkParameterIsNotNull((Object)ktParameter, (String)"ktParameter");
        WritableSlice<KtParameter, VariableDescriptor> writableSlice = BindingContext.VALUE_PARAMETER;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.VALUE_PARAMETER");
        VariableDescriptor valueParameterDescriptor = (VariableDescriptor)GeneratorKt.getOrFail(this, writableSlice, ktParameter);
        WritableSlice<PsiElement, PropertyDescriptor> writableSlice2 = BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice2, (String)"BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER");
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)GeneratorKt.getOrFail(this, writableSlice2, ktParameter);
        int n = PsiUtilsKt.getStartOffset(ktParameter);
        int n2 = PsiUtilsKt.getEndOffset(ktParameter);
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor2, (String)"propertyDescriptor");
        IrPropertyImpl irProperty = new IrPropertyImpl(n, n2, irDeclarationOrigin, false, propertyDescriptor2);
        int n3 = PsiUtilsKt.getStartOffset(ktParameter);
        int n4 = PsiUtilsKt.getEndOffset(ktParameter);
        IrDeclarationOrigin irDeclarationOrigin2 = IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE;
        PropertyDescriptor propertyDescriptor3 = propertyDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor3, (String)"propertyDescriptor");
        IrFieldImpl irField = new IrFieldImpl(n3, n4, irDeclarationOrigin2, propertyDescriptor3);
        int n5 = PsiUtilsKt.getStartOffset(ktParameter);
        int n6 = PsiUtilsKt.getEndOffset(ktParameter);
        VariableDescriptor variableDescriptor = valueParameterDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)variableDescriptor, (String)"valueParameterDescriptor");
        IrGetValueImpl irGetParameter = new IrGetValueImpl(n5, n6, variableDescriptor, IrStatementOrigin.INITIALIZE_PROPERTY_FROM_PARAMETER.INSTANCE);
        irField.setInitializer(new IrExpressionBodyImpl(irGetParameter));
        irProperty.setBackingField(irField);
        PropertyGetterDescriptor propertyGetterDescriptor = propertyDescriptor.getGetter();
        if (propertyGetterDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Property declared in primary constructor has no getter: " + propertyDescriptor)));
        }
        PropertyGetterDescriptor getter = propertyGetterDescriptor;
        int n7 = PsiUtilsKt.getStartOffset(ktParameter);
        int n8 = PsiUtilsKt.getEndOffset(ktParameter);
        IrDeclarationOrigin irDeclarationOrigin3 = IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE;
        PropertyGetterDescriptor propertyGetterDescriptor2 = getter;
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor2, (String)"getter");
        IrFunctionImpl irGetter = new IrFunctionImpl(n7, n8, irDeclarationOrigin3, propertyGetterDescriptor2);
        irProperty.setGetter(irGetter);
        KtElement ktElement = ktParameter;
        PropertyGetterDescriptor propertyGetterDescriptor3 = getter;
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor3, (String)"getter");
        irGetter.setBody(this.generateDefaultGetterBody(ktElement, propertyGetterDescriptor3));
        if (propertyDescriptor.isVar()) {
            PropertySetterDescriptor propertySetterDescriptor = propertyDescriptor.getSetter();
            if (propertySetterDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Property declared in primary constructor has no setter: " + propertyDescriptor)));
            }
            PropertySetterDescriptor setter = propertySetterDescriptor;
            int n9 = PsiUtilsKt.getStartOffset(ktParameter);
            int n10 = PsiUtilsKt.getEndOffset(ktParameter);
            IrDeclarationOrigin irDeclarationOrigin4 = IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE;
            PropertySetterDescriptor propertySetterDescriptor2 = setter;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor2, (String)"setter");
            IrFunctionImpl irSetter = new IrFunctionImpl(n9, n10, irDeclarationOrigin4, propertySetterDescriptor2);
            KtElement ktElement2 = ktParameter;
            PropertySetterDescriptor propertySetterDescriptor3 = setter;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor3, (String)"setter");
            irSetter.setBody(this.generateDefaultSetterBody(ktElement2, propertySetterDescriptor3));
            irProperty.setSetter(irSetter);
        }
        return irProperty;
    }

    private final IrProperty generateDelegatedProperty(KtProperty ktProperty, KtPropertyDelegate ktDelegate, PropertyDescriptor propertyDescriptor) {
        KtExpression ktExpression = ktDelegate.getExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktDelegateExpression = ktExpression;
        CallableDescriptor callableDescriptor = propertyDescriptor;
        KtExpression ktExpression2 = ktDelegateExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktDelegateExpression");
        IrExpressionBody irDelegateInitializer = this.declarationGenerator.generateInitializerBody(callableDescriptor, ktExpression2);
        return new DelegatedPropertyGenerator(this.getContext()).generateDelegatedProperty(ktProperty, ktDelegate, propertyDescriptor, irDelegateInitializer);
    }

    private final IrProperty generateSimpleProperty(KtProperty ktProperty, PropertyDescriptor propertyDescriptor) {
        IrFieldImpl irFieldImpl;
        IrPropertyImpl irProperty = new IrPropertyImpl(PsiUtilsKt.getStartOffset(ktProperty), PsiUtilsKt.getEndOffset(ktProperty), IrDeclarationOrigin.DEFINED.INSTANCE, false, propertyDescriptor);
        if (this.hasBackingField(propertyDescriptor)) {
            IrExpressionBody irExpressionBody;
            IrFieldImpl irFieldImpl2;
            IrFieldImpl irFieldImpl3 = irFieldImpl2;
            irFieldImpl = irFieldImpl2;
            int n = PsiUtilsKt.getStartOffset(ktProperty);
            int n2 = PsiUtilsKt.getEndOffset(ktProperty);
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE;
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            KtExpression ktExpression = ktProperty.getInitializer();
            if (ktExpression != null) {
                KtExpression ktExpression2 = ktExpression;
                PropertyDescriptor propertyDescriptor3 = propertyDescriptor2;
                IrDeclarationOrigin irDeclarationOrigin2 = irDeclarationOrigin;
                int n3 = n2;
                int n4 = n;
                IrFieldImpl irFieldImpl4 = irFieldImpl3;
                IrFieldImpl irFieldImpl5 = irFieldImpl;
                KtExpression it = ktExpression2;
                CallableDescriptor callableDescriptor = propertyDescriptor;
                KtExpression ktExpression3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"it");
                IrExpressionBody irExpressionBody2 = this.declarationGenerator.generateInitializerBody(callableDescriptor, ktExpression3);
                irFieldImpl = irFieldImpl5;
                irFieldImpl3 = irFieldImpl4;
                n = n4;
                n2 = n3;
                irDeclarationOrigin = irDeclarationOrigin2;
                propertyDescriptor2 = propertyDescriptor3;
                irExpressionBody = irExpressionBody2;
            } else {
                irExpressionBody = null;
            }
            irFieldImpl3(n, n2, irDeclarationOrigin, propertyDescriptor2, irExpressionBody);
        } else {
            irFieldImpl = null;
        }
        IrFieldImpl irField = irFieldImpl;
        irProperty.setBackingField(irField);
        irProperty.setGetter(this.generateGetterIfRequired(ktProperty, propertyDescriptor));
        irProperty.setSetter(this.generateSetterIfRequired(ktProperty, propertyDescriptor));
        return irProperty;
    }

    private final boolean hasBackingField(@NotNull PropertyDescriptor $receiver) {
        WritableSlice<PropertyDescriptor, Boolean> writableSlice = BindingContext.BACKING_FIELD_REQUIRED;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.BACKING_FIELD_REQUIRED");
        Boolean bl = (Boolean)GeneratorKt.get(this, writableSlice, $receiver);
        return bl != null ? bl : false;
    }

    private final IrFunction generateGetterIfRequired(KtProperty ktProperty, PropertyDescriptor property2) {
        Object object;
        IrFunctionImpl irFunctionImpl;
        IrFunctionImpl irGetter;
        block7: {
            PropertyGetterDescriptor getter;
            block6: {
                IrFunctionImpl irFunctionImpl2;
                KtPropertyAccessor it;
                KtPropertyAccessor ktPropertyAccessor;
                KtPropertyAccessor ktGetter;
                PropertyGetterDescriptor propertyGetterDescriptor = property2.getGetter();
                if (propertyGetterDescriptor == null) {
                    return null;
                }
                getter = propertyGetterDescriptor;
                KtPropertyAccessor ktPropertyAccessor2 = ktGetter = ktProperty.getGetter();
                if (ktPropertyAccessor2 != null) {
                    it = ktPropertyAccessor = ktPropertyAccessor2;
                    int n = PsiUtilsKt.getStartOffset(it);
                    int n2 = PsiUtilsKt.getEndOffset(it);
                    IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
                    PropertyGetterDescriptor propertyGetterDescriptor2 = getter;
                    Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor2, (String)"getter");
                    irFunctionImpl2 = new IrFunctionImpl(n, n2, irDeclarationOrigin, propertyGetterDescriptor2);
                } else {
                    int n = PsiUtilsKt.getStartOffset(ktProperty);
                    int n3 = PsiUtilsKt.getEndOffset(ktProperty);
                    IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE;
                    PropertyGetterDescriptor propertyGetterDescriptor3 = getter;
                    Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor3, (String)"getter");
                    irFunctionImpl2 = new IrFunctionImpl(n, n3, irDeclarationOrigin, propertyGetterDescriptor3);
                }
                irFunctionImpl = irGetter = irFunctionImpl2;
                object = ktGetter;
                if (object == null || (object = ((KtPropertyAccessor)object).getBodyExpression()) == null) break block6;
                ktPropertyAccessor = object;
                IrFunctionImpl irFunctionImpl3 = irFunctionImpl;
                it = ktPropertyAccessor;
                PropertyGetterDescriptor propertyGetterDescriptor4 = getter;
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor4, (String)"getter");
                CallableDescriptor callableDescriptor = propertyGetterDescriptor4;
                KtPropertyAccessor ktPropertyAccessor3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor3, (String)"it");
                IrBody irBody = this.declarationGenerator.generateFunctionBody(callableDescriptor, ktPropertyAccessor3);
                irFunctionImpl = irFunctionImpl3;
                object = irBody;
                if (object != null) break block7;
            }
            KtElement ktElement = ktProperty;
            PropertyGetterDescriptor propertyGetterDescriptor = getter;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor, (String)"getter");
            object = this.generateDefaultGetterBody(ktElement, propertyGetterDescriptor);
        }
        irFunctionImpl.setBody((IrBody)object);
        return irGetter;
    }

    private final IrFunction generateSetterIfRequired(KtProperty ktProperty, PropertyDescriptor property2) {
        Object object;
        IrFunctionImpl irFunctionImpl;
        IrFunctionImpl irSetter;
        block8: {
            PropertySetterDescriptor setter;
            block7: {
                IrFunctionImpl irFunctionImpl2;
                KtPropertyAccessor it;
                KtPropertyAccessor ktPropertyAccessor;
                KtPropertyAccessor ktSetter;
                if (!property2.isVar()) {
                    return null;
                }
                PropertySetterDescriptor propertySetterDescriptor = property2.getSetter();
                if (propertySetterDescriptor == null) {
                    return null;
                }
                setter = propertySetterDescriptor;
                KtPropertyAccessor ktPropertyAccessor2 = ktSetter = ktProperty.getSetter();
                if (ktPropertyAccessor2 != null) {
                    it = ktPropertyAccessor = ktPropertyAccessor2;
                    int n = PsiUtilsKt.getStartOffset(it);
                    int n2 = PsiUtilsKt.getEndOffset(it);
                    IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
                    PropertySetterDescriptor propertySetterDescriptor2 = setter;
                    Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor2, (String)"setter");
                    irFunctionImpl2 = new IrFunctionImpl(n, n2, irDeclarationOrigin, propertySetterDescriptor2);
                } else {
                    int n = PsiUtilsKt.getStartOffset(ktProperty);
                    int n3 = PsiUtilsKt.getEndOffset(ktProperty);
                    IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE;
                    PropertySetterDescriptor propertySetterDescriptor3 = setter;
                    Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor3, (String)"setter");
                    irFunctionImpl2 = new IrFunctionImpl(n, n3, irDeclarationOrigin, propertySetterDescriptor3);
                }
                irFunctionImpl = irSetter = irFunctionImpl2;
                object = ktSetter;
                if (object == null || (object = ((KtPropertyAccessor)object).getBodyExpression()) == null) break block7;
                ktPropertyAccessor = object;
                IrFunctionImpl irFunctionImpl3 = irFunctionImpl;
                it = ktPropertyAccessor;
                PropertySetterDescriptor propertySetterDescriptor4 = setter;
                Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor4, (String)"setter");
                CallableDescriptor callableDescriptor = propertySetterDescriptor4;
                KtPropertyAccessor ktPropertyAccessor3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor3, (String)"it");
                IrBody irBody = this.declarationGenerator.generateFunctionBody(callableDescriptor, ktPropertyAccessor3);
                irFunctionImpl = irFunctionImpl3;
                object = irBody;
                if (object != null) break block8;
            }
            KtElement ktElement = ktProperty;
            PropertySetterDescriptor propertySetterDescriptor = setter;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor, (String)"setter");
            object = this.generateDefaultSetterBody(ktElement, propertySetterDescriptor);
        }
        irFunctionImpl.setBody((IrBody)object);
        return irSetter;
    }

    private final IrBlockBody generateDefaultGetterBody(KtElement ktProperty, PropertyGetterDescriptor getter) {
        PropertyDescriptor property2 = getter.getCorrespondingProperty();
        IrBlockBodyImpl irBody = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset((PsiElement)ktProperty), PsiUtilsKt.getEndOffset((PsiElement)ktProperty));
        PropertyDescriptor propertyDescriptor = property2;
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"property");
        IrExpression receiver = this.generateReceiverExpressionForDefaultPropertyAccessor(ktProperty, propertyDescriptor);
        List<IrStatement> list2 = irBody.getStatements();
        int n = PsiUtilsKt.getStartOffset((PsiElement)ktProperty);
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)ktProperty);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getNothingType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.nothingType");
        KotlinType kotlinType = simpleType2;
        CallableDescriptor callableDescriptor = getter;
        int n3 = PsiUtilsKt.getStartOffset((PsiElement)ktProperty);
        int n4 = PsiUtilsKt.getEndOffset((PsiElement)ktProperty);
        PropertyDescriptor propertyDescriptor2 = property2;
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor2, (String)"property");
        list2.add(new IrReturnImpl(n, n2, kotlinType, callableDescriptor, new IrGetFieldImpl(n3, n4, propertyDescriptor2, receiver, null, null, 48, null)));
        return irBody;
    }

    private final IrBlockBody generateDefaultSetterBody(KtElement ktProperty, PropertySetterDescriptor setter) {
        PropertyDescriptor property2 = setter.getCorrespondingProperty();
        IrBlockBodyImpl irBody = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset((PsiElement)ktProperty), PsiUtilsKt.getEndOffset((PsiElement)ktProperty));
        PropertyDescriptor propertyDescriptor = property2;
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"property");
        IrExpression receiver = this.generateReceiverExpressionForDefaultPropertyAccessor(ktProperty, propertyDescriptor);
        ValueParameterDescriptor setterParameter = (ValueParameterDescriptor)CollectionsKt.single(setter.getValueParameters());
        List<IrStatement> list2 = irBody.getStatements();
        int n = PsiUtilsKt.getStartOffset((PsiElement)ktProperty);
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)ktProperty);
        PropertyDescriptor propertyDescriptor2 = property2;
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor2, (String)"property");
        int n3 = PsiUtilsKt.getStartOffset((PsiElement)ktProperty);
        int n4 = PsiUtilsKt.getEndOffset((PsiElement)ktProperty);
        ValueParameterDescriptor valueParameterDescriptor = setterParameter;
        Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"setterParameter");
        list2.add(new IrSetFieldImpl(n, n2, propertyDescriptor2, receiver, new IrGetValueImpl(n3, n4, valueParameterDescriptor, null, 8, null), null, null, 96, null));
        return irBody;
    }

    private final IrExpression generateReceiverExpressionForDefaultPropertyAccessor(KtElement ktProperty, PropertyDescriptor property2) {
        IrGetValueImpl irGetValueImpl;
        DeclarationDescriptor containingDeclaration = property2.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            int n = PsiUtilsKt.getStartOffset((PsiElement)ktProperty);
            int n2 = PsiUtilsKt.getEndOffset((PsiElement)ktProperty);
            ReceiverParameterDescriptor receiverParameterDescriptor = ((ClassDescriptor)containingDeclaration).getThisAsReceiverParameter();
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"containingDeclaration.thisAsReceiverParameter");
            irGetValueImpl = new IrGetValueImpl(n, n2, receiverParameterDescriptor, null, 8, null);
        } else {
            irGetValueImpl = null;
        }
        IrGetValueImpl receiver = irGetValueImpl;
        return receiver;
    }

    private final PropertyDescriptor getPropertyDescriptor(KtProperty ktProperty) {
        WritableSlice<PsiElement, VariableDescriptor> writableSlice = BindingContext.VARIABLE;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.VARIABLE");
        VariableDescriptor variableDescriptor = (VariableDescriptor)GeneratorKt.getOrFail(this, writableSlice, ktProperty);
        VariableDescriptor variableDescriptor2 = variableDescriptor;
        if (!(variableDescriptor2 instanceof PropertyDescriptor)) {
            variableDescriptor2 = null;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor2;
        if (propertyDescriptor == null) {
            String string = "not a property?";
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        return propertyDescriptor2;
    }

    @NotNull
    public final DeclarationGenerator getDeclarationGenerator() {
        return this.declarationGenerator;
    }

    public PropertyGenerator(@NotNull DeclarationGenerator declarationGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)declarationGenerator, (String)"declarationGenerator");
        this.declarationGenerator = declarationGenerator;
    }
}

