/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.HeaderImplDeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002@AB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J(\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u00020\r2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bH\u0002J,\u0010\u001d\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u001c\u0010\u001f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001cH\u0002J0\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J&\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020#2\u0006\u0010$\u001a\u00020.2\u0006\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\rJ \u0010/\u001a\u00020!2\u0006\u0010-\u001a\u00020#2\u0006\u0010$\u001a\u00020.2\u0006\u0010&\u001a\u00020'H\u0002J>\u00100\u001a\u00020\r\"\u0004\b\u0000\u00101\"\u0004\b\u0001\u001022\u0006\u00103\u001a\u0002H12\u0006\u00104\u001a\u0002H12\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u0002H206H\u0082\b\u00a2\u0006\u0002\u00107JE\u00108\u001a\u00020\r\"\u0004\b\u0000\u00101\"\u0004\b\u0001\u001022\f\u00103\u001a\b\u0012\u0004\u0012\u0002H10\u001b2\f\u00104\u001a\b\u0012\u0004\u0012\u0002H10\u001b2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u0002H206H\u0082\bJ\u0010\u00109\u001a\b\u0012\u0004\u0012\u00020;0:*\u00020;J\u0010\u0010<\u001a\b\u0012\u0004\u0012\u00020\n0:*\u00020\nJ\u001e\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0:*\u00020\u00112\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "moduleToCheck", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "getModuleToCheck", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "areCompatibleCallables", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility;", "a", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "b", "checkImpl", "", "parentSubstitutor", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Substitutor;", "areCompatibleClassScopes", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "substitutor", "areCompatibleClassifiers", "other", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "areCompatibleFunctions", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "areCompatibleProperties", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "areCompatibleTypeLists", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "areCompatibleTypeParameters", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "areCompatibleTypes", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkHeaderDeclarationHasImplementation", "reportOn", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "checkImplementationHasHeaderDeclaration", "equalBy", "T", "K", "first", "second", "selector", "Lkotlin/Function1;", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Z", "equalsBy", "findClassifiersFromTheSameModule", "", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "findNamesakesFromTheSameModule", "getMembers", "name", "Lorg/jetbrains/kotlin/name/Name;", "Compatibility", "Substitutor", "frontend"})
public final class HeaderImplDeclarationChecker
implements DeclarationChecker {
    @Nullable
    private final ModuleDescriptor moduleToCheck;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2, @NotNull LanguageVersionSettings languageVersionSettings) {
        boolean checkImpl;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (!languageVersionSettings.supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            return;
        }
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return;
        }
        boolean bl = checkImpl = !languageVersionSettings.isFlagEnabled(AnalysisFlags.getMultiPlatformDoNotCheckImpl());
        if (((MemberDescriptor)descriptor2).isHeader() && declaration2.hasModifier(KtTokens.HEADER_KEYWORD)) {
            this.checkHeaderDeclarationHasImplementation(declaration2, (MemberDescriptor)descriptor2, diagnosticHolder, checkImpl);
        } else if (checkImpl && ((MemberDescriptor)descriptor2).isImpl() && declaration2.hasModifier(KtTokens.IMPL_KEYWORD)) {
            this.checkImplementationHasHeaderDeclaration(declaration2, (MemberDescriptor)descriptor2, diagnosticHolder);
        }
    }

    public final void checkHeaderDeclarationHasImplementation(@NotNull KtDeclaration reportOn, @NotNull MemberDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, boolean checkImpl) {
        Map compatibility;
        Object object;
        List list$iv$iv;
        ArrayList answer$iv$iv$iv;
        Object value$iv$iv$iv;
        Compatibility key$iv$iv;
        Object $receiver$iv$iv$iv;
        Iterator iterator2;
        MemberDescriptor impl;
        Object element$iv$iv2;
        Iterable $receiver$iv$iv;
        Object destination$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        MemberDescriptor memberDescriptor = descriptor2;
        if (memberDescriptor instanceof CallableMemberDescriptor) {
            Iterable iterable = $receiver$iv = (Iterable)this.findNamesakesFromTheSameModule((CallableMemberDescriptor)descriptor2);
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv) {
                impl = (CallableMemberDescriptor)element$iv$iv2;
                if (!(Intrinsics.areEqual((Object)descriptor2, (Object)impl) ^ true && DescriptorToSourceUtils.getSourceFromDescriptor(impl) instanceof KtElement)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new LinkedHashMap();
            iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object object2;
                $receiver$iv$iv$iv = destination$iv$iv;
                element$iv$iv2 = iterator2.next();
                impl = (CallableMemberDescriptor)element$iv$iv2;
                key$iv$iv = HeaderImplDeclarationChecker.areCompatibleCallables$default(this, (CallableMemberDescriptor)descriptor2, impl, checkImpl, null, 8, null);
                value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv2);
            }
            object = destination$iv$iv;
        } else if (memberDescriptor instanceof ClassDescriptor) {
            $receiver$iv$iv = $receiver$iv = (Iterable)this.findClassifiersFromTheSameModule((ClassifierDescriptorWithTypeParameters)descriptor2);
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv) {
                impl = (ClassifierDescriptorWithTypeParameters)element$iv$iv2;
                if (!(Intrinsics.areEqual((Object)descriptor2, (Object)impl) ^ true && DescriptorToSourceUtils.getSourceFromDescriptor(impl) instanceof KtElement)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new LinkedHashMap();
            iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object object3;
                $receiver$iv$iv$iv = destination$iv$iv;
                element$iv$iv2 = iterator2.next();
                impl = (ClassifierDescriptorWithTypeParameters)element$iv$iv2;
                key$iv$iv = this.areCompatibleClassifiers((ClassDescriptor)descriptor2, (ClassifierDescriptor)((Object)impl), checkImpl);
                value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv2);
            }
            object = destination$iv$iv;
        } else {
            object = compatibility = null;
        }
        if (compatibility != null && !compatibility.containsKey(Compatibility.Compatible.INSTANCE)) {
            boolean $receiver$iv22;
            block16: {
                boolean bl;
                Iterable $receiver$iv22 = compatibility.keySet();
                for (Object element$iv : $receiver$iv22) {
                    Compatibility it = (Compatibility)element$iv;
                    if (it instanceof Compatibility.Incompatible) continue;
                    bl = false;
                    break block16;
                }
                bl = $receiver$iv22 = true;
            }
            if (_Assertions.ENABLED && !$receiver$iv22) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Map incompatibility = compatibility;
            PsiElement psiElement2 = reportOn;
            ModuleDescriptor moduleDescriptor = this.moduleToCheck;
            if (moduleDescriptor == null) {
                moduleDescriptor = DescriptorUtilsKt.getModule(descriptor2);
            }
            diagnosticHolder.report(Errors.HEADER_WITHOUT_IMPLEMENTATION.on((KtDeclaration)psiElement2, descriptor2, moduleDescriptor, incompatibility));
        }
    }

    private final void checkImplementationHasHeaderDeclaration(KtDeclaration reportOn, MemberDescriptor descriptor2, DiagnosticSink diagnosticHolder) {
        boolean hasDeclaration;
        block14: {
            boolean bl;
            Function1<ClassifierDescriptorWithTypeParameters, ClassDescriptor> findDeclarationForClass$ = new Function1<ClassifierDescriptorWithTypeParameters, ClassDescriptor>(this){
                final /* synthetic */ HeaderImplDeclarationChecker this$0;

                @Nullable
                public final ClassDescriptor invoke(@NotNull ClassifierDescriptorWithTypeParameters $receiver) {
                    Object v1;
                    Object v0;
                    block2: {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        Iterable $receiver$iv = this.this$0.findClassifiersFromTheSameModule($receiver);
                        for (T element$iv : $receiver$iv) {
                            ClassifierDescriptorWithTypeParameters declaration2 = (ClassifierDescriptorWithTypeParameters)element$iv;
                            if (!(Intrinsics.areEqual((Object)$receiver, (Object)declaration2) ^ true && declaration2 instanceof ClassDescriptor && ((ClassDescriptor)declaration2).isHeader() && Intrinsics.areEqual((Object)HeaderImplDeclarationChecker.access$areCompatibleClassifiers(this.this$0, (ClassDescriptor)declaration2, $receiver, false), (Object)Compatibility.Compatible.INSTANCE))) continue;
                            v0 = element$iv;
                            break block2;
                        }
                        v0 = v1 = null;
                    }
                    if (!(v0 instanceof ClassDescriptor)) {
                        v1 = null;
                    }
                    return v1;
                }
                {
                    this.this$0 = headerImplDeclarationChecker;
                    super(1);
                }
            };
            MemberDescriptor memberDescriptor = descriptor2;
            if (memberDescriptor instanceof CallableMemberDescriptor) {
                Object object;
                DeclarationDescriptor container2 = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor = container2;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    ClassDescriptor classDescriptor = findDeclarationForClass$.invoke((ClassifierDescriptorWithTypeParameters)container2);
                    Collection collection = classDescriptor != null ? this.getMembers(classDescriptor, ((CallableMemberDescriptor)descriptor2).getName()) : null;
                    object = collection;
                    if (object == null) {
                        object = CollectionsKt.emptyList();
                    }
                } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                    object = this.findNamesakesFromTheSameModule((CallableMemberDescriptor)descriptor2);
                } else {
                    return;
                }
                Collection candidates2 = object;
                Iterable $receiver$iv = candidates2;
                for (Object element$iv : $receiver$iv) {
                    Substitutor substitutor3;
                    Substitutor substitutor4;
                    CallableMemberDescriptor declaration2 = (CallableMemberDescriptor)element$iv;
                    if (container2 instanceof ClassDescriptor) {
                        DeclarationDescriptor declarationDescriptor2 = declaration2.getContainingDeclaration();
                        if (declarationDescriptor2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        ClassDescriptor headerClass = (ClassDescriptor)declarationDescriptor2;
                        List<TypeParameterDescriptor> list2 = headerClass.getDeclaredTypeParameters();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"headerClass.declaredTypeParameters");
                        List<TypeParameterDescriptor> list3 = ((ClassDescriptor)container2).getDeclaredTypeParameters();
                        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"container.declaredTypeParameters");
                        substitutor4 = new Substitutor(list2, list3, null, 4, null);
                    } else {
                        substitutor4 = substitutor3 = null;
                    }
                    if (!(Intrinsics.areEqual((Object)descriptor2, (Object)declaration2) ^ true && declaration2.isHeader() && Intrinsics.areEqual((Object)this.areCompatibleCallables(declaration2, (CallableMemberDescriptor)descriptor2, false, substitutor3), (Object)Compatibility.Compatible.INSTANCE))) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            } else {
                bl = memberDescriptor instanceof ClassifierDescriptorWithTypeParameters ? findDeclarationForClass$.invoke((ClassifierDescriptorWithTypeParameters)descriptor2) != null : (hasDeclaration = false);
            }
        }
        if (!hasDeclaration) {
            KtModifierList ktModifierList = reportOn.getModifierList();
            if (ktModifierList == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement2 = ktModifierList.getModifier(KtTokens.IMPL_KEYWORD);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            diagnosticHolder.report(Errors.IMPLEMENTATION_WITHOUT_HEADER.on(psiElement2));
        }
    }

    @NotNull
    public final Collection<CallableMemberDescriptor> findNamesakesFromTheSameModule(@NotNull CallableMemberDescriptor $receiver) {
        Collection<CallableMemberDescriptor> collection;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) {
            declarationDescriptor = null;
        }
        if ((object = (PackageFragmentDescriptor)declarationDescriptor) == null || (object = object.getFqName()) == null) {
            return CollectionsKt.emptyList();
        }
        Object packageFqName = object;
        ModuleDescriptor moduleDescriptor = this.moduleToCheck;
        if (moduleDescriptor == null) {
            moduleDescriptor = DescriptorUtilsKt.getModule($receiver);
        }
        ModuleDescriptor myModule = moduleDescriptor;
        MemberScope scope2 = myModule.getPackage((FqName)packageFqName).getMemberScope();
        CallableMemberDescriptor callableMemberDescriptor = $receiver;
        if (callableMemberDescriptor instanceof FunctionDescriptor) {
            Name name2 = ((FunctionDescriptor)$receiver).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"name");
            collection = scope2.getContributedFunctions(name2, NoLookupLocation.FOR_ALREADY_TRACKED);
        } else if (callableMemberDescriptor instanceof PropertyDescriptor) {
            Name name3 = ((PropertyDescriptor)$receiver).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
            collection = scope2.getContributedVariables(name3, NoLookupLocation.FOR_ALREADY_TRACKED);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unsupported declaration: " + $receiver)));
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ClassifierDescriptorWithTypeParameters> findClassifiersFromTheSameModule(@NotNull ClassifierDescriptorWithTypeParameters $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ModuleDescriptor moduleDescriptor = this.moduleToCheck;
        if (moduleDescriptor == null) {
            moduleDescriptor = DescriptorUtilsKt.getModule($receiver);
        }
        ModuleDescriptor myModule = moduleDescriptor;
        ClassId classId = DescriptorUtilsKt.getClassId($receiver);
        if (classId == null) {
            return CollectionsKt.emptyList();
        }
        ClassId classId2 = classId;
        findClassifiersFromTheSameModule.1 getAllClassifiers$ = findClassifiersFromTheSameModule.1.INSTANCE;
        List<Name> segments = classId2.getRelativeClassName().pathSegments();
        FqName fqName2 = classId2.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
        MemberScope memberScope2 = myModule.getPackage(fqName2).getMemberScope();
        Object object = CollectionsKt.first(segments);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"segments.first()");
        Collection classifiers = getAllClassifiers$.invoke(memberScope2, (Name)object);
        for (Name name2 : segments.subList(1, segments.size())) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)classifiers;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters;
                ClassifierDescriptor classifierDescriptor;
                ClassifierDescriptor classifierDescriptor2;
                Object object2;
                Object element$iv$iv = element$iv$iv$iv;
                ClassifierDescriptorWithTypeParameters classifier = (ClassifierDescriptorWithTypeParameters)element$iv$iv;
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters2 = classifier;
                if (!(classifierDescriptorWithTypeParameters2 instanceof ClassDescriptor)) {
                    classifierDescriptorWithTypeParameters2 = null;
                }
                if ((object2 = (ClassDescriptor)classifierDescriptorWithTypeParameters2) != null && (object2 = object2.getUnsubstitutedInnerClassesScope()) != null) {
                    Name name3 = name2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
                    classifierDescriptor2 = object2.getContributedClassifier(name3, NoLookupLocation.FOR_ALREADY_TRACKED);
                } else {
                    classifierDescriptor2 = classifierDescriptor = null;
                }
                if (!(classifierDescriptor2 instanceof ClassifierDescriptorWithTypeParameters)) {
                    classifierDescriptor = null;
                }
                if ((ClassifierDescriptorWithTypeParameters)classifierDescriptor == null) continue;
                ClassifierDescriptorWithTypeParameters it$iv$iv = classifierDescriptorWithTypeParameters;
                destination$iv$iv.add(it$iv$iv);
            }
            classifiers = (List)destination$iv$iv;
        }
        return classifiers;
    }

    /*
     * WARNING - void declaration
     */
    private final Compatibility areCompatibleCallables(CallableMemberDescriptor a, CallableMemberDescriptor b, boolean checkImpl, Substitutor parentSubstitutor) {
        boolean bl;
        Object it;
        Object object;
        block45: {
            boolean bl2;
            int i$iv;
            Object this_$iv;
            List<DeclarationDescriptorNonRoot> first$iv;
            List<DeclarationDescriptorNonRoot> second$iv;
            List<ValueParameterDescriptor> bParams;
            List<ValueParameterDescriptor> aParams;
            block44: {
                boolean bl3;
                DeclarationDescriptorNonRoot p1;
                Substitutor substitutor3;
                List<TypeParameterDescriptor> bTypeParams;
                List<TypeParameterDescriptor> aTypeParams;
                block43: {
                    Object object2;
                    List<ValueParameterDescriptor> $receiver$iv$iv;
                    Object $receiver$iv;
                    Object object3;
                    block47: {
                        block46: {
                            KotlinType kotlinType;
                            Object object4;
                            ValueParameterDescriptor it2;
                            ReceiverParameterDescriptor bExtensionReceiver;
                            boolean bl4 = Intrinsics.areEqual((Object)a.getName(), (Object)b.getName());
                            if (_Assertions.ENABLED && !bl4) {
                                String string = "This function should be invoked only for declarations with the same name: " + a + ", " + b;
                                throw (Throwable)((Object)new AssertionError((Object)string));
                            }
                            boolean bl5 = bl4 = a.getContainingDeclaration() instanceof ClassDescriptor == b.getContainingDeclaration() instanceof ClassDescriptor;
                            if (_Assertions.ENABLED && !bl4) {
                                String string = "This function should be invoked only for declarations in the same kind of container (both members or both top level): " + a + ", " + b;
                                throw (Throwable)((Object)new AssertionError((Object)string));
                            }
                            ReceiverParameterDescriptor aExtensionReceiver = a.getExtensionReceiverParameter();
                            if (aExtensionReceiver != null != ((bExtensionReceiver = b.getExtensionReceiverParameter()) != null)) {
                                return Compatibility.Incompatible.ParameterShape.INSTANCE;
                            }
                            aParams = a.getValueParameters();
                            bParams = b.getValueParameters();
                            if (aParams.size() != bParams.size()) {
                                return Compatibility.Incompatible.ParameterCount.INSTANCE;
                            }
                            aTypeParams = a.getTypeParameters();
                            bTypeParams = b.getTypeParameters();
                            if (aTypeParams.size() != bTypeParams.size()) {
                                return Compatibility.Incompatible.TypeParameterCount.INSTANCE;
                            }
                            List<TypeParameterDescriptor> list2 = aTypeParams;
                            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"aTypeParams");
                            List<TypeParameterDescriptor> list3 = bTypeParams;
                            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"bTypeParams");
                            substitutor3 = new Substitutor(list2, list3, parentSubstitutor);
                            object = aParams;
                            object3 = this;
                            void var13_19 = $receiver$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                            for (Object t : $receiver$iv$iv) {
                                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)t;
                                object2 = destination$iv$iv;
                                object4 = substitutor3.invoke(it2.getType());
                                object2.add(object4);
                            }
                            object2 = (List)destination$iv$iv;
                            $receiver$iv = bParams;
                            $receiver$iv$iv = $receiver$iv;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                            for (Object n : $receiver$iv$iv) {
                                void it3;
                                it2 = (ValueParameterDescriptor)n;
                                object4 = destination$iv$iv;
                                KotlinType kotlinType2 = it3.getType();
                                object4.add(kotlinType2);
                            }
                            object4 = (List)destination$iv$iv;
                            if (!((HeaderImplDeclarationChecker)object3).areCompatibleTypeLists((List<? extends KotlinType>)object2, (List<? extends KotlinType>)object4)) break block46;
                            HeaderImplDeclarationChecker headerImplDeclarationChecker = this;
                            Annotated annotated = aExtensionReceiver;
                            if (annotated != null && (annotated = annotated.getType()) != null) {
                                $receiver$iv = annotated;
                                object3 = headerImplDeclarationChecker;
                                object2 = ((Function1)substitutor3).invoke($receiver$iv);
                                headerImplDeclarationChecker = object3;
                                kotlinType = (KotlinType)object2;
                            } else {
                                kotlinType = null;
                            }
                            ReceiverParameterDescriptor receiverParameterDescriptor = bExtensionReceiver;
                            if (headerImplDeclarationChecker.areCompatibleTypes(kotlinType, receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null)) break block47;
                        }
                        return Compatibility.Incompatible.ParameterTypes.INSTANCE;
                    }
                    if (!this.areCompatibleTypes(substitutor3.invoke(a.getReturnType()), b.getReturnType())) {
                        return Compatibility.Incompatible.ReturnType.INSTANCE;
                    }
                    if (b.hasStableParameterNames()) {
                        boolean bl6;
                        block42: {
                            $receiver$iv = this;
                            List<ValueParameterDescriptor> list4 = aParams;
                            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"aParams");
                            $receiver$iv$iv = list4;
                            List<ValueParameterDescriptor> list5 = bParams;
                            Intrinsics.checkExpressionValueIsNotNull(list5, (String)"bParams");
                            second$iv = list5;
                            int n2 = 0;
                            int n = ((Collection)first$iv).size() - 1;
                            if (n2 <= n) {
                                while (true) {
                                    void i$iv2;
                                    p1 = (ValueParameterDescriptor)((Object)first$iv.get((int)i$iv2));
                                    object3 = p1.getName();
                                    if (Intrinsics.areEqual((Object)object3, (Object)(object2 = (p1 = (ValueParameterDescriptor)second$iv.get((int)i$iv2)).getName())) ^ true) {
                                        bl6 = false;
                                        break block42;
                                    }
                                    if (i$iv2 == n) break;
                                    ++i$iv2;
                                }
                            }
                            bl6 = true;
                        }
                        if (!bl6) {
                            return Compatibility.Incompatible.ParameterNames.INSTANCE;
                        }
                    }
                    this_$iv = this;
                    List<TypeParameterDescriptor> list6 = aTypeParams;
                    Intrinsics.checkExpressionValueIsNotNull(list6, (String)"aTypeParams");
                    first$iv = list6;
                    List<TypeParameterDescriptor> list7 = bTypeParams;
                    Intrinsics.checkExpressionValueIsNotNull(list7, (String)"bTypeParams");
                    second$iv = list7;
                    int i$iv2 = 0;
                    int n = ((Collection)first$iv).size() - 1;
                    if (i$iv2 <= n) {
                        while (true) {
                            p1 = first$iv.get(i$iv);
                            object3 = p1.getName();
                            if (Intrinsics.areEqual((Object)object3, (Object)(object2 = (p1 = (TypeParameterDescriptor)second$iv.get(i$iv)).getName())) ^ true) {
                                bl3 = false;
                                break block43;
                            }
                            if (i$iv == n) break;
                            ++i$iv;
                        }
                    }
                    bl3 = true;
                }
                if (!bl3) {
                    return Compatibility.Incompatible.TypeParameterNames.INSTANCE;
                }
                if (Intrinsics.areEqual((Object)((Object)a.getModality()), (Object)((Object)b.getModality())) ^ true) {
                    return Compatibility.Incompatible.Modality.INSTANCE;
                }
                if (Intrinsics.areEqual((Object)a.getVisibility(), (Object)b.getVisibility()) ^ true) {
                    return Compatibility.Incompatible.Visibility.INSTANCE;
                }
                List<TypeParameterDescriptor> list8 = aTypeParams;
                Intrinsics.checkExpressionValueIsNotNull(list8, (String)"aTypeParams");
                List<TypeParameterDescriptor> list9 = bTypeParams;
                Intrinsics.checkExpressionValueIsNotNull(list9, (String)"bTypeParams");
                it = this_$iv = this.areCompatibleTypeParameters(list8, list9, substitutor3);
                if (Intrinsics.areEqual((Object)it, (Object)Compatibility.Compatible.INSTANCE) ^ true) {
                    return it;
                }
                this_$iv = this;
                List<ValueParameterDescriptor> list10 = aParams;
                Intrinsics.checkExpressionValueIsNotNull(list10, (String)"aParams");
                it = list10;
                List<ValueParameterDescriptor> list11 = bParams;
                Intrinsics.checkExpressionValueIsNotNull(list11, (String)"bParams");
                second$iv = list11;
                i$iv = 0;
                int n = ((Collection)first$iv).size() - 1;
                if (i$iv <= n) {
                    while (true) {
                        boolean bl7;
                        p1 = (ValueParameterDescriptor)((Object)first$iv.get(i$iv));
                        boolean bl8 = p1.declaresDefaultValue();
                        if (bl8 == (bl7 = (p1 = (ValueParameterDescriptor)second$iv.get(i$iv)).declaresDefaultValue()) ^ true) {
                            bl2 = false;
                            break block44;
                        }
                        if (i$iv == n) break;
                        ++i$iv;
                    }
                }
                bl2 = true;
            }
            if (!bl2) {
                return Compatibility.Incompatible.ValueParameterHasDefault.INSTANCE;
            }
            this_$iv = this;
            List<ValueParameterDescriptor> list12 = aParams;
            Intrinsics.checkExpressionValueIsNotNull(list12, (String)"aParams");
            first$iv = list12;
            List<ValueParameterDescriptor> list13 = bParams;
            Intrinsics.checkExpressionValueIsNotNull(list13, (String)"bParams");
            second$iv = list13;
            i$iv = 0;
            int n = ((Collection)first$iv).size() - 1;
            if (i$iv <= n) {
                while (true) {
                    List list14;
                    ValueParameterDescriptor p = (ValueParameterDescriptor)first$iv.get(i$iv);
                    Object[] objectArray = new Boolean[]{p.getVarargElementType() != null, p.isCrossinline(), p.isNoinline()};
                    p = (ValueParameterDescriptor)second$iv.get(i$iv);
                    List list15 = CollectionsKt.listOf((Object[])objectArray);
                    if (Intrinsics.areEqual((Object)list15, (Object)(list14 = CollectionsKt.listOf((Object[])new Boolean[]{p.getVarargElementType() != null, p.isCrossinline(), p.isNoinline()}))) ^ true) {
                        bl = false;
                        break block45;
                    }
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
            bl = true;
        }
        if (!bl) {
            return Compatibility.Incompatible.ValueParameterModifiers.INSTANCE;
        }
        if (a instanceof FunctionDescriptor && b instanceof FunctionDescriptor) {
            object = this.areCompatibleFunctions((FunctionDescriptor)a, (FunctionDescriptor)b);
            it = object;
            if (Intrinsics.areEqual((Object)it, (Object)Compatibility.Compatible.INSTANCE) ^ true) {
                return it;
            }
        } else if (a instanceof PropertyDescriptor && b instanceof PropertyDescriptor) {
            object = this.areCompatibleProperties((PropertyDescriptor)a, (PropertyDescriptor)b);
            it = object;
            if (Intrinsics.areEqual((Object)it, (Object)Compatibility.Compatible.INSTANCE) ^ true) {
                return it;
            }
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unsupported declarations: " + a + ", " + b)));
        }
        if (checkImpl && !b.isImpl() && Intrinsics.areEqual((Object)((Object)b.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION))) {
            return Compatibility.Incompatible.NoImpl.INSTANCE;
        }
        return Compatibility.Compatible.INSTANCE;
    }

    static /* bridge */ /* synthetic */ Compatibility areCompatibleCallables$default(HeaderImplDeclarationChecker headerImplDeclarationChecker, CallableMemberDescriptor callableMemberDescriptor, CallableMemberDescriptor callableMemberDescriptor2, boolean bl, Substitutor substitutor3, int n, Object object) {
        if ((n & 8) != 0) {
            substitutor3 = null;
        }
        return headerImplDeclarationChecker.areCompatibleCallables(callableMemberDescriptor, callableMemberDescriptor2, bl, substitutor3);
    }

    private final boolean areCompatibleTypes(KotlinType a, KotlinType b) {
        return a != null ? b != null && TypeUtils.equalTypes(a, b) : b == null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areCompatibleTypeLists(List<? extends KotlinType> a, List<? extends KotlinType> b) {
        int n = 0;
        int n2 = ((Collection)a).size() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (!this.areCompatibleTypes(a.get((int)i), b.get((int)i))) {
                    return false;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return true;
    }

    private final Compatibility areCompatibleTypeParameters(List<? extends TypeParameterDescriptor> a, List<? extends TypeParameterDescriptor> b, Substitutor substitutor3) {
        boolean bl;
        block12: {
            boolean bl2;
            TypeParameterDescriptor p1;
            int i$iv;
            int n;
            HeaderImplDeclarationChecker this_$iv;
            block11: {
                Object object;
                TypeParameterDescriptor it;
                Object object2;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = a;
                Object object3 = this;
                void var5_7 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
                    object2 = destination$iv$iv;
                    object = substitutor3.invoke(it.getDefaultType());
                    object2.add(object);
                }
                object2 = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv = (Iterable)b;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    it = (TypeParameterDescriptor)item$iv$iv;
                    object = destination$iv$iv;
                    SimpleType simpleType2 = it.getDefaultType();
                    object.add(simpleType2);
                }
                object = (List)destination$iv$iv;
                if (!object3.areCompatibleTypeLists((List<? extends KotlinType>)object2, (List<? extends KotlinType>)object)) {
                    return Compatibility.Incompatible.TypeParameterUpperBounds.INSTANCE;
                }
                this_$iv = this;
                int $receiver$iv$iv2 = 0;
                n = ((Collection)a).size() - 1;
                if ($receiver$iv$iv2 <= n) {
                    while (true) {
                        p1 = a.get(i$iv);
                        object3 = p1.getVariance();
                        if (Intrinsics.areEqual((Object)object3, (Object)(object2 = (p1 = b.get(i$iv)).getVariance())) ^ true) {
                            bl2 = false;
                            break block11;
                        }
                        if (i$iv == n) break;
                        ++i$iv;
                    }
                }
                bl2 = true;
            }
            if (!bl2) {
                return Compatibility.Incompatible.TypeParameterVariance.INSTANCE;
            }
            this_$iv = this;
            i$iv = 0;
            n = ((Collection)a).size() - 1;
            if (i$iv <= n) {
                while (true) {
                    boolean bl3;
                    p1 = a.get(i$iv);
                    boolean bl4 = p1.isReified();
                    if (bl4 == (bl3 = (p1 = b.get(i$iv)).isReified()) ^ true) {
                        bl = false;
                        break block12;
                    }
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
            bl = true;
        }
        if (!bl) {
            return Compatibility.Incompatible.TypeParameterReified.INSTANCE;
        }
        return Compatibility.Compatible.INSTANCE;
    }

    private final Compatibility areCompatibleFunctions(FunctionDescriptor a, FunctionDescriptor b) {
        boolean bl;
        HeaderImplDeclarationChecker this_$iv = this;
        FunctionDescriptor f = a;
        boolean bl2 = f.isSuspend();
        if (!(bl2 == (bl = (f = b).isSuspend()))) {
            return Compatibility.Incompatible.FunctionModifiersDifferent.INSTANCE;
        }
        if (a.isExternal() && !b.isExternal() || a.isInfix() && !b.isInfix() || a.isInline() && !b.isInline() || a.isOperator() && !b.isOperator() || a.isTailrec() && !b.isTailrec()) {
            return Compatibility.Incompatible.FunctionModifiersNotSubset.INSTANCE;
        }
        return Compatibility.Compatible.INSTANCE;
    }

    private final Compatibility areCompatibleProperties(PropertyDescriptor a, PropertyDescriptor b) {
        List list2;
        boolean bl;
        HeaderImplDeclarationChecker this_$iv = this;
        PropertyDescriptor p = a;
        boolean bl2 = p.isVar();
        if (!(bl2 == (bl = (p = b).isVar()))) {
            return Compatibility.Incompatible.PropertyKind.INSTANCE;
        }
        this_$iv = this;
        p = a;
        Object[] objectArray = new Boolean[]{p.isConst(), p.isLateInit()};
        p = b;
        List list3 = CollectionsKt.listOf((Object[])objectArray);
        if (!Intrinsics.areEqual((Object)list3, (Object)(list2 = CollectionsKt.listOf((Object[])new Boolean[]{p.isConst(), p.isLateInit()})))) {
            return Compatibility.Incompatible.PropertyModifiers.INSTANCE;
        }
        return Compatibility.Compatible.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final Compatibility areCompatibleClassifiers(ClassDescriptor a, ClassifierDescriptor other, boolean checkImpl) {
        boolean bl;
        Substitutor substitutor3;
        ClassDescriptor b;
        boolean implTypealias;
        block21: {
            Iterable $receiver$iv$iv;
            Object element$iv$iv2;
            void $receiver$iv$iv2;
            Iterable $receiver$iv;
            Compatibility $i$f$equalBy;
            List list2;
            ClassDescriptor classDescriptor;
            boolean bl2 = Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(a), (Object)DescriptorUtilsKt.getFqNameUnsafe(other));
            if (_Assertions.ENABLED && !bl2) {
                String string = "This function should be invoked only for declarations with the same name: " + a + ", " + other;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Substitutor parentSubstitutor = null;
            implTypealias = false;
            ClassifierDescriptor classifierDescriptor = other;
            if (classifierDescriptor instanceof ClassDescriptor) {
                classDescriptor = (ClassDescriptor)other;
            } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
                ClassDescriptor classDescriptor2 = ((TypeAliasDescriptor)other).getClassDescriptor();
                if (classDescriptor2 == null) {
                    return Compatibility.Compatible.INSTANCE;
                }
                ClassDescriptor classDescriptor3 = classDescriptor2;
                implTypealias = true;
                TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(TypeConstructorSubstitution.Companion.createByConstructorsMap$default(TypeConstructorSubstitution.Companion, MapsKt.mapOf((Pair)TuplesKt.to((Object)a.getTypeConstructor(), (Object)TypeUtilsKt.asTypeProjection(classDescriptor3.getDefaultType()))), false, 2, null));
                Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor2, (String)"TypeSubstitutor.create(T\u2026ion())\n                ))");
                parentSubstitutor = new Substitutor(null, typeSubstitutor2);
                classDescriptor = classDescriptor3;
            } else {
                throw (Throwable)((Object)new AssertionError((Object)("Incorrect impl classifier for " + a + ": " + other)));
            }
            b = classDescriptor;
            if (Intrinsics.areEqual((Object)((Object)a.getKind()), (Object)((Object)b.getKind())) ^ true) {
                return Compatibility.Incompatible.ClassKind.INSTANCE;
            }
            HeaderImplDeclarationChecker this_$iv = this;
            ClassDescriptor it = a;
            Object[] objectArray = new Boolean[]{it.isCompanionObject(), it.isInner()};
            it = b;
            List list3 = CollectionsKt.listOf((Object[])objectArray);
            if (!Intrinsics.areEqual((Object)list3, (Object)(list2 = CollectionsKt.listOf((Object[])new Boolean[]{it.isCompanionObject(), it.isInner()})))) {
                return Compatibility.Incompatible.ClassModifiers.INSTANCE;
            }
            List<TypeParameterDescriptor> aTypeParams = a.getDeclaredTypeParameters();
            List<TypeParameterDescriptor> bTypeParams = b.getDeclaredTypeParameters();
            if (aTypeParams.size() != bTypeParams.size()) {
                return Compatibility.Incompatible.TypeParameterCount.INSTANCE;
            }
            if (!(!(Intrinsics.areEqual((Object)((Object)a.getModality()), (Object)((Object)b.getModality())) ^ true) || Intrinsics.areEqual((Object)((Object)a.getModality()), (Object)((Object)Modality.FINAL)) && Intrinsics.areEqual((Object)((Object)b.getModality()), (Object)((Object)Modality.OPEN)))) {
                return Compatibility.Incompatible.Modality.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)a.getVisibility(), (Object)b.getVisibility()) ^ true) {
                return Compatibility.Incompatible.Visibility.INSTANCE;
            }
            List<TypeParameterDescriptor> list4 = aTypeParams;
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"aTypeParams");
            List<TypeParameterDescriptor> list5 = bTypeParams;
            Intrinsics.checkExpressionValueIsNotNull(list5, (String)"bTypeParams");
            substitutor3 = new Substitutor(list4, list5, parentSubstitutor);
            List<TypeParameterDescriptor> list6 = aTypeParams;
            Intrinsics.checkExpressionValueIsNotNull(list6, (String)"aTypeParams");
            List<TypeParameterDescriptor> list7 = bTypeParams;
            Intrinsics.checkExpressionValueIsNotNull(list7, (String)"bTypeParams");
            Compatibility it2 = $i$f$equalBy = this.areCompatibleTypeParameters(list6, list7, substitutor3);
            if (Intrinsics.areEqual((Object)it2, (Object)Compatibility.Compatible.INSTANCE) ^ true) {
                return it2;
            }
            Iterable $i$a$3$let = $receiver$iv = (Iterable)a.getTypeConstructor().getSupertypes();
            Iterable destination$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                KotlinType p1 = (KotlinType)element$iv$iv2;
                if (KotlinBuiltIns.isAny(p1)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List aSupertypes = (List)destination$iv$iv;
            Iterable $receiver$iv2 = b.getTypeConstructor().getSupertypes();
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            element$iv$iv2 = $receiver$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                Object element$iv$iv3 = element$iv$iv2.next();
                KotlinType p1 = (KotlinType)element$iv$iv3;
                if (KotlinBuiltIns.isAny(p1)) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            List bSupertypes = (List)destination$iv$iv2;
            $receiver$iv2 = aSupertypes;
            $receiver$iv$iv = $receiver$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            element$iv$iv2 = $receiver$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                Object item$iv$iv = element$iv$iv2.next();
                destination$iv$iv2.add(((Function1)substitutor3).invoke(item$iv$iv));
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            for (Object element$iv : $receiver$iv2) {
                boolean bl3;
                block20: {
                    KotlinType aSupertype = (KotlinType)element$iv;
                    Iterable $receiver$iv3 = bSupertypes;
                    for (Object element$iv2 : $receiver$iv3) {
                        KotlinType bSupertype = (KotlinType)element$iv2;
                        if (!this.areCompatibleTypes(aSupertype, bSupertype)) continue;
                        bl3 = false;
                        break block20;
                    }
                    bl3 = true;
                }
                if (!bl3) continue;
                bl = true;
                break block21;
            }
            bl = false;
        }
        if (bl) {
            return Compatibility.Incompatible.Supertypes.INSTANCE;
        }
        Compatibility compatibility = this.areCompatibleClassScopes(a, b, checkImpl && !implTypealias, substitutor3);
        Compatibility it = compatibility;
        if (Intrinsics.areEqual((Object)it, (Object)Compatibility.Compatible.INSTANCE) ^ true) {
            return it;
        }
        if (checkImpl && !b.isImpl() && !implTypealias) {
            return Compatibility.Incompatible.NoImpl.INSTANCE;
        }
        return Compatibility.Compatible.INSTANCE;
    }

    private final Compatibility areCompatibleClassScopes(ClassDescriptor a, ClassDescriptor b, boolean checkImpl, Substitutor substitutor3) {
        Iterator $receiver$iv$iv;
        Iterable $receiver$iv;
        ArrayList<Pair> unimplemented = new ArrayList<Pair>();
        Iterable iterable = $receiver$iv = (Iterable)HeaderImplDeclarationChecker.getMembers$default(this, b, null, 1, null);
        Map destination$iv$iv = new LinkedHashMap();
        Object object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            Object object2;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = object.next();
            CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
            Name key$iv$iv = it.getName();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map bMembersByName = destination$iv$iv;
        block1: for (CallableMemberDescriptor aMember : HeaderImplDeclarationChecker.getMembers$default(this, a, null, 1, null)) {
            boolean bl;
            Object it;
            Object object3;
            Map mapping2;
            block12: {
                if (!aMember.getKind().isReal()) continue;
                object = (List)bMembersByName.get(aMember.getName());
                Object object4 = object;
                if (object4 == null) {
                    object4 = CollectionsKt.emptyList();
                }
                mapping2 = org.jetbrains.kotlin.utils.CollectionsKt.keysToMap((Iterable)object4, (Function1)new Function1<CallableMemberDescriptor, Compatibility>(this, aMember, checkImpl, substitutor3){
                    final /* synthetic */ HeaderImplDeclarationChecker this$0;
                    final /* synthetic */ CallableMemberDescriptor $aMember;
                    final /* synthetic */ boolean $checkImpl;
                    final /* synthetic */ Substitutor $substitutor;

                    @NotNull
                    public final Compatibility invoke(@NotNull CallableMemberDescriptor bMember) {
                        Intrinsics.checkParameterIsNotNull((Object)bMember, (String)"bMember");
                        return HeaderImplDeclarationChecker.access$areCompatibleCallables(this.this$0, this.$aMember, bMember, this.$checkImpl, this.$substitutor);
                    }
                    {
                        this.this$0 = headerImplDeclarationChecker;
                        this.$aMember = callableMemberDescriptor;
                        this.$checkImpl = bl;
                        this.$substitutor = substitutor3;
                        super(1);
                    }
                });
                Iterable $receiver$iv2 = mapping2.values();
                object3 = $receiver$iv2.iterator();
                while (object3.hasNext()) {
                    Object element$iv = object3.next();
                    it = (Compatibility)element$iv;
                    if (!Intrinsics.areEqual((Object)it, (Object)Compatibility.Compatible.INSTANCE)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
            if (bl) continue;
            Map incompatibilityMap = new LinkedHashMap();
            it = mapping2;
            Iterator iterator2 = it.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object5;
                Object object6 = object3 = iterator2.next();
                CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)object6.getKey();
                object6 = object3;
                Compatibility compatibility = (Compatibility)object6.getValue();
                if (Intrinsics.areEqual((Object)(object6 = compatibility), (Object)Compatibility.Compatible.INSTANCE)) continue block1;
                if (!(object6 instanceof Compatibility.Incompatible)) continue;
                Map $receiver$iv3 = incompatibilityMap;
                Object value$iv = $receiver$iv3.get(compatibility);
                if (value$iv == null) {
                    SmartList answer$iv = new SmartList();
                    $receiver$iv3.put(compatibility, answer$iv);
                    object5 = answer$iv;
                } else {
                    object5 = value$iv;
                }
                ((Collection)object5).add(descriptor2);
            }
            unimplemented.add(TuplesKt.to((Object)aMember, (Object)incompatibilityMap));
        }
        if (Intrinsics.areEqual((Object)((Object)a.getKind()), (Object)((Object)ClassKind.ENUM_CLASS))) {
            areCompatibleClassScopes.3 enumEntries$ = areCompatibleClassScopes.3.INSTANCE;
            List<Name> aEntries = enumEntries$.invoke(a);
            List<Name> bEntries = enumEntries$.invoke(b);
            if (!bEntries.containsAll((Collection)aEntries)) {
                return Compatibility.Incompatible.EnumEntries.INSTANCE;
            }
        }
        if (unimplemented.isEmpty()) {
            return Compatibility.Compatible.INSTANCE;
        }
        return new Compatibility.Incompatible.ClassScopes((List<? extends Pair<? extends CallableMemberDescriptor, ? extends Map<Compatibility.Incompatible, ? extends Collection<? extends CallableMemberDescriptor>>>>)unimplemented);
    }

    private final Collection<CallableMemberDescriptor> getMembers(@NotNull ClassDescriptor $receiver, Name name2) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Function1 nameFilter2 = name2 != null ? (Function1)new Function1<Name, Boolean>(name2){
            final /* synthetic */ Name $name;

            public final boolean invoke(@NotNull Name it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$name);
            }
            {
                this.$name = name2;
                super(1);
            }
        } : MemberScope.Companion.getALL_NAME_FILTER();
        Iterable iterable = $receiver$iv = (Iterable)MemberScopeKt.getDescriptorsFiltered$default($receiver.getDefaultType().getMemberScope(), null, nameFilter2, 1, null);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = $receiver.getConstructors();
        Collection collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv$iv;
            Name name3 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"it.name");
            if (!((Boolean)nameFilter2.invoke((Object)name3)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    static /* bridge */ /* synthetic */ Collection getMembers$default(HeaderImplDeclarationChecker headerImplDeclarationChecker, ClassDescriptor classDescriptor, Name name2, int n, Object object) {
        if ((n & 1) != 0) {
            name2 = null;
        }
        return headerImplDeclarationChecker.getMembers(classDescriptor, name2);
    }

    private final <T, K> boolean equalBy(T first, T second, Function1<? super T, ? extends K> selector) {
        return Intrinsics.areEqual((Object)selector.invoke(first), (Object)selector.invoke(second));
    }

    /*
     * WARNING - void declaration
     */
    private final <T, K> boolean equalsBy(List<? extends T> first, List<? extends T> second, Function1<? super T, ? extends K> selector) {
        int n = 0;
        int n2 = ((Collection)first).size() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (Intrinsics.areEqual((Object)selector.invoke(first.get((int)i)), (Object)selector.invoke(second.get((int)i))) ^ true) {
                    return false;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return true;
    }

    @Nullable
    public final ModuleDescriptor getModuleToCheck() {
        return this.moduleToCheck;
    }

    public HeaderImplDeclarationChecker(@Nullable ModuleDescriptor moduleToCheck) {
        this.moduleToCheck = moduleToCheck;
    }

    public /* synthetic */ HeaderImplDeclarationChecker(ModuleDescriptor moduleDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            moduleDescriptor = null;
        }
        this(moduleDescriptor);
    }

    public HeaderImplDeclarationChecker() {
        this(null, 1, null);
    }

    @NotNull
    public static final /* synthetic */ Compatibility access$areCompatibleClassifiers(HeaderImplDeclarationChecker $this, @NotNull ClassDescriptor a, @NotNull ClassifierDescriptor other, boolean checkImpl) {
        return $this.areCompatibleClassifiers(a, other, checkImpl);
    }

    @NotNull
    public static final /* synthetic */ Compatibility access$areCompatibleCallables(HeaderImplDeclarationChecker $this, @NotNull CallableMemberDescriptor a, @NotNull CallableMemberDescriptor b, boolean checkImpl, @Nullable Substitutor parentSubstitutor) {
        return $this.areCompatibleCallables(a, b, checkImpl, parentSubstitutor);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility;", "", "()V", "Compatible", "Incompatible", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Compatible;", "frontend"})
    public static abstract class Compatibility {
        private Compatibility() {
        }

        public /* synthetic */ Compatibility(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u001e\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0019\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'BA\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012.\b\u0002\u0010\u0004\u001a(\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\b0\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR7\u0010\u0004\u001a(\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\b0\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0019()*+,-./0123456789:;<=>?@\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility;", "reason", "", "unimplemented", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "", "", "(Ljava/lang/String;Ljava/util/List;)V", "getReason", "()Ljava/lang/String;", "getUnimplemented", "()Ljava/util/List;", "ClassKind", "ClassModifiers", "ClassScopes", "EnumEntries", "FunctionModifiersDifferent", "FunctionModifiersNotSubset", "Modality", "NoImpl", "ParameterCount", "ParameterNames", "ParameterShape", "ParameterTypes", "PropertyKind", "PropertyModifiers", "ReturnType", "Supertypes", "TypeParameterCount", "TypeParameterNames", "TypeParameterReified", "TypeParameterUpperBounds", "TypeParameterVariance", "Unknown", "ValueParameterHasDefault", "ValueParameterModifiers", "Visibility", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterShape;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterCount;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterCount;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterTypes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ReturnType;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterNames;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterNames;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterHasDefault;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterModifiers;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$FunctionModifiersDifferent;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$FunctionModifiersNotSubset;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$PropertyKind;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$PropertyModifiers;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassKind;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassModifiers;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Supertypes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassScopes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$EnumEntries;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Modality;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Visibility;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterUpperBounds;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterVariance;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterReified;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$NoImpl;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Unknown;", "frontend"})
        public static abstract class Incompatible
        extends Compatibility {
            @Nullable
            private final String reason;
            @Nullable
            private final List<Pair<CallableMemberDescriptor, Map<Incompatible, Collection<CallableMemberDescriptor>>>> unimplemented;

            @Nullable
            public final String getReason() {
                return this.reason;
            }

            @Nullable
            public final List<Pair<CallableMemberDescriptor, Map<Incompatible, Collection<CallableMemberDescriptor>>>> getUnimplemented() {
                return this.unimplemented;
            }

            private Incompatible(String reason, List<? extends Pair<? extends CallableMemberDescriptor, ? extends Map<Incompatible, ? extends Collection<? extends CallableMemberDescriptor>>>> unimplemented) {
                super(null);
                this.reason = reason;
                this.unimplemented = unimplemented;
            }

            /* synthetic */ Incompatible(String string, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    list2 = null;
                }
                this(string, list2);
            }

            public /* synthetic */ Incompatible(@Nullable String reason, @Nullable List unimplemented, DefaultConstructorMarker $constructor_marker) {
                this(reason, unimplemented);
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterShape;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ParameterShape
            extends Incompatible {
                public static final ParameterShape INSTANCE;

                private ParameterShape() {
                    super("parameter shapes are different (extension vs non-extension)", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new ParameterShape();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterCount;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ParameterCount
            extends Incompatible {
                public static final ParameterCount INSTANCE;

                private ParameterCount() {
                    super("number of value parameters is different", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new ParameterCount();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterCount;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class TypeParameterCount
            extends Incompatible {
                public static final TypeParameterCount INSTANCE;

                private TypeParameterCount() {
                    super("number of type parameters is different", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new TypeParameterCount();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterTypes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ParameterTypes
            extends Incompatible {
                public static final ParameterTypes INSTANCE;

                private ParameterTypes() {
                    super("parameter types are different", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new ParameterTypes();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ReturnType;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ReturnType
            extends Incompatible {
                public static final ReturnType INSTANCE;

                private ReturnType() {
                    super("return type is different", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new ReturnType();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterNames;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ParameterNames
            extends Incompatible {
                public static final ParameterNames INSTANCE;

                private ParameterNames() {
                    super("parameter names are different", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new ParameterNames();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterNames;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class TypeParameterNames
            extends Incompatible {
                public static final TypeParameterNames INSTANCE;

                private TypeParameterNames() {
                    super("names of type parameters are different", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new TypeParameterNames();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterHasDefault;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ValueParameterHasDefault
            extends Incompatible {
                public static final ValueParameterHasDefault INSTANCE;

                private ValueParameterHasDefault() {
                    super("some parameters have default values", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new ValueParameterHasDefault();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterModifiers;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ValueParameterModifiers
            extends Incompatible {
                public static final ValueParameterModifiers INSTANCE;

                private ValueParameterModifiers() {
                    super("parameter modifiers are different (vararg, coroutine, crossinline, noinline)", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new ValueParameterModifiers();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$FunctionModifiersDifferent;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class FunctionModifiersDifferent
            extends Incompatible {
                public static final FunctionModifiersDifferent INSTANCE;

                private FunctionModifiersDifferent() {
                    super("modifiers are different (suspend)", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new FunctionModifiersDifferent();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$FunctionModifiersNotSubset;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class FunctionModifiersNotSubset
            extends Incompatible {
                public static final FunctionModifiersNotSubset INSTANCE;

                private FunctionModifiersNotSubset() {
                    super("some modifiers on header declaration are missing on the implementation (external, infix, inline, operator, tailrec)", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new FunctionModifiersNotSubset();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$PropertyKind;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class PropertyKind
            extends Incompatible {
                public static final PropertyKind INSTANCE;

                private PropertyKind() {
                    super("property kinds are different (val vs var)", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new PropertyKind();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$PropertyModifiers;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class PropertyModifiers
            extends Incompatible {
                public static final PropertyModifiers INSTANCE;

                private PropertyModifiers() {
                    super("modifiers are different (const, lateinit)", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new PropertyModifiers();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassKind;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ClassKind
            extends Incompatible {
                public static final ClassKind INSTANCE;

                private ClassKind() {
                    super("class kinds are different (class, interface, object, enum, annotation)", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new ClassKind();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassModifiers;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ClassModifiers
            extends Incompatible {
                public static final ClassModifiers INSTANCE;

                private ClassModifiers() {
                    super("modifiers are different (companion, inner)", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new ClassModifiers();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Supertypes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class Supertypes
            extends Incompatible {
                public static final Supertypes INSTANCE;

                private Supertypes() {
                    super("some supertypes are missing in the implementation", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new Supertypes();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012*\u0010\u0002\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassScopes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "unimplemented", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "", "", "(Ljava/util/List;)V", "frontend"})
            public static final class ClassScopes
            extends Incompatible {
                public ClassScopes(@NotNull List<? extends Pair<? extends CallableMemberDescriptor, ? extends Map<Incompatible, ? extends Collection<? extends CallableMemberDescriptor>>>> unimplemented) {
                    Intrinsics.checkParameterIsNotNull(unimplemented, (String)"unimplemented");
                    super("some members are not implemented", unimplemented, null);
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$EnumEntries;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class EnumEntries
            extends Incompatible {
                public static final EnumEntries INSTANCE;

                private EnumEntries() {
                    super("some entries from header enum are missing in the impl enum", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new EnumEntries();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Modality;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class Modality
            extends Incompatible {
                public static final Modality INSTANCE;

                private Modality() {
                    super("modality is different", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new Modality();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Visibility;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class Visibility
            extends Incompatible {
                public static final Visibility INSTANCE;

                private Visibility() {
                    super("visibility is different", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new Visibility();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterUpperBounds;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class TypeParameterUpperBounds
            extends Incompatible {
                public static final TypeParameterUpperBounds INSTANCE;

                private TypeParameterUpperBounds() {
                    super("upper bounds of type parameters are different", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new TypeParameterUpperBounds();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterVariance;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class TypeParameterVariance
            extends Incompatible {
                public static final TypeParameterVariance INSTANCE;

                private TypeParameterVariance() {
                    super("declaration-site variances of type parameters are different", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new TypeParameterVariance();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterReified;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class TypeParameterReified
            extends Incompatible {
                public static final TypeParameterReified INSTANCE;

                private TypeParameterReified() {
                    super("some type parameter is reified in one declaration and non-reified in the other", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new TypeParameterReified();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$NoImpl;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class NoImpl
            extends Incompatible {
                public static final NoImpl INSTANCE;

                private NoImpl() {
                    super("the implementation is not marked with the 'impl' modifier (-Xno-check-impl)", null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new NoImpl();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Unknown;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class Unknown
            extends Incompatible {
                public static final Unknown INSTANCE;

                private Unknown() {
                    super(null, null, 2, null);
                    INSTANCE = this;
                }

                static {
                    new Unknown();
                }
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Compatible;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility;", "()V", "frontend"})
        public static final class Compatible
        extends Compatibility {
            public static final Compatible INSTANCE;

            private Compatible() {
                super(null);
                INSTANCE = this;
            }

            static {
                new Compatible();
            }
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B/\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\bB\u0017\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u0004\u0018\u00010\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Substitutor;", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "aTypeParams", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "bTypeParams", "parent", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Substitutor;)V", "typeSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "(Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Substitutor;Lorg/jetbrains/kotlin/types/TypeSubstitutor;)V", "invoke", "type", "frontend"})
    private static final class Substitutor
    implements Function1<KotlinType, KotlinType> {
        private final Substitutor parent;
        private final TypeSubstitutor typeSubstitutor;

        @Nullable
        public KotlinType invoke(@Nullable KotlinType type2) {
            Object object;
            Object p1;
            TypeSubstitutor typeSubstitutor2;
            Object object2;
            Object object3 = this.parent;
            if (object3 == null || (object3 = ((Substitutor)object3).invoke(type2)) == null) {
                object3 = object2 = type2;
            }
            return object3 != null && (object2 = TypeUtilsKt.asTypeProjection((KotlinType)object2)) != null && (object2 = (typeSubstitutor2 = this.typeSubstitutor).substitute((TypeProjection)(p1 = (object = object2)))) != null ? object2.getType() : null;
        }

        public Substitutor(@Nullable Substitutor parent2, @NotNull TypeSubstitutor typeSubstitutor2) {
            Intrinsics.checkParameterIsNotNull((Object)typeSubstitutor2, (String)"typeSubstitutor");
            this.parent = parent2;
            this.typeSubstitutor = typeSubstitutor2;
        }

        public Substitutor(@NotNull List<? extends TypeParameterDescriptor> aTypeParams, final @NotNull List<? extends TypeParameterDescriptor> bTypeParams, @Nullable Substitutor parent2) {
            Intrinsics.checkParameterIsNotNull(aTypeParams, (String)"aTypeParams");
            Intrinsics.checkParameterIsNotNull(bTypeParams, (String)"bTypeParams");
            TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(TypeConstructorSubstitution.Companion.createByParametersMap(org.jetbrains.kotlin.utils.CollectionsKt.keysToMap((Iterable)aTypeParams, (Function1)new Function1<TypeParameterDescriptor, TypeProjection>(){

                @NotNull
                public final TypeProjection invoke(@NotNull TypeParameterDescriptor it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return TypeUtilsKt.asTypeProjection(((TypeParameterDescriptor)bTypeParams.get(it.getIndex())).getDefaultType());
                }
            })));
            Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor2, (String)"TypeSubstitutor.create(\n\u2026             })\n        )");
            this(parent2, typeSubstitutor2);
        }

        public /* synthetic */ Substitutor(List list2, List list3, Substitutor substitutor3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                substitutor3 = null;
            }
            this(list2, list3, substitutor3);
        }
    }
}

