/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleIndex;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class JavaModuleIndexImpl
extends JavaModuleIndex {
    public static final String SOURCE_SUFFIX = ":S";
    public static final String TEST_SUFFIX = ":T";
    private static final String INDEX_PATH = "jigsaw/module-info.map";
    private static final String NULL_PATH = "-";
    private static final String MODULE_INFO_FILE = "module-info.java";
    private final Map<String, File> myMapping;
    private final JpsCompilerExcludes myExcludes;

    private JavaModuleIndexImpl(JpsCompilerExcludes excludes) {
        this.myMapping = ContainerUtil.newHashMap();
        this.myExcludes = excludes;
    }

    private JavaModuleIndexImpl(Map<String, File> mapping) {
        this.myMapping = Collections.unmodifiableMap(mapping);
        this.myExcludes = null;
    }

    @Nullable
    public File getModuleInfoFile(@NotNull JpsModule module, boolean forTests) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/java/impl/JavaModuleIndexImpl", "getModuleInfoFile"));
        }
        String key = module.getName() + (forTests ? TEST_SUFFIX : SOURCE_SUFFIX);
        if (this.myExcludes == null || this.myMapping.containsKey(key)) {
            return this.myMapping.get(key);
        }
        File file = this.findModuleInfoFile(module, forTests ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
        this.myMapping.put(key, file);
        return file;
    }

    private File findModuleInfoFile(JpsModule module, JavaSourceRootType rootType) {
        for (JpsModuleSourceRoot root : module.getSourceRoots()) {
            File file;
            if (!rootType.equals(root.getRootType()) || !(file = new File(JpsPathUtil.urlToOsPath((String)root.getUrl()), MODULE_INFO_FILE)).isFile() || this.myExcludes.isExcluded(file)) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(@NotNull File storageRoot, @NotNull Map<String, String> mapping) throws IOException {
        if (storageRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageRoot", "org/jetbrains/jps/model/java/impl/JavaModuleIndexImpl", "store"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/jps/model/java/impl/JavaModuleIndexImpl", "store"));
        }
        Properties p = new Properties();
        Iterator<String> iterator = mapping.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String path = mapping.get(key = iterator.next());
            p.setProperty(key, path != null ? FileUtil.toSystemDependentName((String)path) : NULL_PATH);
        }
        File index = new File(storageRoot, INDEX_PATH);
        FileUtil.createParentDirs((File)index);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(index), CharsetToolkit.UTF8_CHARSET);){
            p.store(writer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaModuleIndex load(@NotNull File storageRoot, @NotNull JpsCompilerExcludes excludes) {
        if (storageRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageRoot", "org/jetbrains/jps/model/java/impl/JavaModuleIndexImpl", "load"));
        }
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "org/jetbrains/jps/model/java/impl/JavaModuleIndexImpl", "load"));
        }
        File index = new File(storageRoot, INDEX_PATH);
        if (!index.exists()) {
            return new JavaModuleIndexImpl(excludes);
        }
        Properties p = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(index), CharsetToolkit.UTF8_CHARSET);){
            p.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read module index file: " + index, e);
        }
        HashMap mapping = ContainerUtil.newHashMap();
        Iterator<String> iterator = p.stringPropertyNames().iterator();
        while (iterator.hasNext()) {
            String key;
            String path = p.getProperty(key = iterator.next());
            mapping.put(key, NULL_PATH.equals(path) ? null : new File(path));
        }
        return new JavaModuleIndexImpl(mapping);
    }
}

