/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.incremental.java.ExternalJavacOptionsProvider;
import org.jetbrains.jps.javac.ast.api.JavacFileReferencesRegistrar;
import org.jetbrains.jps.service.JpsServiceManager;

public class ReferenceCollectorExternalJavacOptionsProvider
implements ExternalJavacOptionsProvider {
    @Override
    @NotNull
    public Collection<String> getOptions(@NotNull JavaCompilingTool tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "org/jetbrains/jps/javac/ast/ReferenceCollectorExternalJavacOptionsProvider", "getOptions"));
        }
        ArrayList<String> options = new ArrayList<String>(2);
        if (tool.getId().equals("Javac")) {
            JavacReferenceCollectorOptions javacReferenceCollectorOptions = new JavacReferenceCollectorOptions();
            options.add("-Dexternal.java.process.ref.collector.enabled=" + javacReferenceCollectorOptions.isEnabled());
            if (javacReferenceCollectorOptions.isEnabled() && javacReferenceCollectorOptions.isImportRefsDivided()) {
                options.add("-Dexternal.java.process.divide.imports=true");
            }
        }
        ArrayList<String> arrayList = options;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/ReferenceCollectorExternalJavacOptionsProvider", "getOptions"));
        }
        return arrayList;
    }

    private static class JavacReferenceCollectorOptions {
        private final boolean myEnabled;
        private final boolean myDivideImportRefs;

        private JavacReferenceCollectorOptions() {
            boolean enabled = false;
            boolean divideImportRefs = false;
            for (JavacFileReferencesRegistrar listener : JpsServiceManager.getInstance().getExtensions(JavacFileReferencesRegistrar.class)) {
                if (!listener.isEnabled()) continue;
                enabled = true;
                if (!listener.onlyImports()) continue;
                divideImportRefs = true;
            }
            this.myEnabled = enabled;
            this.myDivideImportRefs = divideImportRefs;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public boolean isImportRefsDivided() {
            return this.myDivideImportRefs;
        }
    }
}

