/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jf.dexlib2.iface.reference.MethodReference;

public class PackageTreeNode
implements TreeNode {
    @NotNull
    private final String myPackageName;
    @NotNull
    private final String myName;
    @NotNull
    private final NodeType myNodeType;
    @Nullable
    private final PackageTreeNode myParent;
    @NotNull
    private final List<PackageTreeNode> myNodes;
    private int myMethodReferencesCount;
    private int myDefinedMethodsCount;

    public PackageTreeNode(@NotNull String packageName, @NotNull String name, @NotNull NodeType type, @Nullable PackageTreeNode parent) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "<init>"));
        }
        this.myMethodReferencesCount = 0;
        this.myDefinedMethodsCount = 0;
        this.myPackageName = packageName;
        this.myName = name;
        this.myNodeType = type;
        this.myParent = parent;
        this.myNodes = new ArrayList<PackageTreeNode>();
    }

    public void sortByCount() {
        for (PackageTreeNode node : this.myNodes) {
            node.sortByCount();
        }
        Collections.sort(this.myNodes, (o1, o2) -> o2.getMethodRefCount() - o1.getMethodRefCount());
    }

    public void insert(@NotNull String parentPackage, @NotNull String qcn, @NotNull MethodReference ref, boolean hasClassDefinition) {
        if (parentPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPackage", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "insert"));
        }
        if (qcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qcn", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "insert"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "insert"));
        }
        int i = qcn.indexOf(".");
        if (i < 0) {
            this.insertClass(parentPackage, qcn, ref, hasClassDefinition);
        } else {
            String segment = qcn.substring(0, i);
            String nextSegment = qcn.substring(i + 1);
            PackageTreeNode node = this.getOrCreateChild(parentPackage, segment, NodeType.PACKAGE);
            node.insert(PackageTreeNode.combine(parentPackage, segment), nextSegment, ref, hasClassDefinition);
            ++this.myMethodReferencesCount;
            if (hasClassDefinition) {
                ++this.myDefinedMethodsCount;
            }
        }
    }

    private static String combine(@NotNull String parentPackage, @NotNull String childName) {
        if (parentPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPackage", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "combine"));
        }
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "combine"));
        }
        return parentPackage.isEmpty() ? childName : parentPackage + "." + childName;
    }

    private void insertClass(@NotNull String parentPackage, @NotNull String className, @NotNull MethodReference ref, boolean hasClassDefinition) {
        if (parentPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPackage", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "insertClass"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "insertClass"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "insertClass"));
        }
        ++this.myMethodReferencesCount;
        if (hasClassDefinition) {
            ++this.myDefinedMethodsCount;
        }
        PackageTreeNode classNode = this.getOrCreateChild(parentPackage, className, NodeType.CLASS);
        classNode.insertMethod(ref, hasClassDefinition);
    }

    private void insertMethod(@NotNull MethodReference ref, boolean hasClassDefinition) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "insertMethod"));
        }
        ++this.myMethodReferencesCount;
        if (hasClassDefinition) {
            ++this.myDefinedMethodsCount;
        }
        PackageTreeNode methodNode = new PackageTreeNode(ref.getDefiningClass(), PackageTreeNode.formatMethod(ref), NodeType.METHOD, this);
        ++methodNode.myMethodReferencesCount;
        if (hasClassDefinition) {
            ++methodNode.myDefinedMethodsCount;
        }
        this.myNodes.add(methodNode);
    }

    private PackageTreeNode getOrCreateChild(String parentPackage, @NotNull String name, @NotNull NodeType type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "getOrCreateChild"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "getOrCreateChild"));
        }
        for (PackageTreeNode node : this.myNodes) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        PackageTreeNode node = new PackageTreeNode(parentPackage, name, type, this);
        this.myNodes.add(node);
        return node;
    }

    @NotNull
    private static String formatMethod(@NotNull MethodReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "formatMethod"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(DebuggerUtilsEx.signatureToName((String)ref.getReturnType()));
        sb.append(' ');
        sb.append(ref.getName());
        String paramList = ref.getParameterTypes().stream().map(typeDesc -> DebuggerUtilsEx.signatureToName((String)typeDesc.toString())).collect(Collectors.joining(", "));
        sb.append('(');
        sb.append(paramList);
        sb.append(')');
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "formatMethod"));
        }
        return string;
    }

    @NotNull
    public NodeType getNodeType() {
        NodeType nodeType = this.myNodeType;
        if (nodeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "getNodeType"));
        }
        return nodeType;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "getName"));
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        String string = PackageTreeNode.combine(this.myPackageName, this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/dex/PackageTreeNode", "getQualifiedName"));
        }
        return string;
    }

    @Override
    public TreeNode getChildAt(int i) {
        return this.myNodes.get(i);
    }

    @Override
    public int getChildCount() {
        return this.myNodes.size();
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.myNodes.indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.myNodes.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.myNodes);
    }

    public int getMethodRefCount() {
        return this.myMethodReferencesCount;
    }

    public int getDefinedMethodsCount() {
        return this.myDefinedMethodsCount;
    }

    public static enum NodeType {
        PACKAGE,
        CLASS,
        METHOD;

    }
}

