/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.atom;

import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class Range
implements BinaryObject {
    private long myStart;
    private long myEnd;
    private static final Entity ENTITY = new Entity("atom", "Range", "", "");

    public boolean isValid() {
        return this.myStart >= 0L && this.myStart < this.myEnd;
    }

    public long getLast() {
        return this.myEnd - 1L;
    }

    public boolean contains(long atomImdex) {
        return atomImdex >= this.myStart && atomImdex < this.myEnd;
    }

    public boolean contains(Range range) {
        return this.myStart <= range.getStart() && this.myEnd >= range.getEnd();
    }

    public static boolean contains(Range[] list, long atomIndex) {
        int rangeIndex = Arrays.binarySearch(list, null, (x, ignored) -> atomIndex < x.myStart ? 1 : (atomIndex >= x.myEnd ? -1 : 0));
        return rangeIndex >= 0;
    }

    public boolean overlaps(Range range) {
        return this.myStart < range.getEnd() && range.getStart() < this.myEnd;
    }

    public long getCount() {
        return this.myEnd - this.myStart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (this.myStart != range.myStart) {
            return false;
        }
        return this.myEnd == range.myEnd;
    }

    public int hashCode() {
        int result = (int)(this.myStart ^ this.myStart >>> 32);
        result = 31 * result + (int)(this.myEnd ^ this.myEnd >>> 32);
        return result;
    }

    public String toString() {
        return "Range{start=" + this.myStart + ", end=" + this.myEnd + '}';
    }

    public long getStart() {
        return this.myStart;
    }

    public Range setStart(long v) {
        this.myStart = v;
        return this;
    }

    public long getEnd() {
        return this.myEnd;
    }

    public Range setEnd(long v) {
        this.myEnd = v;
        return this;
    }

    @NotNull
    public BinaryClass klass() {
        Klass klass = Klass.INSTANCE;
        if (klass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/Range", "klass"));
        }
        return klass;
    }

    public static void register() {
    }

    static {
        ENTITY.setFields(new Field[]{new Field("Start", (Type)new Primitive("uint64", Method.Uint64)), new Field("End", (Type)new Primitive("uint64", Method.Uint64))});
        Namespace.register((BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @NotNull
        public Entity entity() {
            Entity entity = ENTITY;
            if (entity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/Range$Klass", "entity"));
            }
            return entity;
        }

        @NotNull
        public BinaryObject create() {
            Range range = new Range();
            if (range == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/Range$Klass", "create"));
            }
            return range;
        }

        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/gfxtrace/service/atom/Range$Klass", "encode"));
            }
            Range o = (Range)obj;
            e.uint64(o.myStart);
            e.uint64(o.myEnd);
        }

        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            if (d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/editors/gfxtrace/service/atom/Range$Klass", "decode"));
            }
            Range o = (Range)obj;
            o.myStart = d.uint64();
            o.myEnd = d.uint64();
        }
    }
}

