/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables;

import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.structure.configurables.BaseNamedConfigurable;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.PsModuleCellRenderer;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowHeader;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasePerspectiveConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable,
Disposable,
Place.Navigator {
    @NotNull
    private final PsContext myContext;
    protected boolean myUiDisposed;
    private ToolWindowHeader myHeader;
    private JBLoadingPanel myLoadingPanel;
    private JComponent myCenterComponent;
    private boolean myTreeInitiated;
    private boolean myTreeMinimized;
    private volatile boolean mySelectModuleQuietly;

    protected BasePerspectiveConfigurable(@NotNull PsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "<init>"));
        }
        this.myUiDisposed = true;
        context.add(new GradleSyncListener.Adapter(){

            @Override
            public void syncStarted(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable$1", "syncStarted"));
                }
                if (BasePerspectiveConfigurable.this.myLoadingPanel != null) {
                    BasePerspectiveConfigurable.this.myLoadingPanel.startLoading();
                }
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable$1", "syncSucceeded"));
                }
                BasePerspectiveConfigurable.this.stopSyncAnimation();
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable$1", "syncFailed"));
                }
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable$1", "syncFailed"));
                }
                BasePerspectiveConfigurable.this.stopSyncAnimation();
            }
        }, (Disposable)this);
        this.myContext = context;
        this.myContext.add((moduleName, source) -> {
            if (source != this) {
                this.mySelectModuleQuietly = true;
                this.selectModule(moduleName);
            }
        }, (Disposable)this);
        this.myContext.getAnalyzerDaemon().add(model -> {
            if (this.myTree.isShowing()) {
                UIUtil.invokeLaterIfNeeded(() -> UiUtil.revalidateAndRepaint((JComponent)this.myTree));
            }
        }, this);
        this.myTreeMinimized = PsUISettings.getInstance().MODULES_LIST_MINIMIZE;
        if (this.myTreeMinimized) {
            this.myToReInitWholePanel = true;
            this.reInitWholePanelIfNeeded();
        }
        PsUISettings.getInstance().addListener(settings -> {
            if (settings.MODULES_LIST_MINIMIZE != this.myTreeMinimized) {
                this.myTreeMinimized = settings.MODULES_LIST_MINIMIZE;
                this.myToReInitWholePanel = true;
                this.reInitWholePanelIfNeeded();
            }
        }, this);
    }

    private void stopSyncAnimation() {
        if (this.myLoadingPanel != null) {
            this.myLoadingPanel.stopLoading();
        }
    }

    private void selectModule(@NotNull String moduleName) {
        MasterDetailsComponent.MyNode node;
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "selectModule"));
        }
        PsModule module = this.findModule(moduleName);
        if (module != null && (node = BasePerspectiveConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)module)) != null) {
            this.selectNodeInTree(moduleName);
            this.setSelectedNode(node);
        }
    }

    @Nullable
    protected PsModule findModule(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "findModule"));
        }
        PsModule module = this.myContext.getProject().findModuleByName(moduleName);
        if (module == null) {
            for (PsModule extraModule : this.getExtraTopModules()) {
                if (!moduleName.equals(extraModule.getName())) continue;
                module = extraModule;
                break;
            }
        }
        return module;
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        super.updateSelection(configurable);
        if (configurable instanceof BaseNamedConfigurable) {
            BaseNamedConfigurable baseConfigurable = (BaseNamedConfigurable)configurable;
            Object module = baseConfigurable.getEditableObject();
            if (!this.mySelectModuleQuietly) {
                this.myContext.setSelectedModule(((PsModule)module).getName(), (Object)this);
            } else {
                this.mySelectModuleQuietly = false;
            }
        }
        this.myHistory.pushQueryPlace();
    }

    protected void reInitWholePanelIfNeeded() {
        if (!this.myToReInitWholePanel) {
            return;
        }
        if (this.myTreeMinimized) {
            Splitter splitter = this.getSplitter();
            this.myCenterComponent = splitter.getSecondComponent();
            if (this.myCenterComponent == null) {
                super.reInitWholePanelIfNeeded();
                splitter = this.getSplitter();
                this.myCenterComponent = splitter.getSecondComponent();
            }
            this.myToReInitWholePanel = false;
            splitter.setSecondComponent(null);
            this.myWholePanel.remove((Component)splitter);
            this.myWholePanel.add((Component)this.myCenterComponent, "Center");
            UiUtil.revalidateAndRepaint(this.myWholePanel);
        } else {
            if (this.myWholePanel == null) {
                super.reInitWholePanelIfNeeded();
            }
            this.myToReInitWholePanel = false;
            Splitter splitter = this.getSplitter();
            if (this.myCenterComponent != null && this.myCenterComponent != splitter) {
                this.myWholePanel.remove(this.myCenterComponent);
                splitter.setSecondComponent(this.myCenterComponent);
                this.myWholePanel.add((Component)splitter);
                UiUtil.revalidateAndRepaint(this.myWholePanel);
            }
            this.myCenterComponent = splitter;
            JComponent first = splitter.getFirstComponent();
            if (first instanceof JPanel && this.myHeader == null) {
                JPanel panel = (JPanel)first;
                this.myHeader = ToolWindowHeader.createAndAdd("Modules", AllIcons.Nodes.Module, panel, ToolWindowAnchor.LEFT);
                this.myHeader.setPreferredFocusedComponent((JComponent)this.myTree);
                this.myHeader.addMinimizeListener(() -> {
                    this.modulesTreeMinimized();
                    this.reInitWholePanelIfNeeded();
                });
            }
        }
    }

    private void modulesTreeMinimized() {
        PsUISettings settings = PsUISettings.getInstance();
        this.myToReInitWholePanel = true;
        this.myTreeMinimized = true;
        settings.MODULES_LIST_MINIMIZE = true;
        settings.fireUISettingsChanged();
    }

    public void reset() {
        this.myUiDisposed = false;
        if (!this.myTreeInitiated) {
            this.initTree();
            this.myTree.setShowsRootHandles(false);
            this.loadTree();
        } else {
            super.disposeUIResources();
            this.myTree.setShowsRootHandles(false);
            this.loadTree();
        }
        super.reset();
    }

    protected void initTree() {
        if (this.myTreeInitiated) {
            return;
        }
        this.myTreeInitiated = true;
        super.initTree();
        this.myTree.setRootVisible(false);
        new TreeSpeedSearch(this.myTree, treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName(), true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new PsModuleCellRenderer(this.myContext)));
    }

    protected void loadTree() {
        List<PsModule> extraTopModules = this.getExtraTopModules();
        this.createModuleNodes(extraTopModules);
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        this.myUiDisposed = false;
    }

    @NotNull
    public JComponent createComponent() {
        JComponent contents = super.createComponent();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        this.myLoadingPanel.setLoadingText("Syncing Project with Gradle");
        this.myLoadingPanel.add((Component)contents, (Object)"Center");
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "createComponent"));
        }
        return jBLoadingPanel;
    }

    @NotNull
    protected List<PsModule> getExtraTopModules() {
        List<PsModule> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "getExtraTopModules"));
        }
        return list;
    }

    private void createModuleNodes(@NotNull List<PsModule> extraTopModules) {
        if (extraTopModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraTopModules", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "createModuleNodes"));
        }
        extraTopModules.forEach(this::addConfigurableFor);
        this.myContext.getProject().forEachModule(this::addConfigurableFor);
    }

    private void addConfigurableFor(@NotNull PsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "addConfigurableFor"));
        }
        NamedConfigurable<? extends PsModule> configurable = this.getConfigurable(module);
        if (configurable != null) {
            MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode(configurable);
            this.myRoot.add((MutableTreeNode)node);
        }
    }

    @Nullable
    protected abstract NamedConfigurable<? extends PsModule> getConfigurable(@NotNull PsModule var1);

    @NotNull
    protected PsContext getContext() {
        PsContext psContext = this.myContext;
        if (psContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "getContext"));
        }
        return psContext;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        String moduleName;
        Object path;
        if (place != null && (path = place.getPath(this.getNavigationPathName())) instanceof String && !StringUtil.isEmpty((String)(moduleName = (String)path))) {
            ActionCallback callback = new ActionCallback();
            this.getContext().setSelectedModule(moduleName, (Object)this);
            this.selectModule(moduleName);
            NamedConfigurable selectedConfigurable = this.getSelectedConfigurable();
            if (selectedConfigurable != null) {
                Place.goFurther((Object)selectedConfigurable, (Place)place, (boolean)requestFocus).notifyWhenDone(callback);
                return callback;
            }
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "queryPlace"));
        }
        NamedConfigurable selectedConfigurable = this.getSelectedConfigurable();
        if (selectedConfigurable instanceof BaseNamedConfigurable) {
            Object module = ((BaseNamedConfigurable)selectedConfigurable).getEditableObject();
            String moduleName = ((PsModule)module).getName();
            place.putPath(this.getNavigationPathName(), (Object)moduleName);
            Place.queryFurther((Object)selectedConfigurable, (Place)place);
            return;
        }
        place.putPath(this.getNavigationPathName(), (Object)"");
    }

    @NotNull
    protected abstract String getNavigationPathName();

    @Nullable
    public NamedConfigurable getSelectedConfigurable() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent();
            return node.getConfigurable();
        }
        return null;
    }

    public void putNavigationPath(@NotNull Place place, @NotNull String moduleName, @NotNull String dependency) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "putNavigationPath"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "putNavigationPath"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/configurables/BasePerspectiveConfigurable", "putNavigationPath"));
        }
        place.putPath(this.getNavigationPathName(), (Object)moduleName);
        PsModule module = this.findModule(moduleName);
        assert (module != null);
        MasterDetailsComponent.MyNode node = BasePerspectiveConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)module);
        assert (node != null);
        NamedConfigurable configurable = node.getConfigurable();
        assert (configurable instanceof BaseNamedConfigurable);
        BaseNamedConfigurable dependenciesConfigurable = (BaseNamedConfigurable)configurable;
        dependenciesConfigurable.putNavigationPath(place, dependency);
    }

    public void disposeUIResources() {
        if (this.myUiDisposed) {
            return;
        }
        super.disposeUIResources();
        this.myUiDisposed = true;
        this.myAutoScrollHandler.cancelAllRequests();
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        if (this.myHeader != null) {
            Disposer.dispose((Disposable)this.myHeader);
        }
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }
}

