/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.AndroidModuleTemplatesProvider;
import com.android.tools.idea.npw.ModuleTemplate;
import com.android.tools.idea.npw.NewModuleDynamicPath;
import com.android.tools.idea.npw.NewModuleDynamicPathFactory;
import com.android.tools.idea.npw.NewProjectWizardDynamic;
import com.android.tools.idea.npw.PostStartupGradleSyncListener;
import com.android.tools.idea.npw.deprecated.ChooseModuleTypeStep;
import com.android.tools.idea.npw.deprecated.ConfigureAndroidProjectPath;
import com.android.tools.idea.npw.deprecated.NewFormFactorModulePath;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.dynamic.SingleStepPath;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewModuleWizardDynamic
extends DynamicWizard {
    public NewModuleWizardDynamic(@Nullable Project project, @Nullable Module module) {
        super(project, module, "New Module");
        this.setTitle("Create New Module");
    }

    public NewModuleWizardDynamic(@Nullable Project project, @Nullable Module module, @NotNull DynamicWizardHost host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/idea/npw/NewModuleWizardDynamic", "<init>"));
        }
        super(project, module, "New Module", host);
        this.setTitle("Create New Module");
    }

    @Override
    public void init() {
        if (!this.checkSdk()) {
            return;
        }
        this.addPaths();
        ConfigureAndroidProjectPath.putSdkDependentParams(this.getState());
        this.initState();
        super.init();
    }

    protected boolean checkSdk() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable() || !TemplateManager.templatesAreValid()) {
            String title = "SDK problem";
            String msg = "<html>Your Android SDK is missing, out of date, or is missing templates.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            return false;
        }
        return true;
    }

    private void initState() {
        ScopedStateStore state = this.getState();
        Project project = this.getProject();
        NewProjectWizardDynamic.initState(state, NewModuleWizardDynamic.determineGradlePluginVersion(project));
        if (project != null) {
            state.put(WizardConstants.PROJECT_LOCATION_KEY, project.getBasePath());
        }
    }

    @NotNull
    private static String determineGradlePluginVersion(@Nullable Project project) {
        if (project != null) {
            GradleVersion versionInUse = GradleUtil.getAndroidGradleModelVersionInUse(project);
            if (versionInUse != null) {
                String string = versionInUse.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/NewModuleWizardDynamic", "determineGradlePluginVersion"));
                }
                return string;
            }
            GradleVersion versionFromBuildFile = GradleUtil.getAndroidGradleModelVersionFromBuildFile(project);
            if (versionFromBuildFile != null) {
                String string = versionFromBuildFile.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/NewModuleWizardDynamic", "determineGradlePluginVersion"));
                }
                return string;
            }
        }
        if ("2.2.2" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/NewModuleWizardDynamic", "determineGradlePluginVersion"));
        }
        return "2.2.2";
    }

    @NotNull
    public static DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings buildHeader() {
        DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings wizardStepHeaderSettings = DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createProductHeader("New Module");
        if (wizardStepHeaderSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/NewModuleWizardDynamic", "buildHeader"));
        }
        return wizardStepHeaderSettings;
    }

    private void addPaths() {
        Collection<NewModuleDynamicPath> contributions = this.getContributedPaths();
        Iterable templateProviders = Iterables.concat((Iterable)ImmutableSet.of((Object)new AndroidModuleTemplatesProvider()), contributions);
        this.addPath(new SingleStepPath(new ChooseModuleTypeStep(templateProviders, this.getDisposable())));
        for (NewFormFactorModulePath path : NewFormFactorModulePath.getAvailableFormFactorModulePaths(this.getDisposable())) {
            path.setGradleSyncIfNecessary(false);
            this.addPath(path);
        }
        for (NewModuleDynamicPath contribution : contributions) {
            this.addPath(contribution);
        }
    }

    private Collection<NewModuleDynamicPath> getContributedPaths() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (NewModuleDynamicPathFactory factory : (NewModuleDynamicPathFactory[])NewModuleDynamicPathFactory.EP_NAME.getExtensions()) {
            builder.addAll(factory.createWizardPaths(this.getProject(), this.getDisposable()));
        }
        return builder.build();
    }

    @Override
    protected String getWizardActionDescription() {
        String applicationName = this.getState().get(WizardConstants.APPLICATION_NAME_KEY);
        if (StringUtil.isEmptyOrSpaces((String)applicationName)) {
            ModuleTemplate moduleType = this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
            applicationName = moduleType != null ? moduleType.getName() : "Module";
        }
        return String.format("Create %1$s", applicationName);
    }

    @Override
    public void performFinishingActions() {
        final Project project = this.getProject();
        if (project == null) {
            return;
        }
        GradleProjectImporter.getInstance().requestProjectSync(project, new PostStartupGradleSyncListener(new Runnable(){

            @Override
            public void run() {
                Collection filesToOpen = NewModuleWizardDynamic.this.myState.get(WizardConstants.FILES_TO_OPEN_KEY);
                assert (filesToOpen != null);
                TemplateUtils.openEditors(project, filesToOpen, true);
            }
        }));
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Creating module..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/NewModuleWizardDynamic", "getProgressTitle"));
        }
        return "Creating module...";
    }
}

