/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.assetstudiolib.ActionBarIconGenerator;
import com.android.assetstudiolib.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidActionBarIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.icon.AndroidLauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.ui.ImageAssetBrowser;
import com.android.tools.idea.npw.assetstudio.ui.TextAssetEditor;
import com.android.tools.idea.npw.assetstudio.ui.VectorIconButton;
import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.SettableValue;
import com.android.tools.idea.ui.properties.adapters.OptionalToValuePropertyAdapter;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.expressions.Expression;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpression;
import com.android.tools.idea.ui.properties.expressions.optional.AsOptionalExpression;
import com.android.tools.idea.ui.properties.expressions.string.FormatExpression;
import com.android.tools.idea.ui.properties.swing.ColorProperty;
import com.android.tools.idea.ui.properties.swing.EnabledProperty;
import com.android.tools.idea.ui.properties.swing.SelectedItemProperty;
import com.android.tools.idea.ui.properties.swing.SelectedProperty;
import com.android.tools.idea.ui.properties.swing.SliderValueProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.properties.swing.VisibleProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class ConfigureIconPanel
extends JPanel
implements Disposable {
    private static final Dimension CLIPART_RESOLUTION = new Dimension(256, 256);
    @NotNull
    private final List<ActionListener> myAssetListeners;
    @NotNull
    private final AndroidIconType myIconType;
    @NotNull
    private final AndroidIconGenerator myIconGenerator;
    private final BindingsManager myGeneralBindings;
    private final BindingsManager myActiveAssetBindings;
    private final ListenerManager myListeners;
    private final ObjectProperty<BaseAsset> myActiveAsset;
    private final StringProperty myOutputName;
    private final ImmutableMap<JRadioButton, ? extends AssetComponent> myAssetPanelMap;
    private final Map<GraphicGenerator.Shape, String> myShapeNames;
    private JPanel myRootPanel;
    private JRadioButton myClipartRadioButton;
    private JRadioButton myTextRadioButton;
    private JRadioButton myImageRadioButton;
    private JPanel myAllOptionsPanel;
    private JPanel mySourceAssetTypePanel;
    private JPanel myIconOptionsPanel;
    private JRadioButton myTrimmedRadioButton;
    private JRadioButton myNotTrimmedRadioButton;
    private JPanel myTrimOptionsPanel;
    private JSlider myPaddingSlider;
    private JLabel myPaddingValueLabel;
    private JPanel myAssetRadioButtonsPanel;
    private JPanel myPaddingSliderPanel;
    private JTextField myOutputNameTextField;
    private JPanel myOutputNamePanel;
    private JPanel myTrimRowPanel;
    private JPanel myNameRowPanel;
    private JPanel myPaddingRowPanel;
    private JPanel myForegroundRowPanel;
    private ColorPanel myForegroundColorPanel;
    private JPanel myBackgroundRowPanel;
    private ColorPanel myBackgroundColorPanel;
    private JPanel myScalingRowPanel;
    private JPanel myShapeRowPanel;
    private JPanel myScalingRadioButtonsPanel;
    private JRadioButton myCropRadioButton;
    private JRadioButton myShrinkToFitRadioButton;
    private JPanel myEffectRadioButtonsPanel;
    private JRadioButton myNoEffectRadioButton;
    private JRadioButton myDogEarRadioButton;
    private JPanel myThemeRowPanel;
    private JComboBox myThemeComboBox;
    private JPanel myEffectRowPanel;
    private JBScrollPane myScrollPane;
    private JComboBox myShapeComboBox;
    private JPanel myCustomThemeRowPanel;
    private ColorPanel myCustomThemeColorPanel;
    private JPanel myAssetPanels;
    private JPanel myImageAssetRowPanel;
    private JPanel myClipartAssetRowPanel;
    private JPanel myTextAssetRowPanel;
    private ImageAssetBrowser myImageAssetBrowser;
    private VectorIconButton myClipartAssetButton;
    private TextAssetEditor myTextAssetEditor;
    private JBLabel myOutputNameLabel;
    private JLabel myAssetTypeLabel;
    private JBLabel myImagePathLabel;
    private JBLabel myClipartLabel;
    private JBLabel myTextLabel;
    private JBLabel myTrimLabel;
    private JBLabel myPaddingLabel;
    private JBLabel myForegroundLabel;
    private JBLabel myThemeLabel;
    private JBLabel myCustomColorLabel;
    private JBLabel myBackgroundLabel;
    private JBLabel myScalingLabel;
    private JBLabel myShapeLabel;
    private JBLabel myEffectLabel;
    private BoolProperty myIgnoreForegroundColor;
    private AbstractProperty<Color> myForegroundColor;
    private AbstractProperty<Color> myBackgroundColor;
    private BoolProperty myCropped;
    private BoolProperty myDogEared;
    private AbstractProperty<ActionBarIconGenerator.Theme> myTheme;
    private AbstractProperty<GraphicGenerator.Shape> myShape;
    private AbstractProperty<Color> myThemeColor;

    public ConfigureIconPanel(@NotNull Disposable disposableParent, @NotNull AndroidIconType iconType) {
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/android/tools/idea/npw/assetstudio/ui/ConfigureIconPanel", "<init>"));
        }
        if (iconType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconType", "com/android/tools/idea/npw/assetstudio/ui/ConfigureIconPanel", "<init>"));
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myAssetListeners = Lists.newArrayListWithExpectedSize((int)1);
        this.myGeneralBindings = new BindingsManager();
        this.myActiveAssetBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myShapeNames = ImmutableMap.of((Object)GraphicGenerator.Shape.NONE, (Object)"None", (Object)GraphicGenerator.Shape.CIRCLE, (Object)"Circle", (Object)GraphicGenerator.Shape.SQUARE, (Object)"Square", (Object)GraphicGenerator.Shape.VRECT, (Object)"Vertical", (Object)GraphicGenerator.Shape.HRECT, (Object)"Horizontal");
        this.myIconType = iconType;
        this.myIconGenerator = AndroidIconType.createIconGenerator(iconType);
        DefaultComboBoxModel<ActionBarIconGenerator.Theme> themesModel = new DefaultComboBoxModel<ActionBarIconGenerator.Theme>(ActionBarIconGenerator.Theme.values());
        this.myThemeComboBox.setModel(themesModel);
        DefaultComboBoxModel<GraphicGenerator.Shape> shapesModel = new DefaultComboBoxModel<GraphicGenerator.Shape>();
        for (GraphicGenerator.Shape shape : this.myShapeNames.keySet()) {
            shapesModel.addElement(shape);
        }
        this.myShapeComboBox.setRenderer(new ListCellRendererWrapper<GraphicGenerator.Shape>(){

            public void customize(JList list, GraphicGenerator.Shape shape, int index, boolean selected, boolean hasFocus) {
                this.setText((String)ConfigureIconPanel.this.myShapeNames.get(shape));
            }
        });
        this.myShapeComboBox.setModel(shapesModel);
        this.myShapeComboBox.setSelectedItem(GraphicGenerator.Shape.SQUARE);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myScrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myOutputName = new TextProperty(this.myOutputNameTextField);
        this.myAssetPanelMap = ImmutableMap.of((Object)this.myImageRadioButton, (Object)this.myImageAssetBrowser, (Object)this.myClipartRadioButton, (Object)this.myClipartAssetButton, (Object)this.myTextRadioButton, (Object)this.myTextAssetEditor);
        this.myOutputNameLabel.setLabelFor((Component)this.myOutputNameTextField);
        this.myAssetTypeLabel.setLabelFor(this.myAssetRadioButtonsPanel);
        this.myImagePathLabel.setLabelFor((Component)((Object)this.myImageAssetBrowser));
        this.myClipartLabel.setLabelFor((Component)this.myClipartAssetButton);
        this.myTextLabel.setLabelFor((Component)this.myTextAssetEditor);
        this.myTrimLabel.setLabelFor((Component)this.myTrimOptionsPanel);
        this.myPaddingLabel.setLabelFor((Component)this.myPaddingSliderPanel);
        this.myForegroundLabel.setLabelFor((Component)this.myForegroundColorPanel);
        this.myThemeLabel.setLabelFor((Component)this.myThemeComboBox);
        this.myCustomColorLabel.setLabelFor((Component)this.myCustomThemeColorPanel);
        this.myBackgroundLabel.setLabelFor((Component)this.myBackgroundColorPanel);
        this.myScalingLabel.setLabelFor((Component)this.myScalingRadioButtonsPanel);
        this.myShapeLabel.setLabelFor((Component)this.myShapeComboBox);
        this.myEffectLabel.setLabelFor((Component)this.myEffectRadioButtonsPanel);
        VectorAsset clipartAsset = this.myClipartAssetButton.getAsset();
        clipartAsset.outputWidth().set(ConfigureIconPanel.CLIPART_RESOLUTION.width);
        clipartAsset.outputHeight().set(ConfigureIconPanel.CLIPART_RESOLUTION.height);
        this.myActiveAsset = new ObjectValueProperty<VectorAsset>(clipartAsset);
        this.myClipartRadioButton.setSelected(true);
        this.initializeListenersAndBindings();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        for (AssetComponent assetComponent : this.myAssetPanelMap.values()) {
            Disposer.register((Disposable)this, (Disposable)assetComponent);
        }
        this.add(this.myRootPanel);
    }

    private void initializeListenersAndBindings() {
        SelectedProperty trimmed = new SelectedProperty(this.myTrimmedRadioButton);
        SliderValueProperty paddingPercent = new SliderValueProperty(this.myPaddingSlider);
        TextProperty paddingValueString = new TextProperty(this.myPaddingValueLabel);
        this.myGeneralBindings.bind(paddingValueString, new FormatExpression("%d %%", paddingPercent));
        this.myIgnoreForegroundColor = new SelectedProperty(this.myImageRadioButton);
        this.myForegroundColor = new OptionalToValuePropertyAdapter<Color>(new ColorProperty(this.myForegroundColorPanel));
        this.myBackgroundColor = new OptionalToValuePropertyAdapter<Color>(new ColorProperty(this.myBackgroundColorPanel));
        this.myCropped = new SelectedProperty(this.myCropRadioButton);
        this.myDogEared = new SelectedProperty(this.myDogEarRadioButton);
        this.myTheme = new OptionalToValuePropertyAdapter<ActionBarIconGenerator.Theme>(new SelectedItemProperty(this.myThemeComboBox));
        this.myThemeColor = new OptionalToValuePropertyAdapter<Color>(new ColorProperty(this.myCustomThemeColorPanel));
        this.myShape = new OptionalToValuePropertyAdapter<GraphicGenerator.Shape>(new SelectedItemProperty(this.myShapeComboBox));
        this.updateBindingsAndUiForActiveIconType();
        ActionListener radioSelectedListener = e -> {
            JRadioButton source = (JRadioButton)e.getSource();
            AssetComponent assetComponent = (AssetComponent)this.myAssetPanelMap.get((Object)source);
            this.myActiveAsset.set((BaseAsset)assetComponent.getAsset());
        };
        this.myClipartRadioButton.addActionListener(radioSelectedListener);
        this.myImageRadioButton.addActionListener(radioSelectedListener);
        this.myTextRadioButton.addActionListener(radioSelectedListener);
        ActionListener assetPanelListener = e -> this.fireAssetListeners();
        for (AssetComponent assetComponent : this.myAssetPanelMap.values()) {
            assetComponent.addAssetListener(assetPanelListener);
        }
        Runnable onAssetModified = this::fireAssetListeners;
        this.myListeners.listenAll(trimmed, paddingPercent, this.myForegroundColor, this.myBackgroundColor, this.myCropped, this.myDogEared, this.myTheme, this.myThemeColor, this.myShape).with(onAssetModified);
        this.myListeners.listenAndFire(this.myActiveAsset, sender -> {
            this.myActiveAssetBindings.releaseAll();
            this.myActiveAssetBindings.bindTwoWay(trimmed, ((BaseAsset)this.myActiveAsset.get()).trimmed());
            this.myActiveAssetBindings.bindTwoWay(paddingPercent, ((BaseAsset)this.myActiveAsset.get()).paddingPercent());
            this.myActiveAssetBindings.bindTwoWay(this.myForegroundColor, ((BaseAsset)this.myActiveAsset.get()).color());
            this.getIconGenerator().sourceAsset().setValue((BaseAsset)this.myActiveAsset.get());
            onAssetModified.run();
        });
        BoolValueProperty isLauncherIcon = new BoolValueProperty(this.myIconType.equals((Object)AndroidIconType.LAUNCHER));
        BoolValueProperty isActionBarIcon = new BoolValueProperty(this.myIconType.equals((Object)AndroidIconType.ACTIONBAR));
        ObservableBool isCustomTheme = this.myTheme.isEqualTo(ActionBarIconGenerator.Theme.CUSTOM);
        Expression<Boolean> isClipartOrText = this.myActiveAsset.transform(asset -> this.myClipartAssetButton.getAsset() == asset || this.myTextAssetEditor.getAsset() == asset);
        BooleanExpression supportsEffects = new BooleanExpression(new ObservableValue[]{this.myShape}){

            @Override
            @NotNull
            public Boolean get() {
                GraphicGenerator.Shape shape = (GraphicGenerator.Shape)ConfigureIconPanel.this.myShape.get();
                switch (shape) {
                    case SQUARE: 
                    case VRECT: 
                    case HRECT: {
                        Boolean bl = true;
                        if (bl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/ConfigureIconPanel$2", "get"));
                        }
                        return bl;
                    }
                }
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/ConfigureIconPanel$2", "get"));
                }
                return bl;
            }
        };
        ImmutableMap.Builder layoutPropertiesBuilder = ImmutableMap.builder();
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myImageAssetRowPanel), (Object)new SelectedProperty(this.myImageRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myClipartAssetRowPanel), (Object)new SelectedProperty(this.myClipartRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myTextAssetRowPanel), (Object)new SelectedProperty(this.myTextRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundRowPanel), (Object)isLauncherIcon.and(isClipartOrText));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myScalingRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myShapeRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myEffectRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myDogEarRadioButton), (Object)supportsEffects);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myThemeRowPanel), (Object)isActionBarIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myCustomThemeRowPanel), (Object)isActionBarIcon.and(isCustomTheme));
        ImmutableMap layoutProperties = layoutPropertiesBuilder.build();
        for (Map.Entry e2 : layoutProperties.entrySet()) {
            ((BoolProperty)e2.getKey()).set(false);
            this.myGeneralBindings.bind((SettableValue)e2.getKey(), (ObservableValue)e2.getValue());
        }
        this.myListeners.listenAll((Collection<? extends ObservableValue<?>>)layoutProperties.keySet()).with(() -> SwingUtilities.updateComponentTreeUI(this.myAllOptionsPanel));
    }

    @NotNull
    public BaseAsset getAsset() {
        BaseAsset baseAsset = (BaseAsset)this.myActiveAsset.get();
        if (baseAsset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/ConfigureIconPanel", "getAsset"));
        }
        return baseAsset;
    }

    @NotNull
    public AndroidIconGenerator getIconGenerator() {
        AndroidIconGenerator androidIconGenerator = this.myIconGenerator;
        if (androidIconGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/ConfigureIconPanel", "getIconGenerator"));
        }
        return androidIconGenerator;
    }

    public void addAssetListener(@NotNull ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/npw/assetstudio/ui/ConfigureIconPanel", "addAssetListener"));
        }
        this.myAssetListeners.add(listener);
    }

    @NotNull
    public StringProperty outputName() {
        StringProperty stringProperty = this.myOutputName;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/ui/ConfigureIconPanel", "outputName"));
        }
        return stringProperty;
    }

    private void fireAssetListeners() {
        ActionEvent e = new ActionEvent(this, 1001, null);
        for (ActionListener assetListener : this.myAssetListeners) {
            assetListener.actionPerformed(e);
        }
    }

    private void updateBindingsAndUiForActiveIconType() {
        this.myOutputName.set(this.myIconType.toOutputName("name"));
        this.myGeneralBindings.bind(this.myIconGenerator.sourceAsset(), new AsOptionalExpression<BaseAsset>(this.myActiveAsset));
        this.myGeneralBindings.bind(this.myIconGenerator.name(), this.myOutputName);
        switch (this.myIconType) {
            case LAUNCHER: {
                AndroidLauncherIconGenerator launcherIconGenerator = (AndroidLauncherIconGenerator)this.myIconGenerator;
                this.myGeneralBindings.bind(launcherIconGenerator.useForegroundColor(), this.myIgnoreForegroundColor.not());
                this.myGeneralBindings.bindTwoWay(this.myForegroundColor, launcherIconGenerator.foregroundColor());
                this.myGeneralBindings.bindTwoWay(this.myBackgroundColor, launcherIconGenerator.backgroundColor());
                this.myGeneralBindings.bindTwoWay(this.myCropped, launcherIconGenerator.cropped());
                this.myGeneralBindings.bindTwoWay(this.myShape, launcherIconGenerator.shape());
                this.myGeneralBindings.bindTwoWay(this.myDogEared, launcherIconGenerator.dogEared());
                break;
            }
            case ACTIONBAR: {
                AndroidActionBarIconGenerator actionBarIconGenerator = (AndroidActionBarIconGenerator)this.myIconGenerator;
                this.myGeneralBindings.bindTwoWay(this.myThemeColor, actionBarIconGenerator.customColor());
                this.myGeneralBindings.bindTwoWay(this.myTheme, actionBarIconGenerator.theme());
                break;
            }
        }
    }

    public void dispose() {
        this.myGeneralBindings.releaseAll();
        this.myActiveAssetBindings.releaseAll();
        this.myListeners.releaseAll();
        this.myAssetListeners.clear();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        TextAssetEditor textAssetEditor;
        JBLabel jBLabel2;
        JPanel jPanel3;
        VectorIconButton vectorIconButton;
        JBLabel jBLabel3;
        JPanel jPanel4;
        ImageAssetBrowser imageAssetBrowser;
        JBLabel jBLabel4;
        JPanel jPanel5;
        JPanel jPanel6;
        ColorPanel colorPanel;
        JBLabel jBLabel5;
        JPanel jPanel7;
        JComboBox jComboBox;
        JBLabel jBLabel6;
        JPanel jPanel8;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel9;
        JBLabel jBLabel7;
        JPanel jPanel10;
        JComboBox jComboBox2;
        JBLabel jBLabel8;
        JPanel jPanel11;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel12;
        JBLabel jBLabel9;
        JPanel jPanel13;
        ColorPanel colorPanel2;
        JBLabel jBLabel10;
        JPanel jPanel14;
        ColorPanel colorPanel3;
        JBLabel jBLabel11;
        JPanel jPanel15;
        JLabel jLabel;
        JSlider jSlider;
        JPanel jPanel16;
        JBLabel jBLabel12;
        JPanel jPanel17;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel18;
        JBLabel jBLabel13;
        JPanel jPanel19;
        JPanel jPanel20;
        JRadioButton jRadioButton7;
        JRadioButton jRadioButton8;
        JRadioButton jRadioButton9;
        JPanel jPanel21;
        JLabel jLabel2;
        JPanel jPanel22;
        JPanel jPanel23;
        JBScrollPane jBScrollPane;
        JPanel jPanel24;
        this.myRootPanel = jPanel24 = new JPanel();
        jPanel24.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel24.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myAllOptionsPanel = jPanel23 = new JPanel();
        jPanel23.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel23);
        jPanel23.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), null, 0, 0, null, null));
        this.mySourceAssetTypePanel = jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel22, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myAssetTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Asset Type:");
        jPanel22.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAssetRadioButtonsPanel = jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel22.add((Component)jPanel21, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myClipartRadioButton = jRadioButton9 = new JRadioButton();
        jRadioButton9.setText("Clip Art");
        jRadioButton9.setToolTipText("Select from a list of clipart choices to generate Android icons for your app.");
        jPanel21.add((Component)jRadioButton9, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTextRadioButton = jRadioButton8 = new JRadioButton();
        jRadioButton8.setText("Text");
        jRadioButton8.setToolTipText("Enter text which will be rendered into Android icons for your app.");
        jPanel21.add((Component)jRadioButton8, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myImageRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setText("Image");
        jRadioButton7.setToolTipText("Select an image from disk to generate Android icons for your app.");
        jPanel21.add((Component)jRadioButton7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIconOptionsPanel = jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel20, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myTrimRowPanel = jPanel19 = new JPanel();
        jPanel19.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel19).setVisible(true);
        jPanel20.add((Component)jPanel19, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myTrimLabel = jBLabel13 = new JBLabel();
        jBLabel13.setText("Trim:");
        jPanel19.add((Component)jBLabel13, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTrimOptionsPanel = jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel18, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel18.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTrimmedRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Yes");
        jRadioButton6.setToolTipText("Remove any transparent space from around your source asset before rendering to icon.");
        jPanel18.add((Component)jRadioButton6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNotTrimmedRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("No");
        jRadioButton5.setToolTipText("Leave the original asset unmodified.");
        jRadioButton5.setSelected(true);
        jPanel18.add((Component)jRadioButton5, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPaddingRowPanel = jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel17).setVisible(true);
        jPanel20.add((Component)jPanel17, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myPaddingLabel = jBLabel12 = new JBLabel();
        jBLabel12.setText("Padding:");
        jPanel17.add((Component)jBLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPaddingSliderPanel = jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel16, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPaddingSlider = jSlider = new JSlider();
        jSlider.setMaximum(50);
        jSlider.setPaintTicks(true);
        jSlider.setMinorTickSpacing(5);
        jSlider.setSnapToTicks(true);
        jSlider.setPaintLabels(false);
        jSlider.setValue(0);
        jSlider.setMinimum(-10);
        jSlider.setToolTipText("Add a percentage of padding around the original asset before rendering. This happens after any trimming.");
        jPanel16.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myPaddingValueLabel = jLabel = new JLabel();
        jLabel.setText("100 %");
        jLabel.setHorizontalAlignment(4);
        jPanel16.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel16.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myForegroundRowPanel = jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel15, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundLabel = jBLabel11 = new JBLabel();
        jBLabel11.setText("Foreground:");
        jPanel15.add((Component)jBLabel11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundColorPanel = colorPanel3 = new ColorPanel();
        colorPanel3.setSelectedColor(new Color(-16777216));
        jPanel15.add((Component)colorPanel3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myBackgroundRowPanel = jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel14, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundLabel = jBLabel10 = new JBLabel();
        jBLabel10.setText("Background:");
        jPanel14.add((Component)jBLabel10, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBackgroundColorPanel = colorPanel2 = new ColorPanel();
        colorPanel2.setSelectedColor(new Color(-1));
        jPanel14.add((Component)colorPanel2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myScalingRowPanel = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel13, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myScalingLabel = jBLabel9 = new JBLabel();
        jBLabel9.setText("Scaling:");
        jPanel13.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScalingRadioButtonsPanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel12, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCropRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Crop");
        jRadioButton4.setToolTipText("Crop source asset to fit icon size.");
        jPanel12.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShrinkToFitRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Shrink to Fit");
        jRadioButton3.setToolTipText("Shrink the source asset to fit icon size.");
        jRadioButton3.setSelected(true);
        jPanel12.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel12.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myShapeRowPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel11, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myShapeLabel = jBLabel8 = new JBLabel();
        jBLabel8.setText("Shape:");
        jPanel11.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel25 = new JPanel();
        jPanel25.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel25, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShapeComboBox = jComboBox2 = new JComboBox();
        jComboBox2.setToolTipText("The shape of the launcher icon's backdrop.");
        jPanel25.add(jComboBox2, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel25.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myEffectRowPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel10, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myEffectLabel = jBLabel7 = new JBLabel();
        jBLabel7.setText("Effect:");
        jPanel10.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEffectRadioButtonsPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel9, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myNoEffectRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("None");
        jRadioButton2.setToolTipText("Do not apply any transformative effects to the icon.");
        jRadioButton2.setSelected(true);
        jPanel9.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDogEarRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("DogEar");
        jRadioButton.setToolTipText("Add a fold to the top right of the icon's backdrop shape (if supported).");
        jPanel9.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel9.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myThemeRowPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel8, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myThemeLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Theme:");
        jPanel8.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel26 = new JPanel();
        jPanel26.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel26, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myThemeComboBox = jComboBox = new JComboBox();
        jPanel26.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel26.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCustomThemeRowPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel7, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myCustomColorLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Custom color:");
        jPanel7.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCustomThemeColorPanel = colorPanel = new ColorPanel();
        colorPanel.setSelectedColor(new Color(-1));
        jPanel7.add((Component)colorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 3, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel23.add((Component)spacer7, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myAssetPanels = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myImageAssetRowPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myImagePathLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Path:");
        jPanel5.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImageAssetBrowser = imageAssetBrowser = new ImageAssetBrowser();
        jPanel5.add((Component)((Object)imageAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myClipartAssetRowPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myClipartLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Clip Art:");
        jPanel4.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClipartAssetButton = vectorIconButton = new VectorIconButton();
        jPanel4.add((Component)vectorIconButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myTextAssetRowPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myTextLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Text:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTextAssetEditor = textAssetEditor = new TextAssetEditor();
        jPanel3.add((Component)textAssetEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myNameRowPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(true);
        jPanel23.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 3, null, null, null, 0, true));
        this.myOutputNameLabel = jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputNamePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myOutputNameTextField = jTextField = new JTextField();
        jTextField.setText("(name)");
        jTextField.setToolTipText("The filename which will be used for these icons.");
        jPanel.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton7);
        buttonGroup.add(jRadioButton9);
        buttonGroup.add(jRadioButton8);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton6);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

