/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.utils.SdkUtils;
import com.intellij.openapi.util.io.FileUtil;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioTemplateLoader
implements TemplateLoader {
    private final File myTemplateRootFolder;
    private final Stack<File> myLastTemplateFolders;
    private static final String ROOT = "root://";

    public StudioTemplateLoader(@NotNull File templateFolder) {
        if (templateFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateFolder", "com/android/tools/idea/templates/StudioTemplateLoader", "<init>"));
        }
        this.myTemplateRootFolder = StudioTemplateLoader.findTemplateRootFolder(templateFolder);
        this.myLastTemplateFolders = new Stack();
        this.myLastTemplateFolders.push(templateFolder);
    }

    public void pushTemplateFolder(@NotNull File folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/android/tools/idea/templates/StudioTemplateLoader", "pushTemplateFolder"));
        }
        this.myLastTemplateFolders.push(folder);
    }

    public void pushTemplateFolder(@NotNull String folderName) throws IOException {
        if (folderName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderName", "com/android/tools/idea/templates/StudioTemplateLoader", "pushTemplateFolder"));
        }
        this.myLastTemplateFolders.push(this.resolveName(folderName));
    }

    public void popTemplateFolder() {
        this.myLastTemplateFolders.pop();
    }

    @NotNull
    public String findTemplate(@NotNull File file) throws IOException {
        String path;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/StudioTemplateLoader", "findTemplate"));
        }
        if (!file.isAbsolute()) {
            file = this.resolveName(file.getPath());
        }
        if ((path = FileUtil.getRelativePath((File)this.myTemplateRootFolder, (File)file)) == null) {
            throw new IOException("Absolute paths must start with: " + this.myTemplateRootFolder.getPath());
        }
        String string = ROOT + FileUtil.toSystemIndependentName((String)path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/StudioTemplateLoader", "findTemplate"));
        }
        return string;
    }

    @NotNull
    public File getSourceFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/StudioTemplateLoader", "getSourceFile"));
        }
        String name = this.findTemplate(file);
        File file2 = this.resolveName(name);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/StudioTemplateLoader", "getSourceFile"));
        }
        return file2;
    }

    @Nullable
    public Object findTemplateSource(@NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/templates/StudioTemplateLoader", "findTemplateSource"));
        }
        File file = this.resolveName(name);
        TemplateSource templateSource = TemplateSource.open(file);
        this.pushTemplateFolder(file.getParentFile());
        return templateSource;
    }

    public long getLastModified(Object source) {
        TemplateSource templateSource = (TemplateSource)source;
        return templateSource.getLastModified();
    }

    @NotNull
    public Reader getReader(@NotNull Object source, @NotNull String encoding) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/templates/StudioTemplateLoader", "getReader"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/android/tools/idea/templates/StudioTemplateLoader", "getReader"));
        }
        TemplateSource templateSource = (TemplateSource)source;
        InputStreamReader inputStreamReader = new InputStreamReader(templateSource.getInputStream(), encoding);
        if (inputStreamReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/StudioTemplateLoader", "getReader"));
        }
        return inputStreamReader;
    }

    public void closeTemplateSource(Object source) throws IOException {
        TemplateSource templateSource = (TemplateSource)source;
        this.popTemplateFolder();
        templateSource.close();
    }

    @NotNull
    private File resolveName(@NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/templates/StudioTemplateLoader", "resolveName"));
        }
        File file = name.startsWith(ROOT) ? new File(this.myTemplateRootFolder, name.substring(ROOT.length())) : (this.myLastTemplateFolders != null ? new File(this.myLastTemplateFolders.peek(), name) : new File(this.myTemplateRootFolder, name));
        File file2 = file.getCanonicalFile();
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/StudioTemplateLoader", "resolveName"));
        }
        return file2;
    }

    @NotNull
    private static File findTemplateRootFolder(@NotNull File templateFolder) {
        File folder;
        if (templateFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateFolder", "com/android/tools/idea/templates/StudioTemplateLoader", "findTemplateRootFolder"));
        }
        for (folder = templateFolder; folder != null && !folder.getName().equals("templates"); folder = folder.getParentFile()) {
        }
        File file = folder != null ? folder : templateFolder;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/StudioTemplateLoader", "findTemplateRootFolder"));
        }
        return file;
    }

    private static final class TemplateSource {
        private final InputStream myInputStream;
        private final long myLastModifiedTime;

        private TemplateSource(@NotNull InputStream inputStream, long lastModified) {
            if (inputStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/android/tools/idea/templates/StudioTemplateLoader$TemplateSource", "<init>"));
            }
            this.myInputStream = inputStream;
            this.myLastModifiedTime = lastModified;
        }

        public static TemplateSource open(@NotNull File file) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/StudioTemplateLoader$TemplateSource", "open"));
            }
            if (!file.exists() && !file.isFile()) {
                return null;
            }
            return new TemplateSource(SdkUtils.fileToUrl((File)file).openStream(), file.lastModified());
        }

        @NotNull
        public InputStream getInputStream() {
            InputStream inputStream = this.myInputStream;
            if (inputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/StudioTemplateLoader$TemplateSource", "getInputStream"));
            }
            return inputStream;
        }

        public long getLastModified() {
            return this.myLastModifiedTime;
        }

        public void close() throws IOException {
            this.myInputStream.close();
        }
    }
}

