/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.DrawConstraintModel;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.surface.Interaction;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class ConstraintInteraction
extends Interaction {
    private final ScreenView myScreenView;
    private final NlComponent myComponent;

    public ConstraintInteraction(@NotNull ScreenView screenView, @NotNull NlComponent component) {
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintInteraction", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintInteraction", "<init>"));
        }
        this.myScreenView = screenView;
        this.myComponent = component;
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int startMask) {
        super.begin(x, y, startMask);
        int androidX = Coordinates.getAndroidX(this.myScreenView, this.myStartX);
        int androidY = Coordinates.getAndroidY(this.myScreenView, this.myStartY);
        DrawConstraintModel model = ConstraintModel.getDrawConstraintModel(this.myScreenView);
        model.updateModifiers(startMask);
        model.setInteractionComponent(this.myComponent.getParent() != null ? this.myComponent.getParent() : this.myComponent);
        model.mousePressed(androidX, androidY);
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        super.update(x, y, modifiers);
        DrawConstraintModel drawModel = ConstraintModel.getDrawConstraintModel(this.myScreenView);
        drawModel.updateModifiers(modifiers);
        int androidX = Coordinates.getAndroidX(this.myScreenView, x);
        int androidY = Coordinates.getAndroidY(this.myScreenView, y);
        drawModel.mouseDragged(androidX, androidY);
        ConstraintModel.getConstraintModel(this.myScreenView.getModel()).updateXml();
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean canceled) {
        super.end(x, y, modifiers, canceled);
        ConstraintModel model = ConstraintModel.getConstraintModel(this.myScreenView.getModel());
        if (canceled) {
            model.rollbackXml();
            return;
        }
        int ax = Coordinates.getAndroidX(this.myScreenView, x);
        int ay = Coordinates.getAndroidY(this.myScreenView, y);
        DrawConstraintModel drawConstraintModel = ConstraintModel.getDrawConstraintModel(this.myScreenView);
        drawConstraintModel.updateModifiers(modifiers);
        drawConstraintModel.mouseReleased(ax, ay);
        model.saveToXML(false);
        this.myScreenView.getSurface().repaint();
    }
}

