/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.androidstudio.actions;

import com.google.common.base.Splitter;
import com.intellij.androidstudio.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class CreateClassAction
extends AnAction {
    private final JavaDirectoryService myJavaDirectoryService = JavaDirectoryService.getInstance();

    public CreateClassAction() {
        super("Java Class");
    }

    public void actionPerformed(AnActionEvent event) {
        DataContext context = event.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(context);
        if (view == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return;
        }
        final PsiDirectory directory = view.getOrChooseDirectory();
        if (directory == null) {
            return;
        }
        CreateFileFromTemplateDialog dialog = new CreateFileFromTemplateDialog(project, directory);
        try {
            PsiClass createdElement = dialog.show(new CreateFileFromTemplateDialog.FileCreator(){

                @Override
                public PsiClass createFile(@NotNull String name, @NotNull Map<String, String> creationOptions, @NotNull String templateName) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/androidstudio/actions/CreateClassAction$1", "createFile"));
                    }
                    if (creationOptions == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creationOptions", "com/intellij/androidstudio/actions/CreateClassAction$1", "createFile"));
                    }
                    if (templateName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/androidstudio/actions/CreateClassAction$1", "createFile"));
                    }
                    String enteredPackageName = creationOptions.get("PACKAGE_NAME");
                    PsiDirectory packageSubdirectory = CreateClassAction.createPackageSubdirectory(directory, enteredPackageName);
                    return CreateClassAction.this.checkOrCreate(name, packageSubdirectory, templateName, creationOptions);
                }

                @Override
                @NotNull
                public String getActionName(@NotNull String name, @NotNull String templateName) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/androidstudio/actions/CreateClassAction$1", "getActionName"));
                    }
                    if (templateName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/androidstudio/actions/CreateClassAction$1", "getActionName"));
                    }
                    String packageDirectoryQualifiedName = CreateClassAction.this.myJavaDirectoryService.getPackage(directory).getQualifiedName();
                    String string = IdeBundle.message((String)"progress.creating.class", (Object[])new Object[]{StringUtil.getQualifiedName((String)packageDirectoryQualifiedName, (String)name)});
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/androidstudio/actions/CreateClassAction$1", "getActionName"));
                    }
                    return string;
                }
            });
            view.selectElement((PsiElement)createdElement);
            CreateFromTemplateAction.moveCaretAfterNameIdentifier((PsiNameIdentifierOwner)createdElement);
            if (dialog.isShowSelectOverridesDialogCheckBoxSelected()) {
                CreateClassAction.showOverridesDialog(event);
            }
        }
        catch (CreateFileFromTemplateDialog.FailedToCreateFileException exception) {
            Logger.getInstance(CreateClassAction.class).warn((Throwable)exception);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/androidstudio/actions/CreateClassAction", "update"));
        }
        boolean enabled = this.isAvailable(e.getDataContext());
        Presentation presentation = e.getPresentation();
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    private boolean isAvailable(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/androidstudio/actions/CreateClassAction", "isAvailable"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || view == null || view.getDirectories().length == 0) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || !CreateClassAction.checkPackageExists(dir)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPackageExists(PsiDirectory directory) {
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (psiPackage == null) {
            return false;
        }
        String name = psiPackage.getQualifiedName();
        return StringUtil.isEmpty((String)name) || PsiNameHelper.getInstance((Project)directory.getProject()).isQualifiedName(name);
    }

    @NotNull
    private static PsiDirectory createPackageSubdirectory(@NotNull PsiDirectory directory, @NotNull String packageName) {
        String startPackagePath;
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/androidstudio/actions/CreateClassAction", "createPackageSubdirectory"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/androidstudio/actions/CreateClassAction", "createPackageSubdirectory"));
        }
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String string = startPackagePath = psiPackage != null ? psiPackage.getQualifiedName() : null;
        if (startPackagePath == null || startPackagePath.equals(packageName)) {
            PsiDirectory psiDirectory = directory;
            if (psiDirectory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/androidstudio/actions/CreateClassAction", "createPackageSubdirectory"));
            }
            return psiDirectory;
        }
        PsiPackage baseName = JavaDirectoryService.getInstance().getPackage(directory);
        PsiDirectory dir = directory;
        if (!packageName.startsWith(baseName.getQualifiedName())) {
            while (baseName.getParentPackage() != null) {
                if (packageName.equals(baseName.getQualifiedName())) {
                    PsiDirectory psiDirectory = dir;
                    if (psiDirectory == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/androidstudio/actions/CreateClassAction", "createPackageSubdirectory"));
                    }
                    return psiDirectory;
                }
                if (packageName.startsWith(baseName.getQualifiedName())) break;
                baseName = baseName.getParentPackage();
                dir = dir.getParentDirectory();
            }
        }
        String newPackageName = baseName.getQualifiedName().isEmpty() ? packageName : packageName.substring(baseName.getQualifiedName().length() + 1);
        for (String component : Splitter.on((char)'.').split((CharSequence)newPackageName)) {
            PsiDirectory d = dir.findSubdirectory(component);
            dir = d == null ? dir.createSubdirectory(component) : d;
        }
        PsiDirectory psiDirectory = dir;
        if (psiDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/androidstudio/actions/CreateClassAction", "createPackageSubdirectory"));
        }
        return psiDirectory;
    }

    private static void showOverridesDialog(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/androidstudio/actions/CreateClassAction", "showOverridesDialog"));
        }
        Editor editor = FileEditorManager.getInstance((Project)event.getProject()).getSelectedTextEditor();
        if (editor instanceof EditorEx) {
            EditorEx editorEx = (EditorEx)editor;
            AnActionEvent newEvent = new AnActionEvent(event.getInputEvent(), editorEx.getDataContext(), "unknown", event.getPresentation(), event.getActionManager(), 0);
            ActionManager.getInstance().getAction("OverrideMethods").actionPerformed(newEvent);
        }
    }

    @Nullable
    private PsiClass checkOrCreate(String newName, PsiDirectory directory, String templateName, Map<String, String> creationOptions) throws IncorrectOperationException {
        PsiDirectory dir = directory;
        StringUtil.trimEnd((String)newName, (String)".java");
        if (newName.contains(".")) {
            List names = Splitter.on((String)".").splitToList((CharSequence)newName);
            for (String name : names.subList(0, names.size() - 1)) {
                PsiDirectory subDir = dir.findSubdirectory(name);
                if (subDir == null) {
                    subDir = dir.createSubdirectory(name);
                }
                dir = subDir;
            }
            newName = (String)names.get(names.size() - 1);
        }
        if (templateName.matches("^AS.*")) {
            String baseTemplateName = templateName.substring(2);
            FileTemplate baseTemplate = FileTemplateManager.getInstance((Project)dir.getProject()).getInternalTemplate(baseTemplateName);
            if (!baseTemplate.isDefault()) {
                templateName = baseTemplateName;
            }
        }
        return this.myJavaDirectoryService.createClass(dir, newName, templateName, true, creationOptions);
    }
}

