/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.exception.GrExceptionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyEmptyCatchBlockInspection
extends BaseInspection {
    public boolean myIgnore = true;
    public boolean myCountCommentsAsContent = true;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Error handling" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyEmptyCatchBlockInspection", "getGroupDisplayName"));
        }
        return "Error handling";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Empty 'catch' block" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyEmptyCatchBlockInspection", "getDisplayName"));
        }
        return "Empty 'catch' block";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyEmptyCatchBlockInspection", "buildVisitor"));
        }
        return visitor2;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(GroovyInspectionBundle.message("comments.count.as.content", new Object[0]), "myCountCommentsAsContent");
        panel.addCheckbox(GroovyInspectionBundle.message("ignore.when.catch.parameter.is.named.ignore.or.ignored", new Object[0]), "myIgnore");
        return panel;
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitCatchClause(@NotNull GrCatchClause catchClause) {
            LocalQuickFix[] localQuickFixArray;
            if (catchClause == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchClause", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyEmptyCatchBlockInspection$Visitor", "visitCatchClause"));
            }
            super.visitCatchClause(catchClause);
            GrOpenBlock body = catchClause.getBody();
            if (body == null || !this.isEmpty(body)) {
                return;
            }
            GrParameter parameter = catchClause.getParameter();
            if (parameter == null) {
                return;
            }
            if (GroovyEmptyCatchBlockInspection.this.myIgnore && GrExceptionUtil.ignore(parameter)) {
                return;
            }
            LocalQuickFixAndIntentionActionOnPsiElement fix = QuickFixFactory.getInstance().createRenameElementFix((PsiNamedElement)parameter, "ignored");
            if (GroovyEmptyCatchBlockInspection.this.myIgnore) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = fix;
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.registerError(catchClause.getFirstChild(), "Empty '#ref' block #loc", fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }

        private boolean isEmpty(@NotNull GrOpenBlock body) {
            PsiElement next;
            PsiElement brace;
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyEmptyCatchBlockInspection$Visitor", "isEmpty"));
            }
            GrStatement[] statements = body.getStatements();
            if (statements.length != 0) {
                return false;
            }
            return !GroovyEmptyCatchBlockInspection.this.myCountCommentsAsContent || (brace = body.getLBrace()) == null || !((next = PsiUtil.skipWhitespaces(brace.getNextSibling(), true)) instanceof PsiComment);
        }
    }
}

