/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;

public class CallInstruction
extends InstructionImpl {
    private final InstructionImpl myCallee;

    public CallInstruction(InstructionImpl callee) {
        super(null);
        this.myCallee = callee;
    }

    @Override
    public String toString() {
        return super.toString() + " CALL " + this.myCallee.num();
    }

    @Override
    @NotNull
    public Iterable<Instruction> successors(@NotNull CallEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/CallInstruction", "successors"));
        }
        environment.callStack(this.myCallee).push(this);
        List<Instruction> list = Collections.singletonList(this.myCallee);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/CallInstruction", "successors"));
        }
        return list;
    }

    @Override
    @NotNull
    public Iterable<Instruction> allSuccessors() {
        List<Instruction> list = Collections.singletonList(this.myCallee);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/CallInstruction", "allSuccessors"));
        }
        return list;
    }

    @Override
    @NotNull
    protected String getElementPresentation() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/CallInstruction", "getElementPresentation"));
        }
        return "";
    }
}

