/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public abstract class GroovyFileBaseImpl
extends PsiFileBase
implements GroovyFileBase,
GrControlFlowOwner {
    private volatile SoftReference<Instruction[]> myControlFlow;

    protected GroovyFileBaseImpl(FileViewProvider viewProvider, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "<init>"));
        }
        super(viewProvider, language);
    }

    public GroovyFileBaseImpl(IFileElementType root, IFileElementType root1, FileViewProvider provider2) {
        this(provider2, root.getLanguage());
        this.init((IElementType)root, (IElementType)root1);
    }

    @NotNull
    public FileType getFileType() {
        GroovyFileType groovyFileType = GroovyFileType.GROOVY_FILE_TYPE;
        if (groovyFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "getFileType"));
        }
        return groovyFileType;
    }

    public String toString() {
        return "Groovy script";
    }

    @Override
    @NotNull
    public GrTypeDefinition[] getTypeDefinitions() {
        StubElement stub = this.getStub();
        if (stub != null) {
            GrTypeDefinition[] grTypeDefinitionArray = (GrTypeDefinition[])stub.getChildrenByType(TokenSets.TYPE_DEFINITIONS, GrTypeDefinition.ARRAY_FACTORY);
            if (grTypeDefinitionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "getTypeDefinitions"));
            }
            return grTypeDefinitionArray;
        }
        GrTypeDefinition[] grTypeDefinitionArray = (GrTypeDefinition[])this.calcTreeElement().getChildrenAsPsiElements(TokenSets.TYPE_DEFINITIONS, GrTypeDefinition.ARRAY_FACTORY);
        if (grTypeDefinitionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "getTypeDefinitions"));
        }
        return grTypeDefinitionArray;
    }

    @Override
    @NotNull
    public GrMethod[] getMethods() {
        StubElement stub = this.getStub();
        if (stub != null) {
            GrMethod[] grMethodArray = (GrMethod[])stub.getChildrenByType((IElementType)GroovyElementTypes.METHOD_DEFINITION, GrMethod.ARRAY_FACTORY);
            if (grMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "getMethods"));
            }
            return grMethodArray;
        }
        GrMethod[] grMethodArray = (GrMethod[])this.calcTreeElement().getChildrenAsPsiElements((IElementType)GroovyElementTypes.METHOD_DEFINITION, GrMethod.ARRAY_FACTORY);
        if (grMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "getMethods"));
        }
        return grMethodArray;
    }

    @Override
    @NotNull
    public GrTopStatement[] getTopStatements() {
        GrTopStatement[] grTopStatementArray = (GrTopStatement[])this.findChildrenByClass(GrTopStatement.class);
        if (grTopStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "getTopStatements"));
        }
        return grTopStatementArray;
    }

    public boolean importClass(PsiClass aClass) {
        return this.addImportForClass(aClass) != null;
    }

    @Override
    public void removeImport(@NotNull GrImportStatement importStatement) throws IncorrectOperationException {
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "removeImport"));
        }
        GroovyCodeStyleManager.getInstance(this.getProject()).removeImport(this, importStatement);
    }

    @Override
    public void removeElements(PsiElement[] elements) throws IncorrectOperationException {
        for (PsiElement element : elements) {
            if (!element.isValid()) continue;
            if (element.getParent() != this) {
                throw new IncorrectOperationException();
            }
            this.deleteChildRange(element, element);
        }
    }

    @Override
    @NotNull
    public GrStatement[] getStatements() {
        GrStatement[] grStatementArray = (GrStatement[])this.findChildrenByClass(GrStatement.class);
        if (grStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "getStatements"));
        }
        return grStatementArray;
    }

    @Override
    @NotNull
    public GrStatement addStatementBefore(@NotNull GrStatement statement, @Nullable GrStatement anchor) throws IncorrectOperationException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "addStatementBefore"));
        }
        PsiElement result = this.addBefore(statement, anchor);
        if (anchor != null) {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor.getNode());
        } else {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", result.getNode());
        }
        GrStatement grStatement = (GrStatement)result;
        if (grStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "addStatementBefore"));
        }
        return grStatement;
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        GrStatement statement = this.addStatementBefore(declaration, anchor);
        assert (statement instanceof GrVariableDeclaration);
        return (GrVariableDeclaration)statement;
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitFile(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor2) {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(visitor2);
        }
    }

    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getTypeDefinitions();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl", "getClasses"));
        }
        return psiClassArray;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myControlFlow = null;
    }

    @Override
    public Instruction[] getControlFlow() {
        assert (this.isValid());
        Instruction[] result = (Instruction[])SoftReference.dereference(this.myControlFlow);
        if (result == null) {
            result = new ControlFlowBuilder(this.getProject()).buildControlFlow(this);
            this.myControlFlow = new SoftReference((Object)result);
        }
        return ControlFlowBuilder.assertValidPsi(result);
    }

    @Override
    public boolean isTopControlFlowOwner() {
        return false;
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        if (last instanceof GrTopStatement) {
            PsiImplUtil.deleteStatementTail(this, last);
        }
        super.deleteChildRange(first, last);
    }
}

