/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReferenceProvider;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.ManifestBuilder;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.maven.model.impl.MavenEjbClientConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenIdBean;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenWebArtifactConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;

public class MavenResourceCompilerConfigurationGenerator {
    private static Logger LOG = Logger.getInstance(MavenResourceCompilerConfigurationGenerator.class);
    private static final Pattern SIMPLE_NEGATIVE_PATTERN = Pattern.compile("!\\?(\\*\\.\\w+)");
    private static final String IDEA_MAVEN_DISABLE_MANIFEST = System.getProperty("idea.maven.disable.manifest");
    private final Project myProject;
    private final MavenProjectsManager myMavenProjectsManager;
    private final MavenProjectsTree myProjectsTree;

    public MavenResourceCompilerConfigurationGenerator(Project project, MavenProjectsTree projectsTree) {
        this.myProject = project;
        this.myMavenProjectsManager = MavenProjectsManager.getInstance(project);
        this.myProjectsTree = projectsTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBuildConfiguration(boolean force) {
        if (!this.myMavenProjectsManager.isMavenizedProject()) {
            return;
        }
        BuildManager buildManager = BuildManager.getInstance();
        File projectSystemDir = buildManager.getProjectSystemDirectory(this.myProject);
        if (projectSystemDir == null) {
            return;
        }
        File mavenConfigFile = new File(projectSystemDir, "maven/configuration.xml");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        int projectRootModificationCount = (int)projectRootManager.getModificationCount();
        int mavenConfigCrc = this.myProjectsTree.getFilterConfigCrc(fileIndex);
        int crc = mavenConfigCrc + projectRootModificationCount;
        File crcFile = new File(mavenConfigFile.getParent(), "configuration.crc");
        if (!force) {
            try (DataInputStream crcInput = new DataInputStream(new FileInputStream(crcFile));){
                int lastCrc = crcInput.readInt();
                if (lastCrc == crc) {
                    return;
                }
                LOG.debug(String.format("project configuration changed: lastCrc = %d, currentCrc = %d, projectRootModificationCount = %d, mavenConfigCrc = %d", lastCrc, crc, projectRootModificationCount, mavenConfigCrc));
            }
            catch (IOException ignored) {
                LOG.debug("Unable to read or find config file: " + ignored.getMessage());
            }
        }
        MavenProjectConfiguration projectConfig = new MavenProjectConfiguration();
        for (MavenProject mavenProject : this.myMavenProjectsManager.getProjects()) {
            String string;
            VirtualFile pomXml = mavenProject.getFile();
            Module module = fileIndex.getModuleForFile(pomXml);
            if (module == null || !Comparing.equal((Object)mavenProject.getDirectoryFile(), (Object)fileIndex.getContentRootForFile(pomXml))) continue;
            MavenModuleResourceConfiguration resourceConfig = new MavenModuleResourceConfiguration();
            MavenId projectId = mavenProject.getMavenId();
            resourceConfig.id = new MavenIdBean(projectId.getGroupId(), projectId.getArtifactId(), projectId.getVersion());
            MavenId parentId = mavenProject.getParentId();
            if (parentId != null) {
                resourceConfig.parentId = new MavenIdBean(parentId.getGroupId(), parentId.getArtifactId(), parentId.getVersion());
            }
            resourceConfig.directory = FileUtil.toSystemIndependentName((String)mavenProject.getDirectory());
            resourceConfig.delimitersPattern = MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(mavenProject).pattern();
            for (Map.Entry<String, String> entry : mavenProject.getModelMap().entrySet()) {
                String key = entry.getKey();
                String string2 = entry.getValue();
                if (string2 == null) continue;
                resourceConfig.modelMap.put(key, string2);
            }
            MavenResourceCompilerConfigurationGenerator.addEarModelMapEntries(mavenProject, resourceConfig.modelMap);
            Element pluginConfiguration = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
            resourceConfig.outputDirectory = MavenResourceCompilerConfigurationGenerator.getResourcesPluginGoalOutputDirectory(mavenProject, pluginConfiguration, "resources");
            resourceConfig.testOutputDirectory = MavenResourceCompilerConfigurationGenerator.getResourcesPluginGoalOutputDirectory(mavenProject, pluginConfiguration, "testResources");
            MavenResourceCompilerConfigurationGenerator.addResources(resourceConfig.resources, mavenProject.getResources());
            MavenResourceCompilerConfigurationGenerator.addResources(resourceConfig.testResources, mavenProject.getTestResources());
            MavenResourceCompilerConfigurationGenerator.addWebResources(module, projectConfig, mavenProject);
            MavenResourceCompilerConfigurationGenerator.addEjbClientArtifactConfiguration(module, projectConfig, mavenProject);
            resourceConfig.filteringExclusions.addAll(MavenProjectsTree.getFilterExclusions(mavenProject));
            Properties properties = this.getFilteringProperties(mavenProject);
            for (Map.Entry entry : properties.entrySet()) {
                resourceConfig.properties.put((String)entry.getKey(), (String)entry.getValue());
            }
            resourceConfig.escapeString = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "escapeString", null);
            String escapeWindowsPaths = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "escapeWindowsPaths");
            if (escapeWindowsPaths != null) {
                resourceConfig.escapeWindowsPaths = Boolean.parseBoolean(escapeWindowsPaths);
            }
            if ((string = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "overwrite")) != null) {
                resourceConfig.overwrite = Boolean.parseBoolean(string);
            }
            projectConfig.moduleConfigurations.put(module.getName(), resourceConfig);
            MavenResourceCompilerConfigurationGenerator.generateManifest(mavenProject, module, resourceConfig);
        }
        this.addNonMavenResources(projectConfig);
        Element element = new Element("maven-project-configuration");
        XmlSerializer.serializeInto((Object)projectConfig, (Element)element);
        buildManager.runCommand(() -> {
            buildManager.clearState(this.myProject);
            FileUtil.createIfDoesntExist((File)mavenConfigFile);
            try {
                JdomKt.write((Parent)element, (Path)mavenConfigFile.toPath());
                try (DataOutputStream crcOutput = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(crcFile)));){
                    crcOutput.writeInt(crc);
                }
            }
            catch (IOException e) {
                LOG.debug("Unable to write config file", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    private static void addEarModelMapEntries(@NotNull MavenProject mavenProject, @NotNull Map<String, String> modelMap) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenResourceCompilerConfigurationGenerator", "addEarModelMapEntries"));
        }
        if (modelMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMap", "org/jetbrains/idea/maven/project/MavenResourceCompilerConfigurationGenerator", "addEarModelMapEntries"));
        }
        Element pluginConfiguration = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-ear-plugin");
        String skinnyWars = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "skinnyWars", "false");
        modelMap.put("build.plugin.maven-ear-plugin.skinnyWars", skinnyWars);
    }

    @Nullable
    private static String getResourcesPluginGoalOutputDirectory(@NotNull MavenProject mavenProject, @Nullable Element pluginConfiguration, @NotNull String goal) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenResourceCompilerConfigurationGenerator", "getResourcesPluginGoalOutputDirectory"));
        }
        if (goal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "goal", "org/jetbrains/idea/maven/project/MavenResourceCompilerConfigurationGenerator", "getResourcesPluginGoalOutputDirectory"));
        }
        Element goalConfiguration = mavenProject.getPluginGoalConfiguration("org.apache.maven.plugins", "maven-resources-plugin", goal);
        String outputDirectory = MavenJDOMUtil.findChildValueByPath(goalConfiguration, "outputDirectory", null);
        if (outputDirectory == null) {
            outputDirectory = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "outputDirectory", null);
        }
        return outputDirectory == null || FileUtil.isAbsolute((String)outputDirectory) ? outputDirectory : mavenProject.getDirectory() + '/' + outputDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateManifest(@NotNull MavenProject mavenProject, @NotNull Module module, @NotNull MavenModuleResourceConfiguration resourceConfig) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenResourceCompilerConfigurationGenerator", "generateManifest"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/project/MavenResourceCompilerConfigurationGenerator", "generateManifest"));
        }
        if (resourceConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceConfig", "org/jetbrains/idea/maven/project/MavenResourceCompilerConfigurationGenerator", "generateManifest"));
        }
        if (mavenProject.isAggregator()) {
            return;
        }
        if (Boolean.valueOf(IDEA_MAVEN_DISABLE_MANIFEST).booleanValue()) {
            resourceConfig.manifest = null;
            return;
        }
        try {
            int quoteIndex;
            String jdkVersion = null;
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk != null && (jdkVersion = sdk.getVersionString()) != null && (quoteIndex = jdkVersion.indexOf(34)) != -1) {
                jdkVersion = jdkVersion.substring(quoteIndex + 1, jdkVersion.length() - 1);
            }
            Manifest manifest = new ManifestBuilder(mavenProject).withJdkVersion(jdkVersion).build();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                manifest.write(outputStream);
                MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel(module.getProject(), mavenProject.getFile());
                if (domModel != null) {
                    String resolvedText = MavenPropertyResolver.resolve(outputStream.toString("UTF-8"), domModel);
                    resourceConfig.manifest = Base64.getEncoder().encodeToString(resolvedText.getBytes(StandardCharsets.UTF_8));
                }
            }
            finally {
                StreamUtil.closeStream((Closeable)outputStream);
            }
            resourceConfig.classpath = ManifestBuilder.getClasspath(mavenProject);
        }
        catch (ManifestBuilder.ManifestBuilderException e) {
            LOG.warn("Unable to generate artifact manifest", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Unable to save generated artifact manifest", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getFilteringProperties(MavenProject mavenProject) {
        String javaVersion;
        Properties properties = new Properties();
        for (String each : mavenProject.getFilterPropertiesFiles()) {
            try (FileInputStream in = new FileInputStream(each);){
                properties.load(in);
            }
            catch (IOException iOException) {}
        }
        properties.putAll((Map<?, ?>)mavenProject.getProperties());
        properties.put("settings.localRepository", mavenProject.getLocalRepository().getAbsolutePath());
        String jreDir = MavenUtil.getModuleJreHome(this.myMavenProjectsManager, mavenProject);
        if (jreDir != null) {
            properties.put("java.home", jreDir);
        }
        if ((javaVersion = MavenUtil.getModuleJavaVersion(this.myMavenProjectsManager, mavenProject)) != null) {
            properties.put("java.version", javaVersion);
        }
        return properties;
    }

    private static void addResources(List<ResourceRootConfiguration> container, @NotNull Collection<MavenResource> resources) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "org/jetbrains/idea/maven/project/MavenResourceCompilerConfigurationGenerator", "addResources"));
        }
        for (MavenResource resource : resources) {
            String dir = resource.getDirectory();
            if (dir == null) continue;
            ResourceRootConfiguration props = new ResourceRootConfiguration();
            props.directory = FileUtil.toSystemIndependentName((String)dir);
            String target = resource.getTargetPath();
            props.targetPath = target != null ? FileUtil.toSystemIndependentName((String)target) : null;
            props.isFiltered = resource.isFiltered();
            props.includes.clear();
            for (String include : resource.getIncludes()) {
                props.includes.add(include.trim());
            }
            props.excludes.clear();
            for (String exclude : resource.getExcludes()) {
                props.excludes.add(exclude.trim());
            }
            container.add(props);
        }
    }

    private static void addWebResources(@NotNull Module module, MavenProjectConfiguration projectCfg, MavenProject mavenProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/project/MavenResourceCompilerConfigurationGenerator", "addWebResources"));
        }
        Element warCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-war-plugin");
        if (warCfg == null) {
            return;
        }
        boolean filterWebXml = Boolean.parseBoolean(warCfg.getChildTextTrim("filteringDeploymentDescriptors"));
        Element webResources = warCfg.getChild("webResources");
        if (webResources == null && !filterWebXml) {
            return;
        }
        String webArtifactName = MavenUtil.getArtifactName("war", module, true);
        MavenWebArtifactConfiguration artifactResourceCfg = (MavenWebArtifactConfiguration)projectCfg.webArtifactConfigs.get(webArtifactName);
        if (artifactResourceCfg == null) {
            artifactResourceCfg = new MavenWebArtifactConfiguration();
            artifactResourceCfg.moduleName = module.getName();
            projectCfg.webArtifactConfigs.put(webArtifactName, artifactResourceCfg);
        } else {
            LOG.error("MavenWebArtifactConfiguration already exists.");
        }
        if (webResources != null) {
            for (Element resource : webResources.getChildren("resource")) {
                Element excludes;
                ResourceRootConfiguration r = new ResourceRootConfiguration();
                String directory = resource.getChildTextTrim("directory");
                if (StringUtil.isEmptyOrSpaces((String)directory)) continue;
                if (!FileUtil.isAbsolute((String)directory)) {
                    directory = mavenProject.getDirectory() + '/' + directory;
                }
                r.directory = directory;
                r.isFiltered = Boolean.parseBoolean(resource.getChildTextTrim("filtering"));
                r.targetPath = resource.getChildTextTrim("targetPath");
                Element includes = resource.getChild("includes");
                if (includes != null) {
                    for (Element include : includes.getChildren("include")) {
                        String includeText = include.getTextTrim();
                        if (includeText.isEmpty()) continue;
                        r.includes.add(includeText);
                    }
                }
                if ((excludes = resource.getChild("excludes")) != null) {
                    for (Element exclude : excludes.getChildren("exclude")) {
                        String excludeText = exclude.getTextTrim();
                        if (excludeText.isEmpty()) continue;
                        r.excludes.add(excludeText);
                    }
                }
                artifactResourceCfg.webResources.add(r);
            }
        }
        if (filterWebXml) {
            ResourceRootConfiguration r = new ResourceRootConfiguration();
            r.directory = mavenProject.getDirectory() + "/src/main/webapp";
            r.includes = Collections.singleton("WEB-INF/web.xml");
            r.isFiltered = true;
            r.targetPath = "";
            artifactResourceCfg.webResources.add(r);
        }
    }

    private static void addEjbClientArtifactConfiguration(Module module, MavenProjectConfiguration projectCfg, MavenProject mavenProject) {
        Element excludes;
        Element pluginCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-ejb-plugin");
        if (pluginCfg == null || !Boolean.parseBoolean(pluginCfg.getChildTextTrim("generateClient"))) {
            return;
        }
        MavenEjbClientConfiguration ejbClientCfg = new MavenEjbClientConfiguration();
        Element includes = pluginCfg.getChild("clientIncludes");
        if (includes != null) {
            for (Element include : includes.getChildren("clientInclude")) {
                String includeText = include.getTextTrim();
                if (includeText.isEmpty()) continue;
                ejbClientCfg.includes.add(includeText);
            }
        }
        if ((excludes = pluginCfg.getChild("clientExcludes")) != null) {
            for (Element exclude : excludes.getChildren("clientExclude")) {
                String excludeText = exclude.getTextTrim();
                if (excludeText.isEmpty()) continue;
                ejbClientCfg.excludes.add(excludeText);
            }
        }
        if (!ejbClientCfg.isEmpty()) {
            projectCfg.ejbClientArtifactConfigs.put(MavenUtil.getEjbClientArtifactName(module, true), ejbClientCfg);
        }
    }

    private void addNonMavenResources(MavenProjectConfiguration projectCfg) {
        HashSet<VirtualFile> processedRoots = new HashSet<VirtualFile>();
        for (MavenProject project : this.myMavenProjectsManager.getProjects()) {
            VirtualFile file;
            for (String dir : ContainerUtil.concat(project.getSources(), project.getTestSources())) {
                file = LocalFileSystem.getInstance().findFileByPath(dir);
                if (file == null) continue;
                processedRoots.add(file);
            }
            for (MavenResource resource : ContainerUtil.concat(project.getResources(), project.getTestResources())) {
                file = LocalFileSystem.getInstance().findFileByPath(resource.getDirectory());
                if (file == null) continue;
                processedRoots.add(file);
            }
        }
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)this.myProject);
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!this.myMavenProjectsManager.isMavenizedModule(module)) continue;
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                for (SourceFolder folder : contentEntry.getSourceFolders()) {
                    MavenModuleResourceConfiguration configuration;
                    VirtualFile file = folder.getFile();
                    if (file == null || compilerConfiguration.isExcludedFromCompilation(file) || MavenResourceCompilerConfigurationGenerator.isUnderRoots(processedRoots, file) || (configuration = (MavenModuleResourceConfiguration)projectCfg.moduleConfigurations.get(module.getName())) == null) continue;
                    List resourcesList = folder.isTestSource() ? configuration.testResources : configuration.resources;
                    ResourceRootConfiguration cfg = new ResourceRootConfiguration();
                    cfg.directory = FileUtil.toSystemIndependentName((String)FileUtil.toSystemIndependentName((String)file.getPath()));
                    CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
                    if (compilerModuleExtension == null) continue;
                    String compilerOutputUrl = folder.isTestSource() ? compilerModuleExtension.getCompilerOutputUrlForTests() : compilerModuleExtension.getCompilerOutputUrl();
                    cfg.targetPath = VfsUtilCore.urlToPath((String)compilerOutputUrl);
                    MavenResourceCompilerConfigurationGenerator.convertIdeaExcludesToMavenExcludes(cfg, (CompilerConfigurationImpl)compilerConfiguration);
                    resourcesList.add(cfg);
                }
            }
        }
    }

    private static void convertIdeaExcludesToMavenExcludes(ResourceRootConfiguration cfg, CompilerConfigurationImpl compilerConfiguration) {
        for (String pattern : compilerConfiguration.getResourceFilePatterns()) {
            Matcher matcher = SIMPLE_NEGATIVE_PATTERN.matcher(pattern);
            if (!matcher.matches()) continue;
            cfg.excludes.add("**/" + matcher.group(1));
        }
    }

    private static boolean isUnderRoots(Set<VirtualFile> roots, VirtualFile file) {
        for (VirtualFile f = file; f != null; f = f.getParent()) {
            if (!roots.contains(file)) continue;
            return true;
        }
        return false;
    }
}

