/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsListener;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.messages.Topic;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalAnnotationsManager {
    public static final String ANNOTATIONS_XML = "annotations.xml";
    public static final Topic<ExternalAnnotationsListener> TOPIC = Topic.create((String)"external annotations", ExternalAnnotationsListener.class);
    private static final NotNullLazyKey<ExternalAnnotationsManager, Project> INSTANCE_KEY = ServiceManager.createLazyKey(ExternalAnnotationsManager.class);

    public static ExternalAnnotationsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/ExternalAnnotationsManager", "getInstance"));
        }
        return (ExternalAnnotationsManager)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    public abstract boolean isExternalAnnotation(@NotNull PsiAnnotation var1);

    @Nullable
    public abstract PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner var1, @NotNull String var2);

    public abstract boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner var1, @NotNull String var2);

    @Nullable
    public abstract PsiAnnotation[] findExternalAnnotations(@NotNull PsiModifierListOwner var1);

    public abstract void annotateExternally(@NotNull PsiModifierListOwner var1, @NotNull String var2, @NotNull PsiFile var3, @Nullable PsiNameValuePair[] var4) throws CanceledConfigurationException;

    public abstract boolean deannotate(@NotNull PsiModifierListOwner var1, @NotNull String var2);

    public abstract boolean editExternalAnnotation(@NotNull PsiModifierListOwner var1, @NotNull String var2, @Nullable PsiNameValuePair[] var3);

    public abstract AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement var1);

    @Nullable
    public abstract List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner var1);

    public static class CanceledConfigurationException
    extends RuntimeException {
        public static final CanceledConfigurationException INSTANCE = new CanceledConfigurationException();

        private CanceledConfigurationException() {
        }
    }

    public static enum AnnotationPlace {
        IN_CODE,
        EXTERNAL,
        NOWHERE;

    }
}

