/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.containers.Queue;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeToolState {
    private static final Logger LOG = Logger.getInstance((String)("#" + ScopeToolState.class.getName()));
    @NotNull
    private final String myScopeName;
    private NamedScope myScope;
    private InspectionToolWrapper myToolWrapper;
    private boolean myEnabled;
    private HighlightDisplayLevel myLevel;
    private ConfigPanelState myAdditionalConfigPanelState;

    public ScopeToolState(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        this(scope.getName(), toolWrapper, enabled, level);
        this.myScope = scope;
    }

    public ScopeToolState(@NotNull String scopeName, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        this.myScopeName = scopeName;
        this.myToolWrapper = toolWrapper;
        this.myEnabled = enabled;
        this.myLevel = level;
    }

    @NotNull
    public ScopeToolState copy() {
        ScopeToolState scopeToolState = new ScopeToolState(this.myScopeName, this.myToolWrapper, this.myEnabled, this.myLevel);
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ScopeToolState", "copy"));
        }
        return scopeToolState;
    }

    @Nullable
    public NamedScope getScope(@Nullable Project project) {
        if (this.myScope == null && project != null) {
            this.myScope = NamedScopesHolder.getScope(project, this.myScopeName);
        }
        return this.myScope;
    }

    @NotNull
    public String getScopeName() {
        String string = this.myScopeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ScopeToolState", "getScopeName"));
        }
        return string;
    }

    @NotNull
    public InspectionToolWrapper getTool() {
        InspectionToolWrapper inspectionToolWrapper = this.myToolWrapper;
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ScopeToolState", "getTool"));
        }
        return inspectionToolWrapper;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    @NotNull
    public HighlightDisplayLevel getLevel() {
        HighlightDisplayLevel highlightDisplayLevel = this.myLevel;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ScopeToolState", "getLevel"));
        }
        return highlightDisplayLevel;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void setLevel(@NotNull HighlightDisplayLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/ScopeToolState", "setLevel"));
        }
        this.myLevel = level;
    }

    @Nullable
    public JComponent getAdditionalConfigPanel() {
        if (this.myAdditionalConfigPanelState == null) {
            this.myAdditionalConfigPanelState = ConfigPanelState.of(((InspectionProfileEntry)this.myToolWrapper.getTool()).createOptionsPanel());
        }
        return this.myAdditionalConfigPanelState.getPanel(this.isEnabled());
    }

    public void resetConfigPanel() {
        this.myAdditionalConfigPanelState = null;
    }

    public void setTool(@NotNull InspectionToolWrapper tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/ScopeToolState", "setTool"));
        }
        this.myToolWrapper = tool;
    }

    public boolean equalTo(@NotNull ScopeToolState state2) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state2", "com/intellij/codeInspection/ex/ScopeToolState", "equalTo"));
        }
        if (this.isEnabled() != state2.isEnabled()) {
            return false;
        }
        if (this.getLevel() != state2.getLevel()) {
            return false;
        }
        InspectionToolWrapper toolWrapper = this.getTool();
        InspectionToolWrapper toolWrapper2 = state2.getTool();
        if (!toolWrapper.isInitialized() && !toolWrapper2.isInitialized()) {
            return true;
        }
        try {
            String tempRoot = "root";
            Element oldToolSettings = new Element(tempRoot);
            ((InspectionProfileEntry)toolWrapper.getTool()).writeSettings(oldToolSettings);
            Element newToolSettings = new Element(tempRoot);
            ((InspectionProfileEntry)toolWrapper2.getTool()).writeSettings(newToolSettings);
            return JDOMUtil.areElementsEqual((Element)oldToolSettings, (Element)newToolSettings);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public void scopesChanged() {
        this.myScope = null;
    }

    private static class ConfigPanelState {
        private static ConfigPanelState EMPTY = new ConfigPanelState(null);
        private final JComponent myOptionsPanel;
        private final Set<Component> myEnableRequiredComponent = new HashSet<Component>();
        private boolean myLastState = true;
        private boolean myDeafListeners;

        private ConfigPanelState(JComponent optionsPanel) {
            this.myOptionsPanel = optionsPanel;
            if (this.myOptionsPanel != null) {
                Queue q = new Queue(1);
                q.addLast((Object)optionsPanel);
                while (!q.isEmpty()) {
                    final Component current = (Component)q.pullFirst();
                    current.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (!myDeafListeners) {
                                boolean newValue = (Boolean)evt.getNewValue();
                                if (newValue) {
                                    myEnableRequiredComponent.add(current);
                                } else {
                                    LOG.assertTrue(myEnableRequiredComponent.remove(current));
                                }
                            }
                        }
                    });
                    if (current.isEnabled()) {
                        this.myEnableRequiredComponent.add(current);
                    }
                    if (!(current instanceof Container)) continue;
                    for (Component child : ((Container)current).getComponents()) {
                        q.addLast((Object)child);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JComponent getPanel(boolean currentState) {
            if (this.myOptionsPanel != null && this.myLastState != currentState) {
                this.myDeafListeners = true;
                try {
                    for (Component c : this.myEnableRequiredComponent) {
                        c.setEnabled(currentState);
                    }
                    this.myLastState = currentState;
                }
                finally {
                    this.myDeafListeners = false;
                }
            }
            return this.myOptionsPanel;
        }

        private static ConfigPanelState of(JComponent panel) {
            return panel == null ? EMPTY : new ConfigPanelState(panel);
        }
    }
}

