/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class RunProfileStarter {
    @Nullable
    public abstract RunContentDescriptor execute(@NotNull RunProfileState var1, @NotNull ExecutionEnvironment var2) throws ExecutionException;

    public Promise<RunContentDescriptor> executeAsync(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/RunProfileStarter", "executeAsync"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/RunProfileStarter", "executeAsync"));
        }
        try {
            RunContentDescriptor result = this.execute(state, environment);
            return Promise.resolve(result);
        }
        catch (ExecutionException e) {
            return Promises.rejectedPromise(e);
        }
    }
}

