/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunConfigurationProducerService;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ConfigurationFromContextImpl;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationProducer<T extends RunConfiguration> {
    public static final ExtensionPointName<RunConfigurationProducer> EP_NAME = ExtensionPointName.create((String)"com.intellij.runConfigurationProducer");
    private static final Logger LOG = Logger.getInstance((String)("#" + RunConfigurationProducer.class.getName()));
    private final ConfigurationFactory myConfigurationFactory;

    @NotNull
    public static List<RunConfigurationProducer<?>> getProducers(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/RunConfigurationProducer", "getProducers"));
        }
        RunConfigurationProducerService runConfigurationProducerService = RunConfigurationProducerService.getInstance(project);
        RunConfigurationProducer[] allProducers = (RunConfigurationProducer[])Extensions.getExtensions(EP_NAME);
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)allProducers.length);
        for (RunConfigurationProducer producer : allProducers) {
            if (runConfigurationProducerService.isIgnored(producer)) continue;
            result.add(producer);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/RunConfigurationProducer", "getProducers"));
        }
        return arrayList;
    }

    protected RunConfigurationProducer(ConfigurationFactory configurationFactory) {
        this.myConfigurationFactory = configurationFactory;
    }

    protected RunConfigurationProducer(ConfigurationType configurationType) {
        this.myConfigurationFactory = configurationType.getConfigurationFactories()[0];
    }

    public ConfigurationFactory getConfigurationFactory() {
        return this.myConfigurationFactory;
    }

    public ConfigurationType getConfigurationType() {
        return this.myConfigurationFactory.getType();
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(ConfigurationContext context) {
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context);
        Ref ref = new Ref((Object)context.getPsiLocation());
        try {
            if (!this.setupConfigurationFromContext(settings.getConfiguration(), context, (Ref<PsiElement>)ref)) {
                return null;
            }
        }
        catch (ClassCastException e) {
            LOG.error(this.myConfigurationFactory + " produced wrong type", (Throwable)e);
            return null;
        }
        return new ConfigurationFromContextImpl(this, settings, (PsiElement)ref.get());
    }

    protected abstract boolean setupConfigurationFromContext(T var1, ConfigurationContext var2, Ref<PsiElement> var3);

    public abstract boolean isConfigurationFromContext(T var1, ConfigurationContext var2);

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return true;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "self", "com/intellij/execution/actions/RunConfigurationProducer", "shouldReplace"));
        }
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/execution/actions/RunConfigurationProducer", "shouldReplace"));
        }
        return false;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/actions/RunConfigurationProducer", "onFirstRun"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/actions/RunConfigurationProducer", "onFirstRun"));
        }
        if (startRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startRunnable", "com/intellij/execution/actions/RunConfigurationProducer", "onFirstRun"));
        }
        startRunnable.run();
    }

    @Nullable
    public ConfigurationFromContext findOrCreateConfigurationFromContext(ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        ConfigurationFromContext fromContext = this.createConfigurationFromContext(context);
        if (fromContext == null) {
            return null;
        }
        PsiElement psiElement = fromContext.getSourceElement();
        Location<PsiElement> _location = PsiLocation.fromPsiElement(psiElement, location.getModule());
        if (_location != null) {
            RunnerAndConfigurationSettings settings = this.findExistingConfiguration(context);
            if (settings == null) {
                RunManager.getInstance(context.getProject()).setUniqueNameIfNeed(fromContext.getConfiguration());
            } else {
                fromContext.setConfigurationSettings(settings);
            }
        }
        return fromContext;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(ConfigurationContext context) {
        RunManager runManager = RunManager.getInstance(context.getProject());
        List<RunnerAndConfigurationSettings> configurations = this.getConfigurationSettingsList(runManager);
        for (RunnerAndConfigurationSettings configurationSettings : configurations) {
            if (!this.isConfigurationFromContext(configurationSettings.getConfiguration(), context)) continue;
            return configurationSettings;
        }
        return null;
    }

    @NotNull
    protected List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull RunManager runManager) {
        if (runManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runManager", "com/intellij/execution/actions/RunConfigurationProducer", "getConfigurationSettingsList"));
        }
        List<RunnerAndConfigurationSettings> list = runManager.getConfigurationSettingsList(this.myConfigurationFactory.getType());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/RunConfigurationProducer", "getConfigurationSettingsList"));
        }
        return list;
    }

    protected RunnerAndConfigurationSettings cloneTemplateConfiguration(@NotNull ConfigurationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/actions/RunConfigurationProducer", "cloneTemplateConfiguration"));
        }
        return RunConfigurationProducer.cloneTemplateConfigurationStatic(context, this.myConfigurationFactory);
    }

    @NotNull
    protected static RunnerAndConfigurationSettings cloneTemplateConfigurationStatic(@NotNull ConfigurationContext context, @NotNull ConfigurationFactory configurationFactory) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/actions/RunConfigurationProducer", "cloneTemplateConfigurationStatic"));
        }
        if (configurationFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFactory", "com/intellij/execution/actions/RunConfigurationProducer", "cloneTemplateConfigurationStatic"));
        }
        RunConfiguration original = context.getOriginalConfiguration(configurationFactory.getType());
        if (original != null) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance(context.getProject()).createConfiguration(original.clone(), configurationFactory);
            if (runnerAndConfigurationSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/RunConfigurationProducer", "cloneTemplateConfigurationStatic"));
            }
            return runnerAndConfigurationSettings;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance(context.getProject()).createRunConfiguration("", configurationFactory);
        if (runnerAndConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/RunConfigurationProducer", "cloneTemplateConfigurationStatic"));
        }
        return runnerAndConfigurationSettings;
    }

    @NotNull
    public static <T extends RunConfigurationProducer> T getInstance(Class<? extends T> aClass) {
        for (RunConfigurationProducer producer : (RunConfigurationProducer[])Extensions.getExtensions(EP_NAME)) {
            if (!aClass.isInstance(producer)) continue;
            RunConfigurationProducer runConfigurationProducer = producer;
            if (runConfigurationProducer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/RunConfigurationProducer", "getInstance"));
            }
            return (T)runConfigurationProducer;
        }
        assert (false) : aClass;
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/RunConfigurationProducer", "getInstance"));
        }
        return null;
    }

    @Nullable
    public RunConfiguration createLightConfiguration(@NotNull ConfigurationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/actions/RunConfigurationProducer", "createLightConfiguration"));
        }
        RunConfiguration configuration = this.myConfigurationFactory.createTemplateConfiguration(context.getProject());
        Ref ref = new Ref((Object)context.getPsiLocation());
        try {
            if (!this.setupConfigurationFromContext(configuration, context, (Ref<PsiElement>)ref)) {
                return null;
            }
        }
        catch (ClassCastException e) {
            LOG.error(this.myConfigurationFactory + " produced wrong type", (Throwable)e);
            return null;
        }
        return configuration;
    }
}

