/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.util.Comparing;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalProjectSettings
implements Comparable<ExternalProjectSettings>,
Cloneable {
    private String myExternalProjectPath;
    @Nullable
    private Set<String> myModules = new HashSet<String>();
    private boolean myUseAutoImport;
    private boolean myCreateEmptyContentRootDirectories;

    @NotNull
    public Set<String> getModules() {
        Set<Object> set = this.myModules == null ? Collections.emptySet() : this.myModules;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/settings/ExternalProjectSettings", "getModules"));
        }
        return set;
    }

    public void setModules(@Nullable Set<String> modules) {
        this.myModules = modules;
    }

    public String getExternalProjectPath() {
        return this.myExternalProjectPath;
    }

    public void setExternalProjectPath(@NotNull String externalProjectPath) {
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/settings/ExternalProjectSettings", "setExternalProjectPath"));
        }
        this.myExternalProjectPath = externalProjectPath;
    }

    public boolean isUseAutoImport() {
        return this.myUseAutoImport;
    }

    public void setUseAutoImport(boolean useAutoImport) {
        this.myUseAutoImport = useAutoImport;
    }

    public boolean isCreateEmptyContentRootDirectories() {
        return this.myCreateEmptyContentRootDirectories;
    }

    public void setCreateEmptyContentRootDirectories(boolean createEmptyContentRootDirectories) {
        this.myCreateEmptyContentRootDirectories = createEmptyContentRootDirectories;
    }

    @Override
    public int compareTo(@NotNull ExternalProjectSettings that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/openapi/externalSystem/settings/ExternalProjectSettings", "compareTo"));
        }
        return Comparing.compare((Comparable)((Object)this.myExternalProjectPath), (Comparable)((Object)that.myExternalProjectPath));
    }

    public int hashCode() {
        return this.myExternalProjectPath != null ? this.myExternalProjectPath.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalProjectSettings that = (ExternalProjectSettings)o;
        return this.myExternalProjectPath == null ? that.myExternalProjectPath == null : this.myExternalProjectPath.equals(that.myExternalProjectPath);
    }

    public String toString() {
        return this.myExternalProjectPath;
    }

    @NotNull
    public abstract ExternalProjectSettings clone();

    protected void copyTo(@NotNull ExternalProjectSettings receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "com/intellij/openapi/externalSystem/settings/ExternalProjectSettings", "copyTo"));
        }
        receiver.myExternalProjectPath = this.myExternalProjectPath;
        receiver.myModules = this.myModules != null ? new HashSet<String>(this.myModules) : new HashSet();
        receiver.myUseAutoImport = this.myUseAutoImport;
        receiver.myCreateEmptyContentRootDirectories = this.myCreateEmptyContentRootDirectories;
    }
}

