/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.actions.BackgroundTaskGroup;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.BranchMerger;
import org.jetbrains.idea.svn.integrate.ChangeListsMergerFactory;
import org.jetbrains.idea.svn.integrate.LocalChangesPromptTask;
import org.jetbrains.idea.svn.integrate.LookForBranchOriginTask;
import org.jetbrains.idea.svn.integrate.MergeCalculatorTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.MergeTask;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SelectMergeItemsResult;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesTask;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;

public class QuickMerge
extends BackgroundTaskGroup {
    private static final Logger LOG = Logger.getInstance(QuickMerge.class);
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final QuickMergeInteraction myInteraction;
    @NotNull
    private final Semaphore mySemaphore;

    public QuickMerge(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/QuickMerge", "<init>"));
        }
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/QuickMerge", "<init>"));
        }
        super(mergeContext.getProject(), mergeContext.getTitle());
        this.mySemaphore = new Semaphore();
        this.myMergeContext = mergeContext;
        this.myInteraction = interaction;
    }

    @NotNull
    public MergeContext getMergeContext() {
        MergeContext mergeContext = this.myMergeContext;
        if (mergeContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMerge", "getMergeContext"));
        }
        return mergeContext;
    }

    @NotNull
    public QuickMergeInteraction getInteraction() {
        QuickMergeInteraction quickMergeInteraction = this.myInteraction;
        if (quickMergeInteraction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMerge", "getInteraction"));
        }
        return quickMergeInteraction;
    }

    public void showErrors() {
        if (!this.myExceptions.isEmpty()) {
            this.myInteraction.showErrors(this.myMergeContext.getTitle(), this.myExceptions);
        }
    }

    public void waitForTasksToFinish() {
        super.waitForTasksToFinish();
        this.mySemaphore.waitFor();
    }

    public void end() {
        super.end();
        this.mySemaphore.up();
    }

    public void end(@NotNull String message, boolean isError) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/integrate/QuickMerge", "end"));
        }
        LOG.info((isError ? "Error: " : "Info: ") + message);
        this.clear();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/integrate/QuickMerge", "lambda$end$0"));
            }
            this.myInteraction.showErrors(message, isError);
        });
    }

    public boolean is18() {
        return this.myMergeContext.getWcInfo().getFormat().isOrGreater(WorkingCopyFormat.ONE_DOT_EIGHT);
    }

    public void execute() {
        FileDocumentManager.getInstance().saveAllDocuments();
        this.mySemaphore.down();
        this.runInEdt(() -> {
            if (QuickMerge.areInSameHierarchy(SvnUtil.createUrl(this.myMergeContext.getSourceUrl()), this.myMergeContext.getWcInfo().getUrl())) {
                this.end("Cannot merge from self", true);
            } else if (!this.hasSwitchedRoots() || this.myInteraction.shouldContinueSwitchedRootFound()) {
                this.runInBackground("Checking repository capabilities", indicator -> {
                    if (this.supportsMergeInfo()) {
                        this.runInEdt(this::selectMergeVariant);
                    } else {
                        this.mergeAll(false);
                    }
                });
            }
        });
    }

    private void selectMergeVariant() {
        switch (this.myInteraction.selectMergeVariant()) {
            case all: {
                this.mergeAll(true);
                break;
            }
            case showLatest: {
                this.runInBackground("Loading recent " + this.myMergeContext.getBranchName() + " revisions", new MergeCalculatorTask(this, null, (Consumer<MergeCalculatorTask>)((Consumer)task -> this.runInEdt(() -> this.selectRevisionsToMerge((MergeCalculatorTask)task, false)))));
                break;
            }
            case select: {
                this.runInBackground("Looking for branch origin", new LookForBranchOriginTask(this, false, (Consumer<SvnBranchPointsCalculator.WrapperInvertor>)((Consumer)copyPoint -> this.runInBackground("Filtering " + this.myMergeContext.getBranchName() + " revisions", new MergeCalculatorTask(this, (SvnBranchPointsCalculator.WrapperInvertor)copyPoint, (Consumer<MergeCalculatorTask>)((Consumer)task -> this.runInEdt(() -> this.selectRevisionsToMerge((MergeCalculatorTask)task, true))))))));
            }
        }
    }

    private void selectRevisionsToMerge(@NotNull MergeCalculatorTask task, boolean allStatusesCalculated) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/idea/svn/integrate/QuickMerge", "selectRevisionsToMerge"));
        }
        SelectMergeItemsResult result = this.myInteraction.selectMergeItems(task.getChangeLists(), task.getMergeChecker(), allStatusesCalculated, task.areAllListsLoaded());
        switch (result.getResultCode()) {
            case all: {
                this.mergeAll(true);
                break;
            }
            case showLatest: 
            case select: {
                this.merge(result.getSelectedLists());
                break;
            }
        }
    }

    private void mergeAll(boolean supportsMergeInfo) {
        if (supportsMergeInfo && this.is18()) {
            this.runInEdt(() -> this.checkReintegrateIsAllowedAndMergeAll(null, true));
        } else {
            this.runInBackground("Looking for branch origin", new LookForBranchOriginTask(this, true, (Consumer<SvnBranchPointsCalculator.WrapperInvertor>)((Consumer)copyPoint -> this.runInEdt(() -> this.checkReintegrateIsAllowedAndMergeAll((SvnBranchPointsCalculator.WrapperInvertor)copyPoint, supportsMergeInfo)))));
        }
    }

    private void checkReintegrateIsAllowedAndMergeAll(@Nullable SvnBranchPointsCalculator.WrapperInvertor copyPoint, boolean supportsMergeInfo) {
        boolean reintegrate;
        boolean bl = reintegrate = copyPoint != null && copyPoint.isInvertedSense();
        if (!reintegrate || this.myInteraction.shouldReintegrate(copyPoint.inverted().getTarget())) {
            MergerFactory mergerFactory = this.createMergeAllFactory(reintegrate, copyPoint, supportsMergeInfo);
            String title = "Merging all from " + this.myMergeContext.getBranchName() + (reintegrate ? " (reintegrate)" : "");
            this.merge(title, mergerFactory, null);
        }
    }

    private void merge(@NotNull List<SvnChangeList> changeLists) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/QuickMerge", "merge"));
        }
        if (!changeLists.isEmpty()) {
            ChangeListsMergerFactory mergerFactory = new ChangeListsMergerFactory(changeLists, false, false, true);
            this.merge(this.myMergeContext.getTitle(), mergerFactory, changeLists);
        }
    }

    private void merge(@NotNull String title, @NotNull MergerFactory mergerFactory, @Nullable List<SvnChangeList> changeLists) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/idea/svn/integrate/QuickMerge", "merge"));
        }
        if (mergerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergerFactory", "org/jetbrains/idea/svn/integrate/QuickMerge", "merge"));
        }
        this.runInEdt(new LocalChangesPromptTask(this, changeLists, () -> {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/idea/svn/integrate/QuickMerge", "lambda$merge$12"));
            }
            if (mergerFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergerFactory", "org/jetbrains/idea/svn/integrate/QuickMerge", "lambda$merge$12"));
            }
            this.runInEdt(new MergeTask(this, () -> {
                if (title == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/idea/svn/integrate/QuickMerge", "lambda$null$11"));
                }
                if (mergerFactory == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergerFactory", "org/jetbrains/idea/svn/integrate/QuickMerge", "lambda$null$11"));
                }
                this.newIntegrateTask(title, mergerFactory).queue();
            }));
        }));
    }

    @NotNull
    private Task newIntegrateTask(@NotNull String title, @NotNull MergerFactory mergerFactory) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/idea/svn/integrate/QuickMerge", "newIntegrateTask"));
        }
        if (mergerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergerFactory", "org/jetbrains/idea/svn/integrate/QuickMerge", "newIntegrateTask"));
        }
        SvnIntegrateChangesTask svnIntegrateChangesTask = new SvnIntegrateChangesTask(this.myMergeContext.getVcs(), new WorkingCopyInfo(this.myMergeContext.getWcInfo().getPath(), true), mergerFactory, SvnUtil.parseUrl(this.myMergeContext.getSourceUrl()), title, false, this.myMergeContext.getBranchName()){

            public void onFinished() {
                super.onFinished();
                QuickMerge.this.mySemaphore.up();
            }
        };
        if (svnIntegrateChangesTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMerge", "newIntegrateTask"));
        }
        return svnIntegrateChangesTask;
    }

    private boolean hasSwitchedRoots() {
        File currentRoot = this.myMergeContext.getWcInfo().getRootInfo().getIoFile();
        return this.myMergeContext.getVcs().getAllWcInfos().stream().filter(info -> NestedCopyType.switched.equals((Object)info.getType())).anyMatch(info -> FileUtil.isAncestor((File)currentRoot, (File)info.getRootInfo().getIoFile(), (boolean)true));
    }

    private boolean supportsMergeInfo() {
        return this.myMergeContext.getWcInfo().getFormat().supportsMergeInfo() && SvnUtil.checkRepositoryVersion15(this.myMergeContext.getVcs(), this.myMergeContext.getSourceUrl());
    }

    @NotNull
    private MergerFactory createMergeAllFactory(boolean reintegrate, @Nullable SvnBranchPointsCalculator.WrapperInvertor copyPoint, boolean supportsMergeInfo) {
        long revision = copyPoint != null ? (reintegrate ? copyPoint.getWrapped().getTargetRevision() : copyPoint.getWrapped().getSourceRevision()) : -1L;
        MergerFactory mergerFactory = (vcs, target, handler, currentBranchUrl, branchName) -> new BranchMerger(vcs, currentBranchUrl, this.myMergeContext.getWcInfo().getPath(), handler, reintegrate, this.myMergeContext.getBranchName(), revision, supportsMergeInfo);
        if (mergerFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/QuickMerge", "createMergeAllFactory"));
        }
        return mergerFactory;
    }

    private static boolean areInSameHierarchy(@NotNull SVNURL url1, @NotNull SVNURL url2) {
        if (url1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url1", "org/jetbrains/idea/svn/integrate/QuickMerge", "areInSameHierarchy"));
        }
        if (url2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url2", "org/jetbrains/idea/svn/integrate/QuickMerge", "areInSameHierarchy"));
        }
        return SVNURLUtil.isAncestor((SVNURL)url1, (SVNURL)url2) || SVNURLUtil.isAncestor((SVNURL)url2, (SVNURL)url1);
    }
}

