/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.project.autoimport.CachingExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import icons.GradleIcons;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.GradleAutoImportAware;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.settings.GradleConfigurable;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.ClassHolder;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleManager
implements ExternalSystemConfigurableAware,
ExternalSystemUiAware,
ExternalSystemAutoImportAware,
StartupActivity,
ExternalSystemManager<GradleProjectSettings, GradleSettingsListener, GradleSettings, GradleLocalSettings, GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance((String)("#" + GradleManager.class.getName()));
    @NotNull
    private final ExternalSystemAutoImportAware myAutoImportDelegate;
    @NotNull
    private final GradleInstallationManager myInstallationManager;
    @NotNull
    private static final NotNullLazyValue<List<GradleProjectResolverExtension>> RESOLVER_EXTENSIONS = new AtomicNotNullLazyValue<List<GradleProjectResolverExtension>>(){

        @NotNull
        protected List<GradleProjectResolverExtension> compute() {
            ArrayList result = ContainerUtilRt.newArrayList();
            Collections.addAll(result, GradleProjectResolverExtension.EP_NAME.getExtensions());
            ExternalSystemApiUtil.orderAwareSort((List)result);
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager$1", "compute"));
            }
            return arrayList;
        }
    };

    public GradleManager(@NotNull GradleInstallationManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/plugins/gradle/GradleManager", "<init>"));
        }
        this.myAutoImportDelegate = new CachingExternalSystemAutoImportAware((ExternalSystemAutoImportAware)new GradleAutoImportAware());
        this.myInstallationManager = manager;
    }

    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager", "getSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public Function<Project, GradleSettings> getSettingsProvider() {
        Function function = project -> GradleSettings.getInstance(project);
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager", "getSettingsProvider"));
        }
        return function;
    }

    @NotNull
    public Function<Project, GradleLocalSettings> getLocalSettingsProvider() {
        Function function = project -> GradleLocalSettings.getInstance(project);
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager", "getLocalSettingsProvider"));
        }
        return function;
    }

    @NotNull
    public Function<Pair<Project, String>, GradleExecutionSettings> getExecutionSettingsProvider() {
        Function function = pair -> {
            String javaHome;
            GradleProjectSettings projectLevelSettings;
            Project project = (Project)pair.first;
            GradleSettings settings = GradleSettings.getInstance(project);
            File gradleHome = this.myInstallationManager.getGradleHome(project, (String)pair.second);
            String localGradlePath = null;
            if (gradleHome != null) {
                try {
                    localGradlePath = gradleHome.getCanonicalPath();
                }
                catch (IOException e) {
                    localGradlePath = gradleHome.getAbsolutePath();
                }
            }
            DistributionType distributionType = (projectLevelSettings = (GradleProjectSettings)settings.getLinkedProjectSettings((String)pair.second)) == null ? (GradleUtil.isGradleDefaultWrapperFilesExist((String)pair.second) ? DistributionType.DEFAULT_WRAPPED : DistributionType.LOCAL) : (projectLevelSettings.getDistributionType() == null ? DistributionType.LOCAL : projectLevelSettings.getDistributionType());
            GradleExecutionSettings result = new GradleExecutionSettings(localGradlePath, settings.getServiceDirectoryPath(), distributionType, settings.getGradleVmOptions(), settings.isOfflineWork());
            for (GradleProjectResolverExtension extension : (List)RESOLVER_EXTENSIONS.getValue()) {
                result.addResolverExtensionClass(ClassHolder.from(extension.getClass()));
            }
            String rootProjectPath = projectLevelSettings != null ? projectLevelSettings.getExternalProjectPath() : (String)pair.second;
            Sdk gradleJdk = this.myInstallationManager.getGradleJdk(project, rootProjectPath);
            String string = javaHome = gradleJdk != null ? gradleJdk.getHomePath() : null;
            if (!StringUtil.isEmpty((String)javaHome)) {
                LOG.info("Instructing gradle to use java from " + javaHome);
            }
            result.setJavaHome(javaHome);
            String ideProjectPath = project.getBasePath() == null || project.getProjectFilePath() != null && StringUtil.endsWith((CharSequence)project.getProjectFilePath(), (CharSequence)".ipr") ? rootProjectPath : project.getBasePath() + "/.idea/modules";
            result.setIdeProjectPath(ideProjectPath);
            if (projectLevelSettings != null) {
                result.setResolveModulePerSourceSet(projectLevelSettings.isResolveModulePerSourceSet());
            }
            GradleManager.configureExecutionWorkspace(projectLevelSettings, settings, result, project, (String)pair.second);
            return result;
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager", "getExecutionSettingsProvider"));
        }
        return function;
    }

    private static void configureExecutionWorkspace(@Nullable GradleProjectSettings compositeRootSettings, GradleSettings settings, GradleExecutionSettings result, Project project, String projectPath) {
        if (compositeRootSettings == null || compositeRootSettings.getCompositeBuild() == null) {
            return;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = compositeRootSettings.getCompositeBuild();
        if (compositeBuild.getCompositeDefinitionSource() == CompositeDefinitionSource.SCRIPT) {
            if (FileUtil.pathsEqual((String)compositeRootSettings.getExternalProjectPath(), (String)projectPath)) {
                return;
            }
            for (BuildParticipant buildParticipant : compositeBuild.getCompositeParticipants()) {
                if (FileUtil.pathsEqual((String)buildParticipant.getRootPath(), (String)projectPath) || buildParticipant.getProjects().stream().anyMatch(path -> FileUtil.pathsEqual((String)path, (String)projectPath))) continue;
                result.getExecutionWorkspace().addBuildParticipant(new GradleBuildParticipant(buildParticipant.getRootPath()));
            }
            return;
        }
        for (GradleProjectSettings projectSettings : settings.getLinkedProjectsSettings()) {
            if (projectSettings == compositeRootSettings || compositeBuild.getCompositeParticipants().stream().noneMatch(participant -> FileUtil.pathsEqual((String)participant.getRootPath(), (String)projectSettings.getExternalProjectPath()))) continue;
            GradleBuildParticipant buildParticipant = new GradleBuildParticipant(projectSettings.getExternalProjectPath());
            ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, projectSettings.getExternalProjectPath());
            if (projectData == null || projectData.getExternalProjectStructure() == null) continue;
            Collection moduleNodes = ExternalSystemApiUtil.findAll((DataNode)projectData.getExternalProjectStructure(), (Key)ProjectKeys.MODULE);
            for (DataNode moduleNode : moduleNodes) {
                ModuleData moduleData = (ModuleData)moduleNode.getData();
                if (moduleData.getArtifacts().isEmpty()) {
                    Collection sourceSetNodes = ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY);
                    for (DataNode sourceSetNode : sourceSetNodes) {
                        buildParticipant.addModule((ModuleData)sourceSetNode.getData());
                    }
                    continue;
                }
                buildParticipant.addModule(moduleData);
            }
            result.getExecutionWorkspace().addBuildParticipant(buildParticipant);
        }
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) throws ExecutionException {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/gradle/GradleManager", "enhanceRemoteProcessing"));
        }
        HashSet additionalEntries = ContainerUtilRt.newHashSet();
        for (GradleProjectResolverExtension extension : (List)RESOLVER_EXTENSIONS.getValue()) {
            ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(extension.getClass()));
            for (Class aClass : extension.getExtraProjectModelClasses()) {
                ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass((Class)aClass));
            }
            extension.enhanceRemoteProcessing(parameters);
        }
        PathsList classPath = parameters.getClassPath();
        for (String entry : additionalEntries) {
            classPath.add(entry);
        }
        parameters.getVMParametersList().addProperty("external.system.id", GradleConstants.SYSTEM_ID.getId());
    }

    public void enhanceLocalProcessing(@NotNull List<URL> urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "org/jetbrains/plugins/gradle/GradleManager", "enhanceLocalProcessing"));
        }
    }

    @NotNull
    public Class<? extends ExternalSystemProjectResolver<GradleExecutionSettings>> getProjectResolverClass() {
        if (GradleProjectResolver.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager", "getProjectResolverClass"));
        }
        return GradleProjectResolver.class;
    }

    public Class<? extends ExternalSystemTaskManager<GradleExecutionSettings>> getTaskManagerClass() {
        return GradleTaskManager.class;
    }

    @NotNull
    public Configurable getConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/GradleManager", "getConfigurable"));
        }
        GradleConfigurable gradleConfigurable = new GradleConfigurable(project);
        if (gradleConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager", "getConfigurable"));
        }
        return gradleConfigurable;
    }

    @Nullable
    public FileChooserDescriptor getExternalProjectConfigDescriptor() {
        return GradleUtil.getGradleProjectFileChooserDescriptor();
    }

    @Nullable
    public Icon getProjectIcon() {
        return GradleIcons.Gradle;
    }

    @Nullable
    public Icon getTaskIcon() {
        return DefaultExternalSystemUiAware.INSTANCE.getTaskIcon();
    }

    @NotNull
    public String getProjectRepresentationName(@NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        if (targetProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetProjectPath", "org/jetbrains/plugins/gradle/GradleManager", "getProjectRepresentationName"));
        }
        String string = ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)rootProjectPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager", "getProjectRepresentationName"));
        }
        return string;
    }

    @NotNull
    public String getProjectRepresentationName(@NotNull Project project, @NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/GradleManager", "getProjectRepresentationName"));
        }
        if (targetProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetProjectPath", "org/jetbrains/plugins/gradle/GradleManager", "getProjectRepresentationName"));
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(targetProjectPath);
        if (projectSettings != null && projectSettings.getCompositeBuild() != null) {
            for (BuildParticipant buildParticipant : projectSettings.getCompositeBuild().getCompositeParticipants()) {
                if (!buildParticipant.getProjects().contains(targetProjectPath)) continue;
                String string = ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)buildParticipant.getRootPath());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager", "getProjectRepresentationName"));
                }
                return string;
            }
        }
        String string = ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)rootProjectPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager", "getProjectRepresentationName"));
        }
        return string;
    }

    @Nullable
    public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project) {
        if (changedFileOrDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFileOrDirPath", "org/jetbrains/plugins/gradle/GradleManager", "getAffectedExternalProjectPath"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/GradleManager", "getAffectedExternalProjectPath"));
        }
        return this.myAutoImportDelegate.getAffectedExternalProjectPath(changedFileOrDirPath, project);
    }

    public List<File> getAffectedExternalProjectFiles(String projectPath, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/GradleManager", "getAffectedExternalProjectFiles"));
        }
        return this.myAutoImportDelegate.getAffectedExternalProjectFiles(projectPath, project);
    }

    @NotNull
    public FileChooserDescriptor getExternalProjectDescriptor() {
        FileChooserDescriptor fileChooserDescriptor = GradleUtil.getGradleProjectFileChooserDescriptor();
        if (fileChooserDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager", "getExternalProjectDescriptor"));
        }
        return fileChooserDescriptor;
    }

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/GradleManager", "runActivity"));
        }
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(GradleSettings.getInstance(project).getChangesTopic(), (Object)new GradleSettingsListenerAdapter(){

            @Override
            public void onServiceDirectoryPathChange(@Nullable String oldPath, @Nullable String newPath) {
                this.ensureProjectsRefresh();
            }

            @Override
            public void onGradleHomeChange(@Nullable String oldPath, @Nullable String newPath, @NotNull String linkedProjectPath) {
                if (linkedProjectPath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "org/jetbrains/plugins/gradle/GradleManager$2", "onGradleHomeChange"));
                }
                this.ensureProjectsRefresh();
            }

            @Override
            public void onGradleDistributionTypeChange(DistributionType currentValue, @NotNull String linkedProjectPath) {
                if (linkedProjectPath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "org/jetbrains/plugins/gradle/GradleManager$2", "onGradleDistributionTypeChange"));
                }
                this.ensureProjectsRefresh();
            }

            private void ensureProjectsRefresh() {
                ExternalSystemUtil.refreshProjects((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (boolean)true);
            }
        });
        Map<String, String> adjustedPaths = GradleManager.patchLinkedProjects(project);
        if (adjustedPaths == null) {
            return;
        }
        GradleLocalSettings localSettings = GradleLocalSettings.getInstance(project);
        GradleManager.patchRecentTasks(adjustedPaths, localSettings);
        GradleManager.patchAvailableProjects(adjustedPaths, localSettings);
        GradleManager.patchAvailableTasks(adjustedPaths, localSettings);
    }

    @Nullable
    private static Map<String, String> patchLinkedProjects(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/GradleManager", "patchLinkedProjects"));
        }
        GradleSettings settings = GradleSettings.getInstance(project);
        ArrayList correctedSettings = ContainerUtilRt.newArrayList();
        HashMap adjustedPaths = ContainerUtilRt.newHashMap();
        for (GradleProjectSettings projectSettings : settings.getLinkedProjectsSettings()) {
            String oldPath = projectSettings.getExternalProjectPath();
            if (oldPath != null && new File(oldPath).isFile() && FileUtilRt.extensionEquals((String)oldPath, (String)"gradle")) {
                try {
                    String newPath = new File(oldPath).getParentFile().getCanonicalPath();
                    projectSettings.setExternalProjectPath(newPath);
                    adjustedPaths.put(oldPath, newPath);
                }
                catch (IOException e) {
                    LOG.warn(String.format("Unexpected exception occurred on attempt to re-point linked gradle project path from build.gradle to its parent dir. Path: %s", oldPath), (Throwable)e);
                }
            }
            correctedSettings.add(projectSettings);
        }
        if (adjustedPaths.isEmpty()) {
            return null;
        }
        settings.setLinkedProjectsSettings(correctedSettings);
        return adjustedPaths;
    }

    private static void patchAvailableTasks(@NotNull Map<String, String> adjustedPaths, @NotNull GradleLocalSettings localSettings) {
        if (adjustedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adjustedPaths", "org/jetbrains/plugins/gradle/GradleManager", "patchAvailableTasks"));
        }
        if (localSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localSettings", "org/jetbrains/plugins/gradle/GradleManager", "patchAvailableTasks"));
        }
        HashMap adjustedAvailableTasks = ContainerUtilRt.newHashMap();
        for (Map.Entry entry : localSettings.getAvailableTasks().entrySet()) {
            String newPath = adjustedPaths.get(entry.getKey());
            if (newPath == null) {
                adjustedAvailableTasks.put(entry.getKey(), entry.getValue());
                continue;
            }
            for (ExternalTaskPojo task : (Collection)entry.getValue()) {
                String newTaskPath = adjustedPaths.get(task.getLinkedExternalProjectPath());
                if (newTaskPath == null) continue;
                task.setLinkedExternalProjectPath(newTaskPath);
            }
            adjustedAvailableTasks.put(newPath, entry.getValue());
        }
        localSettings.setAvailableTasks(adjustedAvailableTasks);
    }

    private static void patchAvailableProjects(@NotNull Map<String, String> adjustedPaths, @NotNull GradleLocalSettings localSettings) {
        if (adjustedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adjustedPaths", "org/jetbrains/plugins/gradle/GradleManager", "patchAvailableProjects"));
        }
        if (localSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localSettings", "org/jetbrains/plugins/gradle/GradleManager", "patchAvailableProjects"));
        }
        HashMap adjustedAvailableProjects = ContainerUtilRt.newHashMap();
        for (Map.Entry entry : localSettings.getAvailableProjects().entrySet()) {
            String newPath = adjustedPaths.get(((ExternalProjectPojo)entry.getKey()).getPath());
            if (newPath == null) {
                adjustedAvailableProjects.put(entry.getKey(), entry.getValue());
                continue;
            }
            adjustedAvailableProjects.put(new ExternalProjectPojo(((ExternalProjectPojo)entry.getKey()).getName(), newPath), entry.getValue());
        }
        localSettings.setAvailableProjects(adjustedAvailableProjects);
    }

    private static void patchRecentTasks(@NotNull Map<String, String> adjustedPaths, @NotNull GradleLocalSettings localSettings) {
        if (adjustedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adjustedPaths", "org/jetbrains/plugins/gradle/GradleManager", "patchRecentTasks"));
        }
        if (localSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localSettings", "org/jetbrains/plugins/gradle/GradleManager", "patchRecentTasks"));
        }
        for (ExternalTaskExecutionInfo taskInfo : localSettings.getRecentTasks()) {
            ExternalSystemTaskExecutionSettings s = taskInfo.getSettings();
            String newPath = adjustedPaths.get(s.getExternalProjectPath());
            if (newPath == null) continue;
            s.setExternalProjectPath(newPath);
        }
    }
}

