/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class JUnitDevKitPatcher
extends JUnitPatcher {
    private static final Logger LOG = Logger.getInstance(JUnitDevKitPatcher.class);
    private static final String SYSTEM_CL_PROPERTY = "java.system.class.loader";

    public void patchJavaParameters(@Nullable Module module, JavaParameters javaParameters) {
        File sandboxHome;
        String id;
        String qualifiedName;
        JavaPsiFacade facade;
        PsiClass loader;
        Sdk jdk = javaParameters.getJdk();
        if (jdk == null) {
            return;
        }
        ParametersList vm = javaParameters.getVMParametersList();
        if (module != null && PsiUtil.isIdeaProject(module.getProject()) && !vm.hasProperty(SYSTEM_CL_PROPERTY) && !JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_9) && (loader = (PsiClass)ReadAction.compute(() -> JUnitDevKitPatcher.lambda$patchJavaParameters$0(facade = JavaPsiFacade.getInstance((Project)module.getProject()), qualifiedName = UrlClassLoader.class.getName(), module))) != null) {
            vm.addProperty(SYSTEM_CL_PROPERTY, qualifiedName);
        }
        if ((jdk = IdeaJdk.findIdeaJdk(jdk)) == null) {
            return;
        }
        String libPath = jdk.getHomePath() + File.separator + "lib";
        vm.add("-Xbootclasspath/a:" + libPath + File.separator + "boot.jar");
        if (!vm.hasProperty("idea.load.plugins.id") && module != null && PluginModuleType.isOfType(module) && (id = DescriptorUtil.getPluginId(module)) != null) {
            vm.defineProperty("idea.load.plugins.id", id);
        }
        if ((sandboxHome = JUnitDevKitPatcher.getSandboxPath(jdk)) != null) {
            if (!vm.hasProperty("idea.home.path")) {
                File homeDir = new File(sandboxHome, "test");
                FileUtil.createDirectory((File)homeDir);
                String buildNumber = IdeaJdk.getBuildNumber(jdk.getHomePath());
                if (buildNumber != null) {
                    try {
                        FileUtil.writeToFile((File)new File(homeDir, "build.txt"), (String)buildNumber);
                    }
                    catch (IOException e) {
                        LOG.warn("failed to create build.txt in " + homeDir + ": " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    LOG.warn("Cannot determine build number for " + jdk.getHomePath());
                }
                vm.defineProperty("idea.home.path", homeDir.getAbsolutePath());
            }
            if (!vm.hasProperty("idea.plugins.path")) {
                vm.defineProperty("idea.plugins.path", new File(sandboxHome, "plugins").getAbsolutePath());
            }
        }
        javaParameters.getClassPath().addFirst(libPath + File.separator + "idea.jar");
        javaParameters.getClassPath().addFirst(libPath + File.separator + "resources.jar");
        javaParameters.getClassPath().addFirst(((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk));
    }

    @Nullable
    private static File getSandboxPath(Sdk jdk) {
        String sandboxHome;
        SdkAdditionalData additionalData = jdk.getSdkAdditionalData();
        if (additionalData instanceof Sandbox && (sandboxHome = ((Sandbox)additionalData).getSandboxHome()) != null) {
            return new File(FileUtil.toCanonicalPath((String)sandboxHome));
        }
        return null;
    }

    private static /* synthetic */ PsiClass lambda$patchJavaParameters$0(JavaPsiFacade facade, String qualifiedName, @Nullable Module module) throws RuntimeException {
        return facade.findClass(qualifiedName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
    }
}

