/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.util.JreVersionDetector;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.classFilter.ClassFilterEditor;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageConfigurable
extends SettingsEditor<RunConfigurationBase> {
    private static final Logger LOG = Logger.getInstance((String)("#" + CoverageConfigurable.class.getName()));
    private final JreVersionDetector myVersionDetector = new JreVersionDetector();
    Project myProject;
    private MyClassFilterEditor myClassFilterEditor;
    private JLabel myCoverageNotSupportedLabel;
    private JComboBox myCoverageRunnerCb;
    private JPanel myRunnerPanel;
    private JCheckBox myTrackPerTestCoverageCb;
    private JCheckBox myTrackTestSourcesCb;
    private JRadioButton myTracingRb;
    private JRadioButton mySamplingRb;
    private final RunConfigurationBase myConfig;

    public CoverageConfigurable(RunConfigurationBase config) {
        this.myConfig = config;
        this.myProject = config.getProject();
    }

    protected void resetEditorFrom(@NotNull RunConfigurationBase runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/configurations/coverage/CoverageConfigurable", "resetEditorFrom"));
        }
        boolean isJre50 = runConfiguration instanceof CommonJavaRunConfigurationParameters && this.myVersionDetector.isJre50Configured((CommonJavaRunConfigurationParameters)runConfiguration) ? true : (runConfiguration instanceof ModuleBasedConfiguration ? this.myVersionDetector.isModuleJre50Configured((ModuleBasedConfiguration)runConfiguration) : true);
        this.myCoverageNotSupportedLabel.setVisible(!isJre50);
        JavaCoverageEnabledConfiguration configuration = (JavaCoverageEnabledConfiguration)CoverageEnabledConfiguration.getOrCreate(runConfiguration);
        CoverageRunner runner = configuration.getCoverageRunner();
        if (runner != null) {
            this.myCoverageRunnerCb.setSelectedItem(new CoverageRunnerItem(runner));
        } else {
            String runnerId = configuration.getRunnerId();
            if (runnerId != null) {
                CoverageRunnerItem runnerItem = new CoverageRunnerItem(runnerId);
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.myCoverageRunnerCb.getModel();
                if (model.getIndexOf(runnerItem) == -1) {
                    model.addElement(runnerItem);
                }
                this.myCoverageRunnerCb.setSelectedItem(runnerItem);
            } else {
                this.myCoverageRunnerCb.setSelectedIndex(0);
            }
            runner = ((CoverageRunnerItem)this.myCoverageRunnerCb.getSelectedItem()).getRunner();
        }
        UIUtil.setEnabled((Component)this.myRunnerPanel, (boolean)isJre50, (boolean)true);
        this.myClassFilterEditor.setFilters(configuration.getCoveragePatterns());
        boolean isCoverageByTestApplicable = runner != null && runner.isCoverageByTestApplicable();
        this.myTracingRb.setEnabled(this.myTracingRb.isEnabled() && isCoverageByTestApplicable);
        this.mySamplingRb.setSelected(configuration.isSampling() || !isCoverageByTestApplicable);
        this.myTracingRb.setSelected(!this.mySamplingRb.isSelected());
        this.myTrackPerTestCoverageCb.setSelected(configuration.isTrackPerTestCoverage());
        this.myTrackPerTestCoverageCb.setEnabled(this.myTracingRb.isEnabled() && this.myTracingRb.isSelected() && this.canHavePerTestCoverage());
        this.myTrackTestSourcesCb.setSelected(configuration.isTrackTestFolders());
    }

    protected boolean canHavePerTestCoverage() {
        return CoverageEnabledConfiguration.getOrCreate(this.myConfig).canHavePerTestCoverage();
    }

    protected void applyEditorTo(@NotNull RunConfigurationBase runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/configurations/coverage/CoverageConfigurable", "applyEditorTo"));
        }
        JavaCoverageEnabledConfiguration configuration = (JavaCoverageEnabledConfiguration)CoverageEnabledConfiguration.getOrCreate(runConfiguration);
        configuration.setCoveragePatterns(this.myClassFilterEditor.getFilters());
        configuration.setCoverageRunner(this.getSelectedRunner());
        configuration.setTrackPerTestCoverage(this.myTrackPerTestCoverageCb.isSelected());
        configuration.setSampling(this.mySamplingRb.isSelected());
        configuration.setTrackTestFolders(this.myTrackTestSourcesCb.isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel result = new JPanel(new GridBagLayout());
        DefaultComboBoxModel<CoverageRunnerItem> runnersModel = new DefaultComboBoxModel<CoverageRunnerItem>();
        this.myCoverageRunnerCb = new JComboBox(runnersModel);
        JavaCoverageEnabledConfiguration javaCoverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getFrom(this.myConfig);
        LOG.assertTrue(javaCoverageEnabledConfiguration != null);
        JavaCoverageEngine provider = javaCoverageEnabledConfiguration.getCoverageProvider();
        for (CoverageRunner runner : (CoverageRunner[])Extensions.getExtensions(CoverageRunner.EP_NAME)) {
            if (!runner.acceptsCoverageEngine(provider)) continue;
            runnersModel.addElement(new CoverageRunnerItem(runner));
        }
        this.myCoverageRunnerCb.setRenderer(new ListCellRendererWrapper<CoverageRunnerItem>(){

            public void customize(JList list, CoverageRunnerItem value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getPresentableName());
                }
            }
        });
        this.myCoverageRunnerCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageRunner runner = CoverageConfigurable.this.getSelectedRunner();
                CoverageConfigurable.this.enableTracingPanel(runner != null && runner.isCoverageByTestApplicable());
                CoverageConfigurable.this.myTrackPerTestCoverageCb.setEnabled(CoverageConfigurable.this.myTracingRb.isSelected() && CoverageConfigurable.this.canHavePerTestCoverage() && runner != null && runner.isCoverageByTestApplicable());
            }
        });
        this.myRunnerPanel = new JPanel(new GridBagLayout());
        this.myRunnerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.myRunnerPanel.add((Component)new JLabel("Choose coverage runner:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.insetsRight((int)10), 0, 0));
        this.myRunnerPanel.add((Component)this.myCoverageRunnerCb, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel cPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.mySamplingRb = new JRadioButton("Sampling");
        cPanel.add(this.mySamplingRb);
        this.myTracingRb = new JRadioButton("Tracing");
        cPanel.add(this.myTracingRb);
        ButtonGroup group = new ButtonGroup();
        group.add(this.mySamplingRb);
        group.add(this.myTracingRb);
        ActionListener samplingListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageRunner runner = CoverageConfigurable.this.getSelectedRunner();
                CoverageConfigurable.this.myTrackPerTestCoverageCb.setEnabled(CoverageConfigurable.this.canHavePerTestCoverage() && CoverageConfigurable.this.myTracingRb.isSelected() && runner != null && runner.isCoverageByTestApplicable());
            }
        };
        this.mySamplingRb.addActionListener(samplingListener);
        this.myTracingRb.addActionListener(samplingListener);
        this.myTrackPerTestCoverageCb = new JCheckBox("Track per test coverage");
        JBPanel tracingPanel = JBUI.Panels.simplePanel((Component)this.myTrackPerTestCoverageCb).withBorder((Border)JBUI.Borders.emptyLeft((int)15));
        cPanel.add((Component)tracingPanel);
        this.myRunnerPanel.add((Component)cPanel, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0);
        result.add((Component)this.myRunnerPanel, gc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ExecutionBundle.message((String)"record.coverage.filters.title", (Object[])new Object[0]), (boolean)false));
        this.myClassFilterEditor = new MyClassFilterEditor(this.myProject);
        GridBagConstraints bagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0);
        panel.add((Component)((Object)this.myClassFilterEditor), bagConstraints);
        bagConstraints.weighty = 0.0;
        this.myTrackTestSourcesCb = new JCheckBox("Enable coverage in test folders");
        panel.add((Component)this.myTrackTestSourcesCb, bagConstraints);
        gc.weighty = 1.0;
        gc.fill = 1;
        result.add((Component)panel, gc);
        this.myCoverageNotSupportedLabel = new JLabel(CodeInsightBundle.message((String)"code.coverage.is.not.supported", (Object[])new Object[0]));
        this.myCoverageNotSupportedLabel.setIcon(AllIcons.General.WarningDialog);
        result.add((Component)this.myCoverageNotSupportedLabel, gc);
        JPanel jPanel = result;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/coverage/CoverageConfigurable", "createEditor"));
        }
        return jPanel;
    }

    @Nullable
    private CoverageRunner getSelectedRunner() {
        CoverageRunnerItem runnerItem = (CoverageRunnerItem)this.myCoverageRunnerCb.getSelectedItem();
        if (runnerItem == null) {
            LOG.debug("Available runners: " + this.myCoverageRunnerCb.getModel().getSize());
        }
        return runnerItem != null ? runnerItem.getRunner() : null;
    }

    private void enableTracingPanel(boolean enabled) {
        this.myTracingRb.setEnabled(enabled);
        if (!enabled) {
            this.mySamplingRb.setSelected(true);
        }
    }

    private static class CoverageRunnerItem {
        private CoverageRunner myRunner;
        @NotNull
        private String myRunnerId;

        private CoverageRunnerItem(@NotNull CoverageRunner runner) {
            if (runner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/execution/configurations/coverage/CoverageConfigurable$CoverageRunnerItem", "<init>"));
            }
            this.myRunner = runner;
            this.myRunnerId = runner.getId();
        }

        private CoverageRunnerItem(String runnerId) {
            this.myRunnerId = runnerId;
        }

        public CoverageRunner getRunner() {
            return this.myRunner;
        }

        public String getRunnerId() {
            return this.myRunnerId;
        }

        public String getPresentableName() {
            return this.myRunner != null ? this.myRunner.getPresentableName() : this.myRunnerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoverageRunnerItem that = (CoverageRunnerItem)o;
            return this.myRunnerId.equals(that.myRunnerId);
        }

        public int hashCode() {
            return this.myRunnerId.hashCode();
        }
    }

    private static class MyClassFilterEditor
    extends ClassFilterEditor {
        public MyClassFilterEditor(Project project) {
            super(project, new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return aClass.getContainingClass() == null;
                }
            });
        }

        protected void addPatternFilter() {
            List packages;
            PackageChooserDialog chooser = new PackageChooserDialog(CodeInsightBundle.message((String)"coverage.pattern.filter.editor.choose.package.title", (Object[])new Object[0]), this.myProject);
            if (chooser.showAndGet() && !(packages = chooser.getSelectedPackages()).isEmpty()) {
                for (PsiPackage aPackage : packages) {
                    String fqName = aPackage.getQualifiedName();
                    String pattern = fqName.length() > 0 ? fqName + ".*" : "*";
                    this.myTableModel.addRow(this.createFilter(pattern));
                }
                int row = this.myTableModel.getRowCount() - 1;
                this.myTable.getSelectionModel().setSelectionInterval(row, row);
                this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
                this.myTable.requestFocus();
            }
        }

        protected String getAddPatternButtonText() {
            return CodeInsightBundle.message((String)"coverage.button.add.package", (Object[])new Object[0]);
        }

        protected Icon getAddPatternButtonIcon() {
            return IconUtil.getAddPackageIcon();
        }
    }
}

