/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgRepositorySelectorComponent;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCommonDialogWithChoices
extends DialogWrapper {
    private JPanel contentPanel;
    private JRadioButton branchOption;
    private JRadioButton revisionOption;
    private JRadioButton tagOption;
    private JRadioButton bookmarkOption;
    private JTextField revisionTxt;
    protected JCheckBox cleanCbx;
    private JComboBox branchSelector;
    private JComboBox tagSelector;
    private JComboBox bookmarkSelector;
    protected HgRepositorySelectorComponent hgRepositorySelectorComponent;
    protected JPanel myBranchesBorderPanel;

    public HgCommonDialogWithChoices(@NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/ui/HgCommonDialogWithChoices", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/ui/HgCommonDialogWithChoices", "<init>"));
        }
        super(project, false);
        this.$$$setupUI$$$();
        this.hgRepositorySelectorComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HgCommonDialogWithChoices.this.updateRepository();
            }
        });
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HgCommonDialogWithChoices.this.update();
            }
        };
        this.branchOption.addChangeListener(changeListener);
        this.tagOption.addChangeListener(changeListener);
        this.bookmarkOption.addChangeListener(changeListener);
        this.revisionOption.addChangeListener(changeListener);
        this.cleanCbx.setVisible(false);
        this.setRoots(repositories, selectedRepo);
        this.init();
    }

    public void setRoots(Collection<HgRepository> repos, @Nullable HgRepository selectedRepo) {
        this.hgRepositorySelectorComponent.setRoots(repos);
        this.hgRepositorySelectorComponent.setSelectedRoot(selectedRepo);
        this.updateRepository();
    }

    public HgRepository getRepository() {
        return this.hgRepositorySelectorComponent.getRepository();
    }

    private String getTag() {
        return (String)this.tagSelector.getSelectedItem();
    }

    public boolean isTagSelected() {
        return this.tagOption.isSelected();
    }

    private String getBranch() {
        return (String)this.branchSelector.getSelectedItem();
    }

    public boolean isBranchSelected() {
        return this.branchOption.isSelected();
    }

    private boolean isRevisionSelected() {
        return this.revisionOption.isSelected();
    }

    private String getBookmark() {
        return (String)this.bookmarkSelector.getSelectedItem();
    }

    public boolean isBookmarkSelected() {
        return this.bookmarkOption.isSelected();
    }

    private String getRevision() {
        return this.revisionTxt.getText();
    }

    private void update() {
        this.revisionTxt.setEnabled(this.revisionOption.isSelected());
        this.branchSelector.setEnabled(this.branchOption.isSelected());
        this.tagSelector.setEnabled(this.tagOption.isSelected());
        this.bookmarkSelector.setEnabled(this.bookmarkOption.isSelected());
    }

    private void updateRepository() {
        HgRepository repo = this.hgRepositorySelectorComponent.getRepository();
        this.branchSelector.setModel(new DefaultComboBoxModel<Object>(repo.getOpenedBranches().toArray()));
        DefaultComboBoxModel<Object> tagComboBoxModel = new DefaultComboBoxModel<Object>(HgUtil.getSortedNamesWithoutHashes(repo.getTags()).toArray());
        tagComboBoxModel.addElement("tip");
        this.tagSelector.setModel(tagComboBoxModel);
        this.bookmarkSelector.setModel(new DefaultComboBoxModel<Object>(HgUtil.getSortedNamesWithoutHashes(repo.getBookmarks()).toArray()));
        this.update();
    }

    protected JComponent createCenterPanel() {
        return this.contentPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void createUIComponents() {
    }

    public String getTargetValue() {
        return this.isBranchSelected() ? "branch(\"" + this.getBranch() + "\")" : (this.isBookmarkSelected() ? "bookmark(\"" + this.getBookmark() + "\")" : (this.isTagSelected() ? "tag(\"" + this.getTag() + "\")" : "\"" + this.getRevision() + "\""));
    }

    protected ValidationInfo doValidate() {
        String message = "You have to specify appropriate name or revision.";
        return this.isRevisionSelected() && StringUtil.isEmptyOrSpaces((String)this.getRevision()) ? new ValidationInfo(message, (JComponent)this.myBranchesBorderPanel) : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HgRepositorySelectorComponent hgRepositorySelectorComponent;
        JComboBox jComboBox;
        JRadioButton jRadioButton;
        JComboBox jComboBox2;
        JRadioButton jRadioButton2;
        JTextField jTextField;
        JRadioButton jRadioButton3;
        JComboBox jComboBox3;
        JRadioButton jRadioButton4;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.contentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 2, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.cleanCbx = jCheckBox = new JCheckBox();
        jCheckBox.setText("Overwrite locally modified files (no backup)");
        jCheckBox.setMnemonic('O');
        jCheckBox.setDisplayedMnemonicIndex(0);
        ((Component)jCheckBox).setEnabled(false);
        jCheckBox.putClientProperty("html.disable", Boolean.FALSE);
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myBranchesBorderPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.branchOption = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        jRadioButton4.setText("Branch");
        jRadioButton4.setMnemonic('B');
        jRadioButton4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.branchSelector = jComboBox3 = new JComboBox();
        ((Component)jComboBox3).setEnabled(true);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox3.setModel(defaultComboBoxModel);
        Font font = jComboBox3.getFont();
        if (font != null) {
            jComboBox3.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
        }
        jPanel.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.revisionOption = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(false);
        jRadioButton3.setText("Revision");
        jRadioButton3.setMnemonic('R');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.revisionTxt = jTextField = new JTextField();
        jTextField.setText("");
        ((Component)jTextField).setEnabled(false);
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(240, -1), null));
        this.tagOption = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Tag");
        jRadioButton2.setMnemonic('T');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.tagSelector = jComboBox2 = new JComboBox();
        Font font2 = jComboBox2.getFont();
        if (font2 != null) {
            jComboBox2.setFont(new Font("Monospaced", font2.getStyle(), font2.getSize()));
        }
        jPanel.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.bookmarkOption = jRadioButton = new JRadioButton();
        jRadioButton.setText("Bookmark");
        jRadioButton.setMnemonic('M');
        jRadioButton.setDisplayedMnemonicIndex(4);
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.bookmarkSelector = jComboBox = new JComboBox();
        Font font3 = jComboBox.getFont();
        if (font3 != null) {
            jComboBox.setFont(new Font("Monospaced", font3.getStyle(), font3.getSize()));
        }
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.hgRepositorySelectorComponent = hgRepositorySelectorComponent = new HgRepositorySelectorComponent();
        JComponent jComponent = hgRepositorySelectorComponent.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }
}

