/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.mergeinfo.BranchInfo;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class OneShotMergeInfoHelper
implements MergeChecker {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final Map<Long, Collection<String>> myPartiallyMerged;
    @NotNull
    private final NavigableMap<String, Map<String, SVNMergeRangeList>> myMergeInfoMap;
    @NotNull
    private final Object myMergeInfoLock;

    public OneShotMergeInfoHelper(@NotNull MergeContext mergeContext) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "<init>"));
        }
        this.myMergeContext = mergeContext;
        this.myPartiallyMerged = ContainerUtil.newHashMap();
        this.myMergeInfoLock = new Object();
        this.myMergeInfoMap = new TreeMap(Collections.reverseOrder());
    }

    @Override
    public void prepare() throws VcsException {
        Depth depth = Depth.allOrEmpty(this.myMergeContext.getVcs().getSvnConfiguration().isCheckNestedForQuickMerge());
        File file = this.myMergeContext.getWcInfo().getRootInfo().getIoFile();
        this.myMergeContext.getVcs().getFactory(file).createPropertyClient().getProperty(SvnTarget.fromFile((File)file), "svn:mergeinfo", SVNRevision.WORKING, depth, this.createPropertyHandler());
    }

    @Override
    @Nullable
    public Collection<String> getNotMergedPaths(@NotNull SvnChangeList changeList) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "getNotMergedPaths"));
        }
        return this.myPartiallyMerged.get(changeList.getNumber());
    }

    @Override
    @NotNull
    public SvnMergeInfoCache.MergeCheckResult checkList(@NotNull SvnChangeList changeList) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkList"));
        }
        HashSet notMergedPaths = ContainerUtil.newHashSet();
        boolean hasMergedPaths = false;
        for (String path : changeList.getAffectedPaths()) {
            switch (this.checkPath(path, changeList.getNumber())) {
                case MERGED: {
                    hasMergedPaths = true;
                    break;
                }
                case NOT_MERGED: {
                    notMergedPaths.add(path);
                }
            }
        }
        if (hasMergedPaths && !notMergedPaths.isEmpty()) {
            this.myPartiallyMerged.put(changeList.getNumber(), notMergedPaths);
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = notMergedPaths.isEmpty() ? (hasMergedPaths ? SvnMergeInfoCache.MergeCheckResult.MERGED : SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS) : SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        if (mergeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkList"));
        }
        return mergeCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SvnMergeInfoCache.MergeCheckResult checkPath(@NotNull String repositoryRelativePath, long revisionNumber) {
        if (repositoryRelativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryRelativePath", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkPath"));
        }
        SvnMergeInfoCache.MergeCheckResult result = SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
        String sourceRelativePath = SVNPathUtil.getRelativePath((String)this.myMergeContext.getRepositoryRelativeSourcePath(), (String)SvnUtil.ensureStartSlash(repositoryRelativePath));
        if (sourceRelativePath != null) {
            InfoProcessor processor = new InfoProcessor(sourceRelativePath, this.myMergeContext.getRepositoryRelativeSourcePath(), revisionNumber);
            String key = OneShotMergeInfoHelper.toKey(sourceRelativePath);
            Object object = this.myMergeInfoLock;
            synchronized (object) {
                Map mergeInfo = (Map)this.myMergeInfoMap.get(key);
                if (mergeInfo != null) {
                    processor.process(key, mergeInfo);
                } else {
                    Map.Entry<String, Map<String, SVNMergeRangeList>> entry;
                    Iterator<Map.Entry<String, Map<String, SVNMergeRangeList>>> iterator = this.myMergeInfoMap.tailMap(key).entrySet().iterator();
                    while (!(!iterator.hasNext() || OneShotMergeInfoHelper.isUnder((entry = iterator.next()).getKey(), key) && processor.process(entry.getKey(), entry.getValue()))) {
                    }
                }
            }
            result = SvnMergeInfoCache.MergeCheckResult.getInstance(processor.isMerged());
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = result;
        if (mergeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkPath"));
        }
        return mergeCheckResult;
    }

    private static boolean isUnder(@NotNull String parentUrl, @NotNull String childUrl) {
        if (parentUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentUrl", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "isUnder"));
        }
        if (childUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childUrl", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "isUnder"));
        }
        return ".".equals(parentUrl) || SVNPathUtil.isAncestor((String)SvnUtil.ensureStartSlash(parentUrl), (String)SvnUtil.ensureStartSlash(childUrl));
    }

    @NotNull
    private PropertyConsumer createPropertyHandler() {
        PropertyConsumer propertyConsumer = new PropertyConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleProperty(@NotNull File path, @NotNull PropertyData property) throws SVNException {
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$1", "handleProperty"));
                }
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$1", "handleProperty"));
                }
                String workingCopyRelativePath = OneShotMergeInfoHelper.this.getWorkingCopyRelativePath(path);
                Map<String, SVNMergeRangeList> mergeInfo = this.parseMergeInfo(property);
                Object object = OneShotMergeInfoHelper.this.myMergeInfoLock;
                synchronized (object) {
                    OneShotMergeInfoHelper.this.myMergeInfoMap.put(OneShotMergeInfoHelper.toKey(workingCopyRelativePath), mergeInfo);
                }
            }

            @Override
            public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
            }

            @Override
            public void handleProperty(long revision, PropertyData property) throws SVNException {
            }

            @NotNull
            private Map<String, SVNMergeRangeList> parseMergeInfo(@NotNull PropertyData property) throws SVNException {
                Map<String, SVNMergeRangeList> map;
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$1", "parseMergeInfo"));
                }
                try {
                    map = BranchInfo.parseMergeInfo((PropertyValue)ObjectUtils.notNull((Object)property.getValue()));
                }
                catch (SvnBindException e) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.MERGE_INFO_PARSE_ERROR, (Throwable)((Object)e)), (Throwable)((Object)e));
                }
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$1", "parseMergeInfo"));
                }
                return map;
            }
        };
        if (propertyConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "createPropertyHandler"));
        }
        return propertyConsumer;
    }

    @NotNull
    private String getWorkingCopyRelativePath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "getWorkingCopyRelativePath"));
        }
        String string = FileUtil.toSystemIndependentName((String)((String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((File)this.myMergeContext.getWcInfo().getRootInfo().getIoFile(), (File)file))));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "getWorkingCopyRelativePath"));
        }
        return string;
    }

    @NotNull
    private static String toKey(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "toKey"));
        }
        String string = SystemInfo.isFileSystemCaseSensitive ? path : StringUtil.toUpperCase((String)path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "toKey"));
        }
        return string;
    }

    public boolean checkListForPaths(@NotNull LogHierarchyNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkListForPaths"));
        }
        boolean isLocalChange = ContainerUtil.or(node.getChildren(), this::checkForSubtree);
        return isLocalChange || OneShotMergeInfoHelper.checkForEntry(node.getMe(), this.myMergeContext.getRepositoryRelativeWorkingCopyPath(), this.myMergeContext.getRepositoryRelativeSourcePath());
    }

    private boolean checkForSubtree(@NotNull LogHierarchyNode tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkForSubtree"));
        }
        LinkedList<LogHierarchyNode> queue = new LinkedList<LogHierarchyNode>();
        queue.addLast(tree);
        while (!queue.isEmpty()) {
            LogHierarchyNode element = (LogHierarchyNode)queue.removeFirst();
            ProgressManager.checkCanceled();
            if (OneShotMergeInfoHelper.checkForEntry(element.getMe(), this.myMergeContext.getRepositoryRelativeSourcePath(), this.myMergeContext.getRepositoryRelativeWorkingCopyPath())) {
                return true;
            }
            queue.addAll(element.getChildren());
        }
        return false;
    }

    private static boolean checkForEntry(@NotNull LogEntry entry, @NotNull String localURL, @NotNull String relativeBranch) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkForEntry"));
        }
        if (localURL == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localURL", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkForEntry"));
        }
        if (relativeBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeBranch", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper", "checkForEntry"));
        }
        boolean atLeastOneUnderBranch = false;
        for (LogEntryPath path : entry.getChangedPaths().values()) {
            if (SVNPathUtil.isAncestor((String)localURL, (String)path.getPath())) {
                return true;
            }
            if (atLeastOneUnderBranch || !SVNPathUtil.isAncestor((String)relativeBranch, (String)path.getPath())) continue;
            atLeastOneUnderBranch = true;
        }
        return !atLeastOneUnderBranch;
    }

    private static class InfoProcessor
    implements PairProcessor<String, Map<String, SVNMergeRangeList>> {
        @NotNull
        private final String myRepositoryRelativeSourcePath;
        private boolean myIsMerged;
        @NotNull
        private final String mySourceRelativePath;
        private final long myRevisionNumber;

        public InfoProcessor(@NotNull String sourceRelativePath, @NotNull String repositoryRelativeSourcePath, long revisionNumber) {
            if (sourceRelativePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRelativePath", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$InfoProcessor", "<init>"));
            }
            if (repositoryRelativeSourcePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryRelativeSourcePath", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$InfoProcessor", "<init>"));
            }
            this.mySourceRelativePath = sourceRelativePath;
            this.myRevisionNumber = revisionNumber;
            this.myRepositoryRelativeSourcePath = SvnUtil.ensureStartSlash(repositoryRelativeSourcePath);
        }

        public boolean isMerged() {
            return this.myIsMerged;
        }

        public boolean process(@NotNull String workingCopyRelativePath, @NotNull Map<String, SVNMergeRangeList> mergedPathsMap) {
            if (workingCopyRelativePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingCopyRelativePath", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$InfoProcessor", "process"));
            }
            if (mergedPathsMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedPathsMap", "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$InfoProcessor", "process"));
            }
            boolean processed = false;
            boolean isCurrentPath = workingCopyRelativePath.equals(this.mySourceRelativePath);
            if (mergedPathsMap.isEmpty()) {
                this.myIsMerged = false;
                processed = true;
            } else {
                String mergedPathAffectingSourcePath = (String)ContainerUtil.find(mergedPathsMap.keySet(), path -> SVNPathUtil.isAncestor((String)this.myRepositoryRelativeSourcePath, (String)SvnUtil.ensureStartSlash(path)));
                if (mergedPathAffectingSourcePath != null) {
                    SVNMergeRangeList mergeRangeList = mergedPathsMap.get(mergedPathAffectingSourcePath);
                    processed = true;
                    this.myIsMerged = ContainerUtil.exists((Object[])mergeRangeList.getRanges(), range -> BranchInfo.isInRange(range, this.myRevisionNumber) && (range.isInheritable() || isCurrentPath));
                }
            }
            return processed;
        }
    }
}

