/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.idea.svn.DepthCombo;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.update.AbstractSvnUpdatePanel;
import org.jetbrains.idea.svn.update.SvnPanel;
import org.jetbrains.idea.svn.update.SvnUpdateRootOptionsPanel;

public class SvnUpdatePanel
extends AbstractSvnUpdatePanel {
    private JPanel myConfigureRootsPanel;
    private JCheckBox myForceBox;
    private JPanel myPanel;
    private JCheckBox myLockOnDemand;
    private DepthCombo myDepthCombo;
    private JLabel myDepthLabel;
    private JPanel myAdditionalPanel;
    private JCheckBox myIgnoreExternalsCheckBox;

    public SvnUpdatePanel(SvnVcs vcs, Collection<FilePath> roots) {
        super(vcs);
        this.$$$setupUI$$$();
        this.init(roots);
        boolean descend = false;
        for (FilePath root : roots) {
            if (!root.isDirectory()) continue;
            descend = true;
            break;
        }
        this.myDepthCombo.setVisible(descend);
        this.myDepthLabel.setVisible(descend);
        this.myDepthLabel.setLabelFor(this.myDepthCombo);
        final SvnConfiguration svnConfiguration = this.myVCS.getSvnConfiguration();
        this.myLockOnDemand.setSelected(svnConfiguration.isUpdateLockOnDemand());
        this.myLockOnDemand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                svnConfiguration.setUpdateLockOnDemand(SvnUpdatePanel.this.myLockOnDemand.isSelected());
            }
        });
        this.myForceBox.setSelected(svnConfiguration.isForceUpdate());
        this.myIgnoreExternalsCheckBox.setSelected(svnConfiguration.isIgnoreExternals());
        this.myForceBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                svnConfiguration.setForceUpdate(SvnUpdatePanel.this.myForceBox.isSelected());
            }
        });
        this.myIgnoreExternalsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                svnConfiguration.setIgnoreExternals(SvnUpdatePanel.this.myIgnoreExternalsCheckBox.isSelected());
            }
        });
    }

    @Override
    protected JPanel getRootsPanel() {
        return this.myConfigureRootsPanel;
    }

    @Override
    protected JPanel getAdditionalPanel() {
        return this.myAdditionalPanel;
    }

    @Override
    protected SvnPanel createRootPanel(FilePath root, SvnVcs vcs, Collection<FilePath> roots) {
        return new SvnUpdateRootOptionsPanel(root, vcs, roots);
    }

    @Override
    protected JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected DepthCombo getDepthBox() {
        return this.myDepthCombo;
    }

    private void createUIComponents() {
        this.myLockOnDemand = new JCheckBox(){

            @Override
            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip(){
                    {
                        this.setUI((ComponentUI)new MultiLineTooltipUI());
                    }
                };
                toolTip.setComponent(this);
                return toolTip;
            }
        };
        this.myDepthCombo = new DepthCombo(true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "Center");
        this.myAdditionalPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, "Center");
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDepthLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.depth.text"));
        jLabel.setToolTipText(ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.depth.description"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myForceBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Force update");
        jCheckBox2.setMnemonic('F');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JCheckBox jCheckBox3 = this.myLockOnDemand;
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.Subversion.update.use.locks.on.demand.text"));
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.Subversion.update.use.locks.on.demand.description"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myIgnoreExternalsCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Ignore Externals");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(7);
        ((Component)jCheckBox).setVisible(true);
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        DepthCombo depthCombo = this.myDepthCombo;
        jPanel2.add((Component)depthCombo, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myConfigureRootsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

