/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.FileHyperlinkInfoBaseKt;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/filters/FileHyperlinkInfoBase;", "Lcom/intellij/execution/filters/FileHyperlinkInfo;", "myProject", "Lcom/intellij/openapi/project/Project;", "myDocumentLine", "", "myDocumentColumn", "(Lcom/intellij/openapi/project/Project;II)V", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "navigate", "", "project", "lang-api"})
public abstract class FileHyperlinkInfoBase
implements FileHyperlinkInfo {
    private final Project myProject;
    private final int myDocumentLine;
    private final int myDocumentColumn;

    @Nullable
    protected abstract VirtualFile getVirtualFile();

    @Override
    @Nullable
    public OpenFileDescriptor getDescriptor() {
        LineNumbersMapping lineNumbersMapping;
        LineNumbersMapping mapping;
        int mappingLine;
        Object object;
        int line;
        VirtualFile file = this.getVirtualFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        Integer offset = FileHyperlinkInfoBaseKt.access$calculateOffset(document, line = (object = (LineNumbersMapping)file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null && (object = (mappingLine = (mapping = (lineNumbersMapping = object)).bytecodeToSource(this.myDocumentLine + 1) - 1) < 0 ? null : Integer.valueOf(mappingLine)) != null ? (Integer)object : this.myDocumentLine, this.myDocumentColumn);
        if (offset == null) {
            return new OpenFileDescriptor(this.myProject, file, line, this.myDocumentColumn);
        }
        return new OpenFileDescriptor(this.myProject, file, offset);
    }

    @Override
    public void navigate(@Nullable Project project) {
        block1: {
            OpenFileDescriptor openFileDescriptor;
            if (project == null) {
                return;
            }
            OpenFileDescriptor openFileDescriptor2 = this.getDescriptor();
            if (openFileDescriptor2 == null) break block1;
            OpenFileDescriptor it = openFileDescriptor = openFileDescriptor2;
            FileEditorManager.getInstance(project).openTextEditor(it, true);
        }
    }

    public FileHyperlinkInfoBase(@NotNull Project myProject, int myDocumentLine, int myDocumentColumn) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myDocumentLine = myDocumentLine;
        this.myDocumentColumn = myDocumentColumn;
    }
}

