/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.LanguageLevelState;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.Nullable;

public class LanguageLevelModuleExtensionImpl
extends ModuleExtension
implements LanguageLevelModuleExtension,
PersistentStateComponentWithModificationTracker<LanguageLevelState> {
    private static final Logger LOG = Logger.getInstance(LanguageLevelModuleExtensionImpl.class);
    private Module myModule;
    private final boolean myWritable;
    private final LanguageLevelModuleExtensionImpl mySource;
    private LanguageLevelState myState = new LanguageLevelState();

    @Override
    public long getStateModificationCount() {
        return this.myState.getModificationCount();
    }

    public static LanguageLevelModuleExtensionImpl getInstance(Module module) {
        return ModuleRootManager.getInstance(module).getModuleExtension(LanguageLevelModuleExtensionImpl.class);
    }

    public LanguageLevelModuleExtensionImpl(Module module) {
        this.myModule = module;
        this.mySource = null;
        this.myWritable = false;
    }

    public LanguageLevelModuleExtensionImpl(LanguageLevelModuleExtensionImpl source, boolean writable) {
        this.myWritable = writable;
        this.myModule = source.myModule;
        this.mySource = source;
        this.myState.setLanguageLevel(source.getLanguageLevel());
    }

    @Override
    public void setLanguageLevel(LanguageLevel languageLevel) {
        LOG.assertTrue(this.myWritable, (Object)"Writable model can be retrieved from writable ModifiableRootModel");
        this.myState.setLanguageLevel(languageLevel);
    }

    @Override
    @Nullable
    public LanguageLevelState getState() {
        return this.myState;
    }

    @Override
    public void loadState(LanguageLevelState state) {
        this.myState = state;
    }

    @Override
    public ModuleExtension getModifiableModel(boolean writable) {
        return new LanguageLevelModuleExtensionImpl(this, writable);
    }

    @Override
    public void commit() {
        if (this.isChanged()) {
            this.mySource.myState.setLanguageLevel(this.myState.getLanguageLevel());
            LanguageLevelProjectExtension.getInstance(this.myModule.getProject()).languageLevelsChanged();
        }
    }

    @Override
    public boolean isChanged() {
        return this.mySource != null && !this.mySource.myState.equals(this.myState);
    }

    public void dispose() {
        this.myModule = null;
        this.myState = null;
    }

    @Override
    @Nullable
    public LanguageLevel getLanguageLevel() {
        return this.myState.getLanguageLevel();
    }
}

