/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.idea.diagnostics.error.AnonymousFeedbackTask;
import com.android.tools.idea.diagnostics.error.ErrorReportCustomizer;
import com.google.common.collect.Maps;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.ITNReporterKt;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.ide.DataManager;
import com.intellij.idea.IdeaLogger;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.diagnostics.error.IdeaITNProxy;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ErrorReporter
extends ErrorReportSubmitter {
    private static final String FEEDBACK_TASK_TITLE = "Submitting error report";

    @NotNull
    public String getReportActionText() {
        String string = AndroidBundle.message("error.report.to.google.action", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/error/ErrorReporter", "getReportActionText"));
        }
        return string;
    }

    public boolean submit(@NotNull IdeaLoggingEvent[] events, String additionalInfo, @NotNull Component parentComponent, @NotNull Consumer<SubmittedReportInfo> consumer) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/diagnostics/error/ErrorReporter", "submit"));
        }
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/android/tools/idea/diagnostics/error/ErrorReporter", "submit"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/diagnostics/error/ErrorReporter", "submit"));
        }
        ErrorBean errorBean = new ErrorBean(events[0].getThrowable(), IdeaLogger.ourLastActionId);
        return ErrorReporter.doSubmit(events[0], parentComponent, consumer, errorBean, additionalInfo);
    }

    private static boolean doSubmit(IdeaLoggingEvent event, Component parentComponent, final Consumer<SubmittedReportInfo> callback, ErrorBean bean, String description) {
        Task.Backgroundable feedbackTask;
        DataContext dataContext = DataManager.getInstance().getDataContext(parentComponent);
        bean.setDescription(description);
        bean.setMessage(event.getMessage());
        ITNReporterKt.setPluginInfo((IdeaLoggingEvent)event, (ErrorBean)bean);
        Object data = event.getData();
        if (data instanceof AbstractMessage) {
            bean.setAttachments(((AbstractMessage)data).getIncludedAttachments());
        }
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Consumer<String> successCallback = new Consumer<String>(){

            public void consume(String token) {
                SubmittedReportInfo reportInfo = new SubmittedReportInfo(null, "Issue " + token, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
                callback.consume((Object)reportInfo);
                ReportMessages.GROUP.createNotification(ReportMessages.ERROR_REPORT, "Submitted", NotificationType.INFORMATION, null).setImportant(false).notify(project);
            }
        };
        Consumer<Exception> errorCallback = new Consumer<Exception>(){

            public void consume(Exception e) {
                String message = AndroidBundle.message("error.report.at.b.android", e.getMessage());
                ReportMessages.GROUP.createNotification(ReportMessages.ERROR_REPORT, message, NotificationType.ERROR, NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(project);
            }
        };
        if (data instanceof ErrorReportCustomizer) {
            feedbackTask = ((ErrorReportCustomizer)data).makeReportingTask(project, FEEDBACK_TASK_TITLE, true, bean, successCallback, errorCallback);
        } else {
            List<Pair<String, String>> kv = IdeaITNProxy.getKeyValuePairs(null, null, bean, IdeaLogger.getOurCompilationTimestamp(), ApplicationManager.getApplication(), (ApplicationInfoEx)ApplicationInfo.getInstance(), ApplicationNamesInfo.getInstance(), UpdateSettings.getInstance());
            feedbackTask = new AnonymousFeedbackTask(project, FEEDBACK_TASK_TITLE, true, event.getThrowable(), ErrorReporter.pair2map(kv), bean.getMessage(), bean.getDescription(), ApplicationInfo.getInstance().getFullVersion(), successCallback, errorCallback);
        }
        if (project == null) {
            feedbackTask.run((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ProgressManager.getInstance().run((Task)feedbackTask);
        }
        return true;
    }

    private static Map<String, String> pair2map(List<Pair<String, String>> kv) {
        HashMap m = Maps.newHashMapWithExpectedSize((int)kv.size());
        for (Pair<String, String> i : kv) {
            m.put(i.getFirst(), i.getSecond());
        }
        return m;
    }
}

