/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.ui.TextViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewTextAction
extends AbstractAction {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myTitle;
    @Nullable
    private final Object myObject;
    @Nullable
    private MyDialog myDialog;

    public ViewTextAction(@NotNull Project project, @NotNull String title, @Nullable Object object) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/gfxtrace/actions/ViewTextAction", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/editors/gfxtrace/actions/ViewTextAction", "<init>"));
        }
        super("View Text");
        this.myProject = project;
        this.myTitle = title;
        this.myObject = object;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.myDialog == null) {
            this.myDialog = new MyDialog(this.myProject);
            this.myDialog.setTitle(this.myTitle);
            this.myDialog.show();
        }
        this.myDialog.setText(String.valueOf(this.myObject));
    }

    private static class MyDialog
    extends DialogWrapper {
        private final EditorTextField myTextViewer;

        private MyDialog(Project project) {
            super(project, false);
            this.setModal(false);
            this.setCancelButtonText("Close");
            this.setCrossClosesWindow(true);
            this.myTextViewer = new TextViewer("", project, true);
            this.init();
        }

        public void setText(String text) {
            this.myTextViewer.setText(text);
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/ViewTextAction$MyDialog", "createActions"));
            }
            return actionArray;
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.myTextViewer, "Center");
            panel.setPreferredSize((Dimension)JBUI.size((int)300, (int)200));
            return panel;
        }
    }
}

