/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.UiErrorCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.renderers.CellRenderer;
import com.android.tools.idea.editors.gfxtrace.renderers.ImageCellRenderer;
import com.android.tools.idea.editors.gfxtrace.service.ErrDataUnavailable;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.widgets.CellComboBox;
import com.android.tools.idea.editors.gfxtrace.widgets.CellList;
import com.android.tools.idea.editors.gfxtrace.widgets.CellWidget;
import com.android.tools.idea.editors.gfxtrace.widgets.ImageCellList;
import com.android.tools.idea.editors.gfxtrace.widgets.Repaintable;
import com.android.tools.idea.editors.gfxtrace.widgets.Repaintables;
import com.android.tools.rpclib.futures.FutureController;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public abstract class ImageCellController<T extends ImageCellList.Data>
extends Controller
implements CellWidget.SelectionListener<T>,
CellRenderer.CellLoader<T> {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ImageCellController.class);
    @NotNull
    protected CellWidget<T, ?> myList;

    public ImageCellController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/ImageCellController", "<init>"));
        }
        super(editor);
    }

    protected ImageCellController<T> usingListWidget(@NotNull CellList.Orientation orientation, String emptyText, final Dimension maxCellSize) {
        if (orientation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orientation", "com/android/tools/idea/editors/gfxtrace/controllers/ImageCellController", "usingListWidget"));
        }
        this.myList = new ImageCellList<T>(orientation, emptyText, this){

            @Override
            protected Dimension getMaxCellSize() {
                return maxCellSize;
            }
        };
        this.myList.addSelectionListener(this);
        return this;
    }

    protected ImageCellController<T> usingComboBoxWidget(final Dimension imageSize) {
        this.myList = new CellComboBox<T>(this){

            @Override
            protected CellRenderer<T> createCellRenderer(CellRenderer.CellLoader<T> loader) {
                return new ImageCellRenderer<T>(loader, imageSize){
                    {
                        this.setMinimumIconSize(imageSize);
                    }

                    @Override
                    protected Repaintable getRepaintable(JList list) {
                        return Repaintables.forComponents(list, myComponent);
                    }

                    @Override
                    public Dimension getInitialCellSize() {
                        return new Dimension(imageSize.width + 2 * ImageCellRenderer.BORDER_SIZE, imageSize.height + 2 * ImageCellRenderer.BORDER_SIZE);
                    }
                };
            }
        };
        this.myList.addSelectionListener(this);
        return this;
    }

    protected void loadCellImage(final T cell, ServiceClient client, Path imagePath, final Runnable onLoad) {
        Rpc.listen((ListenableFuture)Futures.transform(FetchedImage.load(client, imagePath), (AsyncFunction)new AsyncFunction<FetchedImage, BufferedImage>(){

            public ListenableFuture<BufferedImage> apply(FetchedImage image) throws Exception {
                return ImageCellController.this.getLevelToShow(image);
            }
        }), (Logger)LOG, (FutureController)((ImageCellList.Data)cell).controller, (Rpc.Callback)new UiErrorCallback<BufferedImage, BufferedImage, String>(){

            @Override
            protected UiErrorCallback.ResultOrError<BufferedImage, String> onRpcThread(Rpc.Result<BufferedImage> result) throws RpcException, ExecutionException {
                try {
                    return this.success(result.get());
                }
                catch (ErrDataUnavailable e) {
                    return this.error(e.getMessage());
                }
            }

            @Override
            protected void onUiThreadSuccess(BufferedImage image) {
                cell.stopLoading(new ImageIcon(image));
                onLoad.run();
                ImageCellController.this.myList.repaint();
            }

            @Override
            protected void onUiThreadError(String message) {
                cell.stopLoading(null);
                ImageCellController.this.myList.repaint();
            }
        });
    }

    protected ListenableFuture<BufferedImage> getLevelToShow(FetchedImage image) {
        return image.getLevel(0);
    }
}

