/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.UiErrorCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.service.ErrDataUnavailable;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.image.MultiLevelImage;
import com.android.tools.idea.editors.gfxtrace.widgets.ImagePanel;
import com.android.tools.idea.editors.gfxtrace.widgets.LoadablePanel;
import com.android.tools.rpclib.futures.FutureController;
import com.android.tools.rpclib.futures.SingleInFlight;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.ExecutionException;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class ImagePanelController
extends Controller {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ImagePanelController.class);
    @NotNull
    protected final JPanel myPanel;
    @NotNull
    private final SingleInFlight myImageRequestController;
    @NotNull
    private final ImagePanel myImagePanel;

    public ImagePanelController(@NotNull GfxTraceEditor editor, String emptyText) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/ImagePanelController", "<init>"));
        }
        super(editor);
        this.myPanel = new JPanel(new BorderLayout());
        this.myImagePanel = new ImagePanel();
        this.myImagePanel.getEmptyText().setText(emptyText);
        LoadablePanel loading = new LoadablePanel(this.myImagePanel, LoadablePanel.Style.OPAQUE);
        this.myPanel.add((Component)((Object)loading), "Center");
        this.myImageRequestController = new SingleInFlight((SingleInFlight.Listener)loading);
        this.myImagePanel.setImageRequestController((FutureController)this.myImageRequestController);
    }

    protected void initToolbar(DefaultActionGroup group, boolean enableVerticalFlip) {
        this.myImagePanel.addToolbarActions(group, enableVerticalFlip);
        this.myPanel.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false).getComponent(), "West");
    }

    protected void setEmptyText(String text) {
        this.myImagePanel.clearImage();
        this.myImagePanel.getEmptyText().setText(text);
    }

    protected void setImage(ListenableFuture<FetchedImage> imageFuture) {
        if (imageFuture == null) {
            this.myImagePanel.setImage(null);
            return;
        }
        Rpc.listen(imageFuture, (Logger)LOG, (FutureController)this.myImageRequestController, (Rpc.Callback)new UiErrorCallback<FetchedImage, MultiLevelImage, String>(){

            @Override
            protected UiErrorCallback.ResultOrError<MultiLevelImage, String> onRpcThread(Rpc.Result<FetchedImage> result) throws RpcException, ExecutionException {
                try {
                    return this.success(result.get());
                }
                catch (ErrDataUnavailable e) {
                    return this.error(e.getMessage());
                }
            }

            @Override
            protected void onUiThreadSuccess(MultiLevelImage result) {
                ImagePanelController.this.myImagePanel.setImage(result);
            }

            @Override
            protected void onUiThreadError(String error) {
                ImagePanelController.this.setEmptyText(error);
            }
        });
    }
}

