/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.widgets.CopyEnabledTree;
import com.android.tools.idea.editors.gfxtrace.widgets.LoadablePanel;
import com.android.tools.idea.editors.gfxtrace.widgets.Tree;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeController
extends Controller
implements CopyEnabledTree.ColumnTextProvider {
    public static final int TREE_ROW_HEIGHT = JBUI.scale((int)19);
    @NotNull
    protected final LoadablePanel myLoadingPanel;
    @NotNull
    protected final JPanel myPanel;
    @NotNull
    protected final JBScrollPane myScrollPane;
    @NotNull
    protected final Tree myTree;

    public TreeController(@NotNull GfxTraceEditor editor, @NotNull String emptyText) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/TreeController", "<init>"));
        }
        if (emptyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/android/tools/idea/editors/gfxtrace/controllers/TreeController", "<init>"));
        }
        super(editor);
        this.myPanel = new JPanel(new BorderLayout());
        this.myScrollPane = new JBScrollPane();
        this.myTree = new CopyEnabledTree(new DefaultTreeModel(new DefaultMutableTreeNode()), this);
        this.myPanel.add((Component)this.myScrollPane, "Center");
        this.myTree.setRowHeight(TREE_ROW_HEIGHT);
        this.myTree.setRootVisible(false);
        this.myTree.setLineStyleAngled();
        this.myTree.setCellRenderer(this.getRenderer());
        this.myTree.getEmptyText().setText(emptyText);
        this.myLoadingPanel = new LoadablePanel(new BorderLayout());
        this.myLoadingPanel.getContentLayer().add((Component)((Object)this.myTree));
        this.myScrollPane.setViewportView((Component)((Object)this.myLoadingPanel));
        this.myScrollPane.getHorizontalScrollBar().setUnitIncrement(TREE_ROW_HEIGHT);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(TREE_ROW_HEIGHT);
    }

    @NotNull
    protected abstract TreeCellRenderer getRenderer();

    @Override
    public void clear() {
        this.myTree.setModel(null);
    }

    public void setRoot(DefaultMutableTreeNode root) {
        this.setModel(new DefaultTreeModel(root));
    }

    public void setModel(TreeModel model) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        this.myTree.setModel(model);
        this.myLoadingPanel.stopLoading();
    }

    public TreeModel getModel() {
        return this.myTree.getModel();
    }

    public static void hoverHand(@NotNull Component component, @Nullable Path root, @Nullable Path followPath) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/controllers/TreeController", "hoverHand"));
        }
        boolean validPath = followPath != null && followPath != Path.EMPTY;
        ActionMenu.showDescriptionInStatusBar((boolean)true, (Component)component, validPath ? TreeController.getDisplayTextFor(root, followPath) : null);
        component.setCursor(validPath ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
    }

    @NotNull
    public static String getDisplayTextFor(@Nullable Path root, @NotNull Path path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/gfxtrace/controllers/TreeController", "getDisplayTextFor"));
        }
        ArrayList<Path> pathParts = new ArrayList<Path>();
        while (path != null) {
            pathParts.add(path);
            path = path.getParent();
        }
        ArrayList<Path> rootParts = new ArrayList<Path>();
        while (root != null) {
            rootParts.add(root);
            root = root.getParent();
        }
        for (int i = rootParts.size() - 1; i >= 0 && ((Path)pathParts.get(pathParts.size() - 1)).equals(rootParts.get(i)); --i) {
            pathParts.remove(pathParts.size() - 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((Path)pathParts.get(pathParts.size() - 1)).getSegmentString());
        for (int i = pathParts.size() - 2; i >= 0; --i) {
            ((Path)pathParts.get(i)).appendSegmentToPath(stringBuilder);
        }
        String string = stringBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/TreeController", "getDisplayTextFor"));
        }
        return string;
    }
}

