/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractUninstaller;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatchUninstaller
extends AbstractUninstaller
implements PatchOperation {
    private LocalPackage myPatcher;
    private File myEmptyDir;
    private File myGeneratedPatch;

    public PatchUninstaller(@NotNull LocalPackage p, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/sdk/install/patch/PatchUninstaller", "<init>"));
        }
        if (mgr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/android/tools/idea/sdk/install/patch/PatchUninstaller", "<init>"));
        }
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/PatchUninstaller", "<init>"));
        }
        super(p, mgr, fop);
        this.myPatcher = PatchInstallerUtil.getLatestPatcher(this.getRepoManager());
        this.myEmptyDir = FileOpUtils.getNewTempDir((String)"PatchUninstaller", (FileOp)this.mFop);
        this.registerStateChangeListener((op, progress) -> {
            if (this.getInstallStatus() == PackageOperation.InstallStatus.COMPLETE) {
                this.mFop.deleteFileOrFolder(this.getLocation(progress));
            }
        });
    }

    @Override
    @NotNull
    public LocalPackage getPatcher() {
        LocalPackage localPackage = this.myPatcher;
        if (localPackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchUninstaller", "getPatcher"));
        }
        return localPackage;
    }

    @Override
    @NotNull
    public File getNewFilesRoot() {
        File file = this.myEmptyDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchUninstaller", "getNewFilesRoot"));
        }
        return file;
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        if ("<None>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchUninstaller", "getNewVersionName"));
        }
        return "<None>";
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.getPackage();
    }

    protected boolean doPrepare(@Nullable File installTemp, ProgressIndicator progress) {
        if (this.myPatcher == null) {
            return false;
        }
        this.myGeneratedPatch = PatchInstallerUtil.generatePatch(this, installTemp, this.mFop, progress);
        return this.myGeneratedPatch != null;
    }

    protected boolean doComplete(@Nullable File installTemp, @NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/PatchUninstaller", "doComplete"));
        }
        return PatchInstallerUtil.installPatch(this, this.myGeneratedPatch, this.mFop, progress);
    }
}

