/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.adapters;

import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.adapters.AdapterProperty;
import com.intellij.openapi.util.text.StringUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringToDoubleAdapterProperty
extends AdapterProperty<String, Double> {
    @NotNull
    private final DecimalFormat myFormat;

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty) {
        if (wrappedProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappedProperty", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "<init>"));
        }
        this(wrappedProperty, 1);
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, int numDecimals) {
        if (wrappedProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappedProperty", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "<init>"));
        }
        this(wrappedProperty, numDecimals, numDecimals);
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, int numDecimals, int maxDecimals) {
        if (wrappedProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappedProperty", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "<init>"));
        }
        super(wrappedProperty, 0.0);
        if (maxDecimals < numDecimals) {
            throw new IllegalArgumentException("maxDecimals must be larger or equal to numDecimals");
        }
        this.myFormat = new DecimalFormat("0." + StringUtil.repeat((String)"0", (int)numDecimals) + StringUtil.repeat((String)"#", (int)(maxDecimals - numDecimals)), new DecimalFormatSymbols());
    }

    @Override
    @Nullable
    protected Double convertFromSourceType(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "convertFromSourceType"));
        }
        try {
            ParsePosition pos = new ParsePosition(0);
            Number number = this.myFormat.parse(value, pos);
            if (number != null && pos.getIndex() == value.length()) {
                return number.doubleValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @NotNull
    protected String convertFromDestType(@NotNull Double value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "convertFromDestType"));
        }
        String string = this.myFormat.format(value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "convertFromDestType"));
        }
        return string;
    }
}

