/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.resources.ResourceType;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.module.Module;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowsePanel
extends JPanel {
    private final Context myContext;
    private final ActionButton myBrowseButton;
    private final ActionButton myDesignButton;

    public BrowsePanel(@NotNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel", "<init>"));
        }
        this(context, true);
    }

    public BrowsePanel(@NotNull Context context, boolean showDesignButton) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel", "<init>"));
        }
        this.myContext = context;
        this.myBrowseButton = BrowsePanel.createActionButton(this.createBrowseAction());
        this.myDesignButton = showDesignButton ? BrowsePanel.createActionButton(this.createDesignAction()) : null;
        this.setLayout(new BoxLayout(this, 0));
        this.add((Component)this.myBrowseButton);
        if (this.myDesignButton != null) {
            this.add((Component)this.myDesignButton);
        }
    }

    public void setProperty(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel", "setProperty"));
        }
        this.myBrowseButton.setVisible(BrowsePanel.hasResourceChooser(property));
    }

    public void mousePressed(@NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel", "mousePressed"));
        }
        if (rectRightColumn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rectRightColumn", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel", "mousePressed"));
        }
        if ((double)event.getX() > rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.myDesignButton.getWidth()) {
            this.myDesignButton.click();
        } else if ((double)event.getX() > rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.myDesignButton.getWidth() - (double)this.myBrowseButton.getWidth()) {
            this.myBrowseButton.click();
        }
    }

    private static ActionButton createActionButton(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel", "createActionButton"));
        }
        return new ActionButton(action, action.getTemplatePresentation().clone(), "unknown", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
    }

    private AnAction createBrowseAction() {
        return new AnAction(){

            public void update(AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                NlProperty property = BrowsePanel.this.myContext.getProperty();
                if (property != null && BrowsePanel.hasResourceChooser(property)) {
                    presentation.setIcon(AllIcons.General.Ellipsis);
                    presentation.setText("Click to pick a resource");
                    presentation.setVisible(true);
                    presentation.setEnabled(true);
                } else {
                    presentation.setIcon(null);
                    presentation.setText(null);
                    presentation.setVisible(false);
                    presentation.setEnabled(false);
                }
            }

            public void actionPerformed(AnActionEvent event) {
                BrowsePanel.this.displayResourcePicker();
            }
        };
    }

    private void displayResourcePicker() {
        NlProperty property = this.myContext.getProperty();
        if (property == null) {
            return;
        }
        ChooseResourceDialog dialog = BrowsePanel.showResourceChooser(property);
        this.myContext.cancelEditing();
        if (dialog.showAndGet()) {
            this.myContext.stopEditing(dialog.getResourceName());
        }
    }

    public static ChooseResourceDialog showResourceChooser(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel", "showResourceChooser"));
        }
        Module module = property.getModel().getModule();
        AttributeDefinition definition = property.getDefinition();
        EnumSet<ResourceType> types = BrowsePanel.getResourceTypes(property.getName(), definition);
        return ChooseResourceDialog.builder().setModule(module).setTypes(types).setCurrentValue(property.getValue()).setTag(property.getTag()).build();
    }

    public static boolean hasResourceChooser(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel", "hasResourceChooser"));
        }
        return !BrowsePanel.getResourceTypes(property.getName(), property.getDefinition()).isEmpty();
    }

    @NotNull
    public static EnumSet<ResourceType> getResourceTypes(@NotNull String propertyName, @Nullable AttributeDefinition definition) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel", "getResourceTypes"));
        }
        Set<AttributeFormat> formats = definition != null ? definition.getFormats() : EnumSet.allOf(AttributeFormat.class);
        ResourceType type = AndroidDomUtil.SPECIAL_RESOURCE_TYPES.get(propertyName);
        EnumSet<ResourceType> enumSet = type == null ? AttributeFormat.convertTypes(formats) : EnumSet.of(type);
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel", "getResourceTypes"));
        }
        return enumSet;
    }

    private AnAction createDesignAction() {
        return new AnAction(){

            public void update(AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                switch (this.checkDesignState()) {
                    case MISSING_DESIGN_PROPERTY: {
                        presentation.setIcon(AndroidIcons.NeleIcons.DesignProperty);
                        presentation.setText("Click to specify design property");
                        presentation.setVisible(true);
                        presentation.setEnabled(true);
                        break;
                    }
                    case IS_REMOVABLE_DESIGN_PROPERTY: {
                        presentation.setIcon(AllIcons.Actions.Delete);
                        presentation.setText("Click to remove this design property");
                        presentation.setVisible(true);
                        presentation.setEnabled(true);
                        break;
                    }
                    default: {
                        presentation.setIcon(null);
                        presentation.setText(null);
                        presentation.setVisible(false);
                        presentation.setEnabled(false);
                    }
                }
            }

            public void actionPerformed(AnActionEvent event) {
                switch (this.checkDesignState()) {
                    case MISSING_DESIGN_PROPERTY: {
                        BrowsePanel.this.myContext.addDesignProperty();
                        break;
                    }
                    case IS_REMOVABLE_DESIGN_PROPERTY: {
                        BrowsePanel.this.myContext.removeDesignProperty();
                        break;
                    }
                }
            }

            private DesignState checkDesignState() {
                NlProperty property = BrowsePanel.this.myContext.getProperty();
                if (property == null || BrowsePanel.this.myDesignButton == null) {
                    return DesignState.NOT_APPLICABLE;
                }
                if ("http://schemas.android.com/tools".equals(property.getNamespace())) {
                    NlProperty runtimeProperty = BrowsePanel.this.myContext.getRuntimeProperty();
                    return runtimeProperty != null ? DesignState.IS_REMOVABLE_DESIGN_PROPERTY : DesignState.NOT_APPLICABLE;
                }
                NlProperty designProperty = BrowsePanel.this.myContext.getDesignProperty();
                return designProperty != null ? DesignState.HAS_DESIGN_PROPERTY : DesignState.MISSING_DESIGN_PROPERTY;
            }
        };
    }

    private static enum DesignState {
        NOT_APPLICABLE,
        IS_REMOVABLE_DESIGN_PROPERTY,
        HAS_DESIGN_PROPERTY,
        MISSING_DESIGN_PROPERTY;

    }

    public static interface Context {
        @Nullable
        public NlProperty getProperty();

        @Nullable
        default public NlProperty getDesignProperty() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        default public NlProperty getRuntimeProperty() {
            throw new UnsupportedOperationException();
        }

        default public void cancelEditing() {
        }

        default public void stopEditing(@Nullable Object newValue) {
            NlProperty property = this.getProperty();
            if (property != null) {
                property.setValue(newValue);
            }
        }

        default public void addDesignProperty() {
            throw new UnsupportedOperationException();
        }

        default public void removeDesignProperty() {
            throw new UnsupportedOperationException();
        }
    }
}

