/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.PreferenceUtils;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanIconEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlEnumEditor;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextInspectorProvider
implements InspectorProvider {
    private static final List<String> TEXT_PROPERTIES = ImmutableList.of((Object)"text", (Object)"contentDescription", (Object)"textAppearance", (Object)"fontFamily", (Object)"typeface", (Object)"textSize", (Object)"lineSpacingExtra", (Object)"textStyle", (Object)"textAllCaps", (Object)"textAlignment", (Object)"textColor");
    private TextInspectorComponent myComponent;

    public TextInspectorProvider() {
        LafManager.getInstance().addLafManagerListener(source -> {
            this.myComponent = null;
        });
    }

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider", "isApplicable"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider", "isApplicable"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider", "isApplicable"));
        }
        if (!properties.keySet().containsAll(TEXT_PROPERTIES)) {
            return false;
        }
        for (NlComponent component : components) {
            if (!PreferenceUtils.VALUES.contains(component.getTagName())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider", "createCustomInspector"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider", "createCustomInspector"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider", "createCustomInspector"));
        }
        if (this.myComponent == null) {
            this.myComponent = new TextInspectorComponent(propertiesManager);
        }
        this.myComponent.updateProperties(components, properties, propertiesManager);
        TextInspectorComponent textInspectorComponent = this.myComponent;
        if (textInspectorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider", "createCustomInspector"));
        }
        return textInspectorComponent;
    }

    private static class TextInspectorComponent
    implements InspectorComponent {
        private final NlReferenceEditor myTextEditor;
        private final NlReferenceEditor myDesignTextEditor;
        private final NlReferenceEditor myDescriptionEditor;
        private final NlEnumEditor myStyleEditor;
        private final NlEnumEditor myFontFamilyEditor;
        private final NlEnumEditor myTypefaceEditor;
        private final NlEnumEditor myFontSizeEditor;
        private final NlEnumEditor mySpacingEditor;
        private final NlBooleanIconEditor myBoldEditor;
        private final NlBooleanIconEditor myItalicsEditor;
        private final NlBooleanIconEditor myAllCapsEditor;
        private final NlBooleanIconEditor myStartEditor;
        private final NlBooleanIconEditor myLeftEditor;
        private final NlBooleanIconEditor myCenterEditor;
        private final NlBooleanIconEditor myRightEditor;
        private final NlBooleanIconEditor myEndEditor;
        private final NlReferenceEditor myColorEditor;
        private final JPanel myTextStylePanel;
        private final JPanel myAlignmentPanel;
        private NlProperty myText;
        private NlProperty myDesignText;
        private NlProperty myDescription;
        private NlProperty myStyle;
        private NlProperty myFontFamily;
        private NlProperty myTypeface;
        private NlProperty myFontSize;
        private NlProperty mySpacing;
        private NlFlagPropertyItem myTextStyle;
        private NlProperty myTextAllCaps;
        private NlProperty myAlignment;
        private NlProperty myColor;

        public TextInspectorComponent(@NotNull NlPropertiesManager propertiesManager) {
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider$TextInspectorComponent", "<init>"));
            }
            Project project = propertiesManager.getProject();
            this.myTextEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myDesignTextEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myDescriptionEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myStyleEditor = NlEnumEditor.createForInspector(this.createEnumStyleListener());
            this.myFontFamilyEditor = NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            this.myTypefaceEditor = NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            this.myFontSizeEditor = NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            this.mySpacingEditor = NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            this.myBoldEditor = new NlBooleanIconEditor(AndroidIcons.NeleIcons.TextStyleBold, "Bold");
            this.myItalicsEditor = new NlBooleanIconEditor(AndroidIcons.NeleIcons.TextStyleItalics, "Italics");
            this.myAllCapsEditor = new NlBooleanIconEditor(AndroidIcons.NeleIcons.TextAllCaps, "All Caps");
            this.myStartEditor = new NlBooleanIconEditor(AndroidIcons.NeleIcons.TextAlignViewStart, "Align Start of View", "viewStart");
            this.myLeftEditor = new NlBooleanIconEditor(AndroidIcons.NeleIcons.TextAlignTextStart, "Align Start of Text", "textStart");
            this.myCenterEditor = new NlBooleanIconEditor(AndroidIcons.NeleIcons.TextAlignCentered, "Align Center", "center");
            this.myRightEditor = new NlBooleanIconEditor(AndroidIcons.NeleIcons.TextAlignTextEnd, "Align End of Text", "textEnd");
            this.myEndEditor = new NlBooleanIconEditor(AndroidIcons.NeleIcons.TextAlignViewEnd, "Align End of View", "viewEnd");
            this.myColorEditor = NlReferenceEditor.createForInspectorWithBrowseButton(propertiesManager.getProject(), NlEditingListener.DEFAULT_LISTENER);
            this.myTextStylePanel = new JPanel(new FlowLayout(3));
            this.myTextStylePanel.add(this.myBoldEditor.getComponent());
            this.myTextStylePanel.add(this.myItalicsEditor.getComponent());
            this.myTextStylePanel.add(this.myAllCapsEditor.getComponent());
            this.myAlignmentPanel = new JPanel(new FlowLayout(3));
            this.myAlignmentPanel.add(this.myStartEditor.getComponent());
            this.myAlignmentPanel.add(this.myLeftEditor.getComponent());
            this.myAlignmentPanel.add(this.myCenterEditor.getComponent());
            this.myAlignmentPanel.add(this.myRightEditor.getComponent());
            this.myAlignmentPanel.add(this.myEndEditor.getComponent());
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider$TextInspectorComponent", "updateProperties"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider$TextInspectorComponent", "updateProperties"));
            }
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider$TextInspectorComponent", "updateProperties"));
            }
            this.myText = properties.get("text");
            this.myDesignText = this.myText.getDesignTimeProperty();
            this.myDescription = properties.get("contentDescription");
            this.myStyle = properties.get("textAppearance");
            this.myFontFamily = properties.get("fontFamily");
            this.myTypeface = properties.get("typeface");
            this.myFontSize = properties.get("textSize");
            this.mySpacing = properties.get("lineSpacingExtra");
            this.myTextStyle = (NlFlagPropertyItem)properties.get("textStyle");
            this.myTextAllCaps = properties.get("textAllCaps");
            this.myAlignment = properties.get("textAlignment");
            this.myColor = properties.get("textColor");
        }

        @Override
        public int getMaxNumberOfRows() {
            return 12;
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspector", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider$TextInspectorComponent", "attachToInspector"));
            }
            this.refresh();
            inspector.addTitle("TextView");
            inspector.addComponent("text", this.myText.getTooltipText(), this.myTextEditor.getComponent());
            JLabel designText = inspector.addComponent("text", this.myDesignText.getTooltipText(), this.myDesignTextEditor.getComponent());
            designText.setIcon(AndroidIcons.NeleIcons.DesignProperty);
            inspector.addComponent("contentDescription", this.myDescription.getTooltipText(), this.myDescriptionEditor.getComponent());
            inspector.addExpandableComponent("textAppearance", this.myStyle.getTooltipText(), this.myStyleEditor.getComponent());
            inspector.addComponent("fontFamily", this.myFontFamily.getTooltipText(), this.myFontFamilyEditor.getComponent());
            inspector.addComponent("typeface", this.myTypeface.getTooltipText(), this.myTypefaceEditor.getComponent());
            inspector.addComponent("textSize", this.myFontSize.getTooltipText(), this.myFontSizeEditor.getComponent());
            inspector.addComponent("lineSpacingExtra", this.mySpacing.getTooltipText(), this.mySpacingEditor.getComponent());
            inspector.addComponent("textColor", this.myColor.getTooltipText(), this.myColorEditor.getComponent());
            inspector.addComponent("textStyle", this.myTextStyle.getTooltipText(), this.myTextStylePanel);
            inspector.addComponent("textAlignment", this.myAlignment.getTooltipText(), this.myAlignmentPanel);
        }

        @Override
        public void refresh() {
            this.myTextEditor.setProperty(this.myText);
            this.myDesignTextEditor.setProperty(this.myDesignText);
            this.myDescriptionEditor.setProperty(this.myDescription);
            this.myStyleEditor.setProperty(this.myStyle);
            this.myFontFamilyEditor.setProperty(this.myFontFamily);
            this.myTypefaceEditor.setProperty(this.myTypeface);
            this.myFontSizeEditor.setProperty(this.myFontSize);
            this.mySpacingEditor.setProperty(this.mySpacing);
            this.myBoldEditor.setProperty(this.myTextStyle.getChildProperty("bold"));
            this.myItalicsEditor.setProperty(this.myTextStyle.getChildProperty("italic"));
            this.myAllCapsEditor.setProperty(this.myTextAllCaps);
            this.myStartEditor.setProperty(this.myAlignment);
            this.myLeftEditor.setProperty(this.myAlignment);
            this.myCenterEditor.setProperty(this.myAlignment);
            this.myRightEditor.setProperty(this.myAlignment);
            this.myEndEditor.setProperty(this.myAlignment);
            this.myColorEditor.setProperty(this.myColor);
        }

        @Override
        @Nullable
        public NlComponentEditor getEditorForProperty(@NotNull String propertyName) {
            if (propertyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider$TextInspectorComponent", "getEditorForProperty"));
            }
            switch (propertyName) {
                case "text": {
                    return this.myTextEditor;
                }
            }
            return null;
        }

        private NlEditingListener createEnumStyleListener() {
            return new NlEditingListener(){

                @Override
                public void stopEditing(@NotNull NlComponentEditor editor, @Nullable Object value) {
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider$TextInspectorComponent$1", "stopEditing"));
                    }
                    if (!Objects.equal((Object)value, (Object)myStyle.getValue())) {
                        myStyle.setValue(value);
                        myFontFamily.setValue(null);
                        myFontSize.setValue(null);
                        mySpacing.setValue(null);
                        myTextStyle.setValue(null);
                        myTextAllCaps.setValue(null);
                        myAlignment.setValue(null);
                        myColor.setValue(null);
                        this.refresh();
                    }
                }

                @Override
                public void cancelEditing(@NotNull NlComponentEditor editor) {
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider$TextInspectorComponent$1", "cancelEditing"));
                    }
                }
            };
        }
    }
}

