/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewInspectorProvider
implements InspectorProvider,
ProjectComponent,
LafManagerListener {
    private static final Set<String> TAG_EXCEPTIONS = ImmutableSet.of((Object)"TextView", (Object)"ProgressBar");
    private final ViewHandlerManager myViewHandlerManager;
    private final Map<String, InspectorComponent> myInspectors;

    @NotNull
    public static ViewInspectorProvider getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "getInstance"));
        }
        ViewInspectorProvider viewInspectorProvider = (ViewInspectorProvider)project.getComponent(ViewInspectorProvider.class);
        if (viewInspectorProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "getInstance"));
        }
        return viewInspectorProvider;
    }

    private ViewInspectorProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "<init>"));
        }
        this.myViewHandlerManager = ViewHandlerManager.get(project);
        this.myInspectors = new HashMap<String, InspectorComponent>();
    }

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "isApplicable"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "isApplicable"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "isApplicable"));
        }
        if (components.size() != 1) {
            return false;
        }
        String tagName = components.get(0).getTagName();
        if (TAG_EXCEPTIONS.contains(tagName)) {
            return false;
        }
        if (this.myInspectors.containsKey(tagName)) {
            return true;
        }
        ViewHandler handler = this.myViewHandlerManager.getHandler(tagName);
        if (handler == null || handler.getInspectorProperties().isEmpty()) {
            return false;
        }
        this.myInspectors.put(tagName, new ViewInspectorComponent(tagName, properties, propertiesManager, handler.getInspectorProperties()));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "createCustomInspector"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "createCustomInspector"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "createCustomInspector"));
        }
        assert (components.size() == 1);
        String tagName = components.get(0).getTagName();
        InspectorComponent inspector = this.myInspectors.get(tagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        InspectorComponent inspectorComponent = inspector;
        if (inspectorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "createCustomInspector"));
        }
        return inspectorComponent;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
        LafManager.getInstance().addLafManagerListener((LafManagerListener)this);
    }

    public void disposeComponent() {
        LafManager.getInstance().removeLafManagerListener((LafManagerListener)this);
    }

    public void lookAndFeelChanged(LafManager source) {
        this.myInspectors.clear();
    }

    @NotNull
    public String getComponentName() {
        String string = ViewInspectorProvider.class.getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "getComponentName"));
        }
        return string;
    }

    private static class ViewInspectorComponent
    implements InspectorComponent {
        private static final List<String> LAYOUT_PROPERTIES = ImmutableList.of((Object)"layout_scrollFlags", (Object)"layout_collapseMode", (Object)"layout_collapseParallaxMultiplier", (Object)"layout_behavior");
        private final String myComponentName;
        private final List<String> myPropertyNames;
        private final Map<String, NlComponentEditor> myEditors;
        private Map<String, NlProperty> myProperties;

        public ViewInspectorComponent(@NotNull String tagName, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager, @NotNull List<String> propertyNames) {
            if (tagName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "<init>"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "<init>"));
            }
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "<init>"));
            }
            if (propertyNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyNames", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "<init>"));
            }
            this.myComponentName = tagName.substring(tagName.lastIndexOf(46) + 1);
            this.myPropertyNames = ViewInspectorComponent.combineLists(propertyNames, LAYOUT_PROPERTIES);
            this.useSrcCompatIfExist(properties);
            this.myEditors = new HashMap<String, NlComponentEditor>(propertyNames.size());
            this.myProperties = properties;
            for (String propertyName : propertyNames) {
                NlProperty property = properties.get(propertyName);
                if (property == null) continue;
                this.myEditors.put(propertyName, propertiesManager.getPropertyEditors().create(property));
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "updateProperties"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "updateProperties"));
            }
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "updateProperties"));
            }
            this.myProperties = properties;
            for (String propertyName : this.myPropertyNames) {
                NlProperty property = properties.get(propertyName);
                if (property == null || this.myEditors.containsKey(propertyName)) continue;
                this.myEditors.put(propertyName, propertiesManager.getPropertyEditors().create(property));
            }
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspector", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "attachToInspector"));
            }
            this.refresh();
            inspector.addTitle(this.myComponentName);
            for (String propertyName : this.myPropertyNames) {
                if (!this.myProperties.containsKey(propertyName)) continue;
                NlProperty property = this.myProperties.get(propertyName);
                JLabel label = inspector.addComponent(propertyName, property.getTooltipText(), this.myEditors.get(propertyName).getComponent());
                if (!"http://schemas.android.com/tools".equals(property.getNamespace())) continue;
                label.setIcon(AndroidIcons.NeleIcons.DesignProperty);
            }
        }

        @Override
        public void refresh() {
            for (String propertyName : this.myPropertyNames) {
                if (!this.myProperties.containsKey(propertyName)) continue;
                this.myEditors.get(propertyName).setProperty(this.myProperties.get(propertyName));
            }
        }

        @Override
        @Nullable
        public NlComponentEditor getEditorForProperty(@NotNull String propertyName) {
            if (propertyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "getEditorForProperty"));
            }
            return this.myEditors.get(propertyName);
        }

        @NotNull
        private static List<String> combineLists(@NotNull List<String> list1, @NotNull List<String> list2) {
            if (list1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list1", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "combineLists"));
            }
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list2", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "combineLists"));
            }
            ArrayList<String> combined = new ArrayList<String>(list1.size() + list2.size());
            combined.addAll(list1);
            combined.addAll(list2);
            ArrayList<String> arrayList = combined;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "combineLists"));
            }
            return arrayList;
        }

        private void useSrcCompatIfExist(@NotNull Map<String, NlProperty> properties) {
            int index;
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "useSrcCompatIfExist"));
            }
            if (properties.containsKey("srcCompat") && (index = this.myPropertyNames.indexOf("src")) >= 0) {
                this.myPropertyNames.set(index, "srcCompat");
            }
        }
    }
}

