/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidVersion;
import com.android.tools.klint.checks.PermissionRequirement;
import java.util.Collections;
import java.util.Set;

public interface PermissionHolder {
    public boolean hasPermission(@NonNull String var1);

    public boolean isRevocable(@NonNull String var1);

    @NonNull
    public AndroidVersion getMinSdkVersion();

    @NonNull
    public AndroidVersion getTargetSdkVersion();

    public static class SetPermissionLookup
    implements PermissionHolder {
        private final Set<String> mGrantedPermissions;
        private final Set<String> mRevocablePermissions;
        private final AndroidVersion mMinSdkVersion;
        private final AndroidVersion mTargetSdkVersion;

        public SetPermissionLookup(@NonNull Set<String> grantedPermissions, @NonNull Set<String> revocablePermissions, @NonNull AndroidVersion minSdkVersion, @NonNull AndroidVersion targetSdkVersion) {
            this.mGrantedPermissions = grantedPermissions;
            this.mRevocablePermissions = revocablePermissions;
            this.mMinSdkVersion = minSdkVersion;
            this.mTargetSdkVersion = targetSdkVersion;
        }

        public SetPermissionLookup(@NonNull Set<String> grantedPermissions, @NonNull Set<String> revocablePermissions) {
            this(grantedPermissions, revocablePermissions, AndroidVersion.DEFAULT, AndroidVersion.DEFAULT);
        }

        public SetPermissionLookup(@NonNull Set<String> grantedPermissions) {
            this(grantedPermissions, Collections.emptySet());
        }

        @Override
        public boolean hasPermission(@NonNull String permission) {
            return this.mGrantedPermissions.contains(permission);
        }

        @Override
        public boolean isRevocable(@NonNull String permission) {
            return this.mRevocablePermissions.contains(permission);
        }

        @Override
        @NonNull
        public AndroidVersion getMinSdkVersion() {
            return this.mMinSdkVersion;
        }

        @Override
        @NonNull
        public AndroidVersion getTargetSdkVersion() {
            return this.mTargetSdkVersion;
        }

        @NonNull
        public static PermissionHolder join(@NonNull PermissionHolder lookup, @NonNull PermissionRequirement requirement) {
            SetPermissionLookup empty = new SetPermissionLookup(Collections.emptySet(), Collections.emptySet(), lookup.getMinSdkVersion(), lookup.getTargetSdkVersion());
            return SetPermissionLookup.join(lookup, requirement.getMissingPermissions(empty));
        }

        @NonNull
        public static PermissionHolder join(final @NonNull PermissionHolder lookup, final @Nullable Set<String> permissions) {
            if (permissions != null && !permissions.isEmpty()) {
                return new PermissionHolder(){

                    @Override
                    public boolean hasPermission(@NonNull String permission) {
                        return lookup.hasPermission(permission) || permissions.contains(permission);
                    }

                    @Override
                    public boolean isRevocable(@NonNull String permission) {
                        return lookup.isRevocable(permission);
                    }

                    @Override
                    @NonNull
                    public AndroidVersion getMinSdkVersion() {
                        return lookup.getMinSdkVersion();
                    }

                    @Override
                    @NonNull
                    public AndroidVersion getTargetSdkVersion() {
                        return lookup.getTargetSdkVersion();
                    }
                };
            }
            return lookup;
        }
    }
}

